/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.CommandMessages;
import oracle.eclipse.tools.adf.dtrt.command.CompoundCommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandExecutor;
import oracle.eclipse.tools.adf.dtrt.command.IRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.command.IUndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.IContextCommand;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class OEPEExecutableContextImpl
extends OEPEContextImpl
implements IOEPEExecutableContext {
    private Deque<ICommand> commandDeque = new LinkedList<ICommand>();
    private int limit = Integer.MAX_VALUE;
    private ICommand executeCommand;
    private boolean dirty;
    private ICommand savePointCommand;
    private ICommand.CommandOperation savePointNextOperation;
    private boolean performingOperation;

    @Override
    protected void doDispose() {
        this.dirty = false;
        if (this.commandDeque != null) {
            this.flush();
            this.commandDeque = null;
        }
        super.doDispose();
    }

    @Override
    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.dirty = false;
        this.flush();
        return super.doReset(monitor);
    }

    public final void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid limit: " + limit);
        }
        this.limit = limit;
        while (this.commandDeque.size() > limit) {
            ICommand command = this.commandDeque.removeLast();
            command.dispose();
            if (command != this.savePointCommand || !this.isDirty()) continue;
            this.clearSavePoint();
        }
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void flush() {
        this.clearSavePoint();
        this.executeCommand = null;
        Iterator<ICommand> i = this.commandDeque.iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.commandDeque.clear();
    }

    public final IOEPEExecutableContext setExecuteCommand(ICommand command) {
        if (command != null) {
            this.checkInitialized();
            if (command.isDisposed()) {
                throw new IllegalArgumentException("The command is disposed.");
            }
            if (ICommand.CommandOperation.nextOperation((ICommand)command) != ICommand.CommandOperation.EXECUTION) {
                throw new IllegalArgumentException("The command has been executed.");
            }
            if (command.getCommandStack() != this && (!(command instanceof CompoundCommand) || ((CompoundCommand)command).iterator().hasNext())) {
                throw new IllegalArgumentException("The command was created by a different command stack.");
            }
            if (!(command instanceof IContextCommand || command instanceof CompoundCommand || command instanceof IRunnableCommand || command instanceof IUndoableRunnableCommand)) {
                throw new IllegalArgumentException("The command is not a IContextCommand");
            }
        }
        this.executeCommand = command;
        return this;
    }

    public final ICommand getExecuteCommand() {
        return this.executeCommand;
    }

    public final ICommand getUndoCommand() {
        return this.getMostRecentCommand(ICommand.CommandOperation.UNDO);
    }

    public final ICommand getRedoCommand() {
        return this.getMostRecentCommand(ICommand.CommandOperation.REDO);
    }

    public final ICommand getMostRecentCommand() {
        return this.getMostRecentCommand(null);
    }

    private void setMostRecentCommand(ICommand command) {
        if (DTRTUtil.isNotDisposed((ICommand)command) && this.commandDeque.remove(command)) {
            this.commandDeque.addFirst(command);
        }
    }

    private ICommand getMostRecentCommand(ICommand.CommandOperation nextOperation) {
        assert (nextOperation != ICommand.CommandOperation.EXECUTION);
        if (!this.commandDeque.isEmpty()) {
            ICommand command;
            Iterator<ICommand> i = this.commandDeque.iterator();
            while (i.hasNext()) {
                command = i.next();
                if (!command.isDisposed()) continue;
                i.remove();
                if (command != this.savePointCommand) continue;
                this.clearSavePoint();
            }
            Iterator<ICommand> commandIterator = this.commandDeque.iterator();
            if (commandIterator.hasNext()) {
                command = commandIterator.next();
                if (nextOperation != null) {
                    ICommand.CommandOperation commandNextOperation;
                    do {
                        commandNextOperation = ICommand.CommandOperation.nextOperation((ICommand)command);
                        assert (commandNextOperation == ICommand.CommandOperation.UNDO || commandNextOperation == ICommand.CommandOperation.REDO);
                    } while (commandNextOperation != nextOperation && (command = commandIterator.hasNext() ? commandIterator.next() : null) != null);
                }
                return command;
            }
        }
        return null;
    }

    public final IStatus canExecute() {
        if (this.isDisposed() || !this.isInitialized()) {
            return Status.CANCEL_STATUS;
        }
        ICommand command = this.getExecuteCommand();
        return command != null ? command.canExecute() : Status.CANCEL_STATUS;
    }

    public final IStatus canUndo() {
        if (this.isDisposed() || !this.isInitialized()) {
            return Status.CANCEL_STATUS;
        }
        ICommand command = this.getUndoCommand();
        return command != null ? command.canUndo() : Status.CANCEL_STATUS;
    }

    public final IStatus canRedo() {
        if (this.isDisposed() || !this.isInitialized()) {
            return Status.CANCEL_STATUS;
        }
        ICommand command = this.getRedoCommand();
        return command != null ? command.canRedo() : Status.CANCEL_STATUS;
    }

    public final void execute(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ICommand command = this.getExecuteCommand();
        if (this.performOperation(command, ICommand.CommandOperation.EXECUTION, monitor)) {
            Iterator<ICommand> i = this.commandDeque.iterator();
            while (i.hasNext()) {
                ICommand c = i.next();
                if (ICommand.CommandOperation.nextOperation((ICommand)c) != ICommand.CommandOperation.REDO) continue;
                c.dispose();
                i.remove();
                if (c != this.savePointCommand) continue;
                this.clearSavePoint();
            }
            if (this.commandDeque.size() == this.limit) {
                ICommand c = this.commandDeque.removeLast();
                c.dispose();
                if (c == this.savePointCommand) {
                    this.clearSavePoint();
                }
            }
            this.commandDeque.addFirst(command);
        }
    }

    public final void undo(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ICommand command = this.getUndoCommand();
        if (this.performOperation(command, ICommand.CommandOperation.UNDO, monitor)) {
            this.setMostRecentCommand(command);
        }
    }

    public final void redo(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ICommand command = this.getRedoCommand();
        if (this.performOperation(command, ICommand.CommandOperation.REDO, monitor)) {
            this.setMostRecentCommand(command);
        }
    }

    public boolean isPerformingOperation() {
        return this.performingOperation;
    }

    private boolean performOperation(ICommand command, ICommand.CommandOperation operation, IProgressMonitor monitor) throws InterruptedException, CoreException {
        block17: {
            this.checkInitialized();
            if (command == null) {
                throw new CoreException(DTRTUtil.createErrorStatus((String)NLS.bind((String)CommandMessages.noCommandForOperation, (Object)operation)));
            }
            assert (!command.isDisposed());
            if (command.getCommandStack() != this) {
                throw new CoreException(DTRTUtil.createErrorStatus((String)"The command was created by a different command stack."));
            }
            if (this.isPerformingOperation()) {
                throw new CoreException(DTRTUtil.createErrorStatus((String)("The command stack is already performing an operation. The command '" + command + "' is probably being executed by another command.")));
            }
            try {
                if (!this.notifyPreExecute(command)) break block17;
                boolean beforeIsDirty = this.isDirty();
                try {
                    this.performingOperation = true;
                    switch (operation) {
                        case EXECUTION: {
                            command.execute(monitor);
                            break;
                        }
                        case UNDO: {
                            command.undo(monitor);
                            break;
                        }
                        case REDO: {
                            command.redo(monitor);
                        }
                    }
                }
                finally {
                    this.performingOperation = false;
                }
                if (!beforeIsDirty) {
                    this.savePointCommand = command;
                    this.savePointNextOperation = operation == ICommand.CommandOperation.UNDO ? ICommand.CommandOperation.UNDO : ICommand.CommandOperation.REDO;
                    this.dirty = true;
                } else {
                    this.dirty = !this.didRevertToSavePoint(command);
                }
                this.executeCommand = null;
                this.handleCommandOperation(command, operation);
                this.notifyExecute(command);
                return true;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
                IStatus status = DTRTUtil.createErrorStatus((String)CommandMessages.getOperationErrorMessage((ICommand)command, (ICommand.CommandOperation)operation), (Throwable)e);
                throw new CoreException(status);
            }
        }
        return false;
    }

    protected void handleCommandOperation(ICommand command, ICommand.CommandOperation operationPerformed) {
    }

    private boolean notifyPreExecute(ICommand command) {
        boolean execute = true;
        for (IOEPEContext.IContextListener listener : this.getListeners()) {
            if (!(listener instanceof IOEPEExecutableContext.IExecutableContextListener)) continue;
            try {
                execute &= ((IOEPEExecutableContext.IExecutableContextListener)listener).handlePreCommandOperation((IOEPEExecutableContext)this, command);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
            }
        }
        return execute;
    }

    private void notifyExecute(ICommand command) {
        for (IOEPEContext.IContextListener listener : this.getListeners()) {
            if (!(listener instanceof IOEPEExecutableContext.IExecutableContextListener)) continue;
            try {
                ((IOEPEExecutableContext.IExecutableContextListener)listener).handleCommandOperation((IOEPEExecutableContext)this, command);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
            }
        }
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    private boolean didRevertToSavePoint(ICommand command) {
        return this.savePointCommand == command && this.savePointNextOperation == ICommand.CommandOperation.nextOperation((ICommand)command);
    }

    private void clearSavePoint() {
        this.savePointCommand = null;
        this.savePointNextOperation = null;
    }

    public final void save(IProgressMonitor monitor) throws InterruptedException, CoreException {
        try {
            boolean changed;
            List<IOEPEExecutableContext.IContextSaveParticipant> saveParticipants = this.notifyPreSave();
            IOEPEExecutableContext.ISaveSummary saveSummary = this.doSave(saveParticipants, monitor);
            assert (saveSummary != null);
            boolean bl = changed = saveSummary.getFileCount() > 0;
            if (this.dirty) {
                changed = true;
                this.dirty = false;
            }
            if (changed) {
                this.notifySave(saveSummary);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            DTRTvCommonBundle.log(e);
            IStatus status = DTRTUtil.createErrorStatus((String)Messages.errorSave, (Throwable)e);
            throw new CoreException(status);
        }
    }

    protected abstract IOEPEExecutableContext.ISaveSummary doSave(List<? extends IOEPEExecutableContext.IContextSaveParticipant> var1, IProgressMonitor var2) throws Exception;

    private List<IOEPEExecutableContext.IContextSaveParticipant> notifyPreSave() {
        if (!this.getListeners().isEmpty()) {
            ArrayList<IOEPEExecutableContext.IContextSaveParticipant> saveParticipants = new ArrayList<IOEPEExecutableContext.IContextSaveParticipant>(this.getListeners().size());
            for (IOEPEContext.IContextListener listener : this.getListeners()) {
                if (!(listener instanceof IOEPEExecutableContext.IExecutableContextListener)) continue;
                try {
                    IOEPEExecutableContext.IContextSaveParticipant saveParticipant = ((IOEPEExecutableContext.IExecutableContextListener)listener).handlePreSave((IOEPEExecutableContext)this);
                    if (saveParticipant == null || saveParticipants.contains(saveParticipant)) continue;
                    saveParticipants.add(saveParticipant);
                }
                catch (Exception e) {
                    DTRTvCommonBundle.log(e);
                }
            }
            if (!saveParticipants.isEmpty()) {
                return Collections.unmodifiableList(saveParticipants);
            }
        }
        return Collections.emptyList();
    }

    private void notifySave(IOEPEExecutableContext.ISaveSummary saveSummary) {
        assert (saveSummary != null);
        for (IOEPEContext.IContextListener listener : this.getListeners()) {
            if (!(listener instanceof IOEPEExecutableContext.IExecutableContextListener)) continue;
            try {
                ((IOEPEExecutableContext.IExecutableContextListener)listener).handleSave((IOEPEExecutableContext)this, saveSummary);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
            }
        }
    }

    public final <T extends ICommand> T createCommand(Class<T> commandType) {
        this.checkInitialized();
        return this.doCreateCommand(commandType);
    }

    protected abstract <T extends ICommand> T doCreateCommand(Class<T> var1);

    public final <C extends ICommand> ICommandExecutor<C> createCommandExecutor(Class<? extends ICommandExecutor> commandExecutorType, Class<C> commandType) {
        this.checkInitialized();
        return this.doCreateCommandExecutor(commandExecutorType, commandType);
    }

    protected <C extends ICommand, E extends ICommandExecutor<C>> E doCreateCommandExecutor(Class<E> commandExecutorType, Class<C> commandType) {
        return null;
    }

    private static class Messages
    extends NLS {
        public static String errorSave;

        static {
            NLS.initializeMessages((String)OEPEExecutableContextImpl.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

