/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.context;

import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEExecutableContextImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class OEPEContextImpl
implements IOEPEContext {
    private TypedListenerList<IOEPEContext.IContextListener> listeners = new TypedListenerList();
    private boolean initialized;
    private boolean disposed;

    public static IObjectTranslator getTranslator(IOEPEContext context) {
        return context instanceof OEPEContextImpl ? ((OEPEContextImpl)context).getTranslator() : null;
    }

    public static IObjectValidator getValidator(IOEPEContext context) {
        return context instanceof OEPEContextImpl ? ((OEPEContextImpl)context).getValidator() : null;
    }

    public static boolean isPerformingOperation(IOEPEContext context) {
        return context instanceof OEPEExecutableContextImpl && ((OEPEExecutableContextImpl)context).isPerformingOperation();
    }

    protected OEPEContextImpl() {
    }

    public final void dispose() {
        if (this.listeners != null) {
            for (IOEPEContext.IContextListener listener : this.getListeners()) {
                try {
                    listener.handleDispose((IOEPEContext)this);
                }
                catch (Exception e) {
                    DTRTvCommonBundle.log(e);
                }
            }
        }
        this.doDispose();
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.disposed = true;
    }

    protected void doDispose() {
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public abstract IObjectTranslator getTranslator();

    public abstract IObjectValidator getValidator();

    public final TypedListenerList<IOEPEContext.IContextListener> getListeners() {
        return this.listeners;
    }

    public final void addListener(IOEPEContext.IContextListener listener) {
        this.getListeners().add((Object)listener);
    }

    public final void prependContextListener(IOEPEContext.IContextListener listener) {
        this.getListeners().add((Object)listener);
        int size = this.getListeners().size();
        if (size > 1) {
            Object[] listeners = this.getListeners().getListeners();
            int i = size - 2;
            while (i >= 0) {
                listeners[i + 1] = listeners[i];
                --i;
            }
            listeners[0] = listener;
        }
    }

    public final void removeListener(IOEPEContext.IContextListener listener) {
        if (this.getListeners() != null) {
            this.getListeners().remove((Object)listener);
        }
    }

    public void handleExternalChange() {
        this.notifyExternalChange();
    }

    protected final void notifyExternalChange() {
        for (IOEPEContext.IContextListener listener : this.getListeners()) {
            try {
                listener.handleExternalChange((IOEPEContext)this);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
            }
        }
    }

    protected final <T extends OEPEContextImpl> T initialize(T context) {
        assert (!this.initialized);
        this.initialized = true;
        return context;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final IStatus validate(IObject object, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return DTRTUtil.createErrorStatus((String)Messages.disposedContext);
        }
        if (object != null) {
            IStatus status;
            if (object.isDisposed()) {
                return DTRTUtil.createErrorStatus((String)Messages.getObjectMessage(object, Messages.disposedObject, Messages.disposedUnknownObject));
            }
            String label = DTRTUtil.getLabel((IDescribable)object);
            if (label == null) {
                return DTRTUtil.createErrorStatus((String)Messages.noLabelObject);
            }
            try {
                status = this.getValidator().validate(this, object, monitor);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
                status = DTRTUtil.createErrorStatus((Throwable)e);
            }
            if (status != null) {
                if (status.getSeverity() == 4) {
                    String message = Messages.getObjectMessage(object, Messages.invalidObject, Messages.invalidUnknownObject);
                    MultiStatus errorStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.vcommon", 0, message, null);
                    errorStatus.add(status);
                    return errorStatus;
                }
                if (status.getSeverity() == 2) {
                    String message = Messages.getObjectMessage(object, Messages.mayNotBeValidObject, Messages.mayNotBeValidUnknownObject);
                    MultiStatus errorStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.vcommon", 0, message, null);
                    errorStatus.add(status);
                    return errorStatus;
                }
            }
        }
        return Status.OK_STATUS;
    }

    public final String getNotInContextObjectMessage(IObject object) {
        return Messages.getObjectMessage(object, Messages.notInContextObject, Messages.notInContextUnknownObject);
    }

    protected final void throwNotInitializedException(Throwable throwable) throws CoreException {
        IStatus status = throwable != null ? DTRTUtil.createErrorStatus((String)Messages.notInitializedError, (Throwable)throwable) : DTRTUtil.createErrorStatus((String)Messages.notInitializedError);
        throw new CoreException(status);
    }

    protected final void checkInitialized() throws IllegalStateException {
        this.checkNotDisposed();
        if (!this.isInitialized()) {
            throw new IllegalStateException(Messages.notInitializedError);
        }
    }

    private void checkNotDisposed() throws IllegalStateException {
        if (this.isDisposed()) {
            throw new IllegalStateException(Messages.disposedContext);
        }
    }

    public final void reset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.doReset(monitor)) {
            this.notifyReset();
        }
    }

    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        return false;
    }

    private void notifyReset() {
        for (IOEPEContext.IContextListener listener : this.getListeners()) {
            try {
                listener.handleReset((IOEPEContext)this);
            }
            catch (Exception e) {
                DTRTvCommonBundle.log(e);
            }
        }
    }

    private static class Messages
    extends NLS {
        public static String disposedContext;
        public static String invalidObject;
        public static String invalidUnknownObject;
        public static String mayNotBeValidObject;
        public static String mayNotBeValidUnknownObject;
        public static String notInContextObject;
        public static String notInContextUnknownObject;
        public static String disposedObject;
        public static String disposedUnknownObject;
        public static String notInitializedError;
        public static String noLabelObject;

        static {
            NLS.initializeMessages((String)OEPEContextImpl.class.getName(), Messages.class);
        }

        private Messages() {
        }

        public static String getObjectMessage(IObject object, String objectMessage, String unknownObjectMessage) {
            String label = DTRTUtil.getLabel((IDescribable)object);
            return label != null ? NLS.bind((String)objectMessage, (Object)label) : unknownObjectMessage;
        }
    }
}

