/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.command;

import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandExecutor;
import oracle.eclipse.tools.adf.dtrt.command.ICommandExecutorDelegator;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommandExecutor<C extends ICommand>
implements ICommandExecutor<C> {
    private C command;
    private ICommandExecutorDelegator<C> delegator;

    public CommandExecutor(ICommandStack commandStack, Class<C> commandType) {
        this.command = commandStack.createCommand(commandType);
        if (this.command == null) {
            throw new IllegalArgumentException("Unsupported command type" + commandType);
        }
    }

    protected void dispose() {
        this.command = null;
        this.delegator = null;
    }

    public final C getCommand() {
        return this.command;
    }

    public final void setDelegator(ICommandExecutorDelegator<C> delegator) {
        this.delegator = delegator;
    }

    public final ICommandExecutorDelegator<C> getDelegator() {
        return this.delegator;
    }

    public final void performFinish(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ICommandStack commandStack = this.getCommand().getCommandStack();
        commandStack.setExecuteCommand(this.getCommand());
        try {
            this.aboutToExecute();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException(DTRTUtil.createErrorStatus((Throwable)e));
        }
        if (this.delegator != null) {
            try {
                this.delegator.execute(this.getCommand(), monitor);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException(DTRTUtil.createErrorStatus((Throwable)e));
            }
        } else {
            commandStack.execute(monitor);
        }
        this.dispose();
    }

    protected void aboutToExecute() throws Exception {
    }

    public final void performCancel() {
        this.dispose();
    }
}

