/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.boundsource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.BoundSourceUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.WebPageBoundSourceSubType;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WebPageBoundSource
extends BaseDescribable
implements IPageDefinition.IBoundSource {
    private final IFile file;
    private final String pagePath;
    private WebPageBoundSourceSubType subType;

    private boolean isValid(Document document) {
        return WebPageBoundSourceSubType.isValid(this.subType, document);
    }

    public WebPageBoundSource(IFile file, WebPageBoundSourceSubType subType) {
        if (file == null) {
            throw new IllegalArgumentException("The file argument cannot be null");
        }
        if (subType == null) {
            throw new IllegalArgumentException("The WebPageSourceSubType argument cannot be null");
        }
        IPath path = ProjectUtils.computeWebContentRelativePath((IResource)file);
        if (path == null) {
            throw new IllegalArgumentException("The file argument must be a resource in the web contents folder of a web project");
        }
        String pagePath = path.toString();
        assert (pagePath.length() > 0);
        assert (pagePath.charAt(0) == '/');
        this.file = file;
        this.pagePath = pagePath;
        this.subType = subType;
    }

    public IPageDefinition.IBoundSource.BoundSourceType getType() {
        return IPageDefinition.IBoundSource.BoundSourceType.WEB_PAGE;
    }

    public IFile getFile() {
        return this.file;
    }

    public IStatus appliesTo(Object object) {
        if (object == this.subType) {
            return Status.OK_STATUS;
        }
        if (object instanceof IFile) {
            return object.equals(this.file) ? Status.OK_STATUS : new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Different file");
        }
        if (object instanceof String) {
            return object.equals(this.pagePath) ? Status.OK_STATUS : new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Supported string value: pagePath");
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.isValid(node.getOwnerDocument()) ? Status.OK_STATUS : new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Node not in a web page document");
        }
        return Status.CANCEL_STATUS;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public String getPreferredPageDefinitionFullName() {
        return BoundSourceUtil.computePageDefinitionFullName(DTRTvCommonUtil.removeFileExtension(this.getPagePath()));
    }

    protected BaseDescriptor createDescriptor() {
        return new BaseDescriptor(){

            public String getLabel() {
                return WebPageBoundSource.this.getPagePath();
            }

            public String getToolTipText() {
                return NLS.bind((String)BoundSourceUtil.Messages.webPageToolTip, (Object)WebPageBoundSource.this.getPagePath());
            }

            public ImageManager.IImageData getImageData() {
                ImageManager imageManager = ImageManager.getInstance();
                ImageManager.IImageData data = imageManager.getWorkbenchImageData((Object)WebPageBoundSource.this.getFile());
                return data != null ? data : DTRTBundleIcon.WEB_PAGE;
            }
        };
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WebPageBoundSource other = (WebPageBoundSource)((Object)obj);
        return DTRTUtil.equals((Object)this.file, (Object)other.file);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebPageBoundSource [file=").append(this.file).append("]");
        return builder.toString();
    }

    public Map<Node, List<? extends IBindingObject>> collectUsedBindingObjects(IPageDefinition pageDefinition, Node node) {
        return this.collectUsedBindingObjects(pageDefinition, node, false);
    }

    public boolean usesBindingObjects(IPageDefinition pageDefinition, Node node) {
        return !this.collectUsedBindingObjects(pageDefinition, node, true).isEmpty();
    }

    private Map<Node, List<? extends IBindingObject>> collectUsedBindingObjects(IPageDefinition pageDefinition, Node node, boolean stopIfMapIsNotEmpty) {
        if (pageDefinition != null && node != null) {
            Document document;
            Document document2 = document = node instanceof Document ? (Document)node : node.getOwnerDocument();
            if (this.isValid(document)) {
                if (node == document) {
                    node = document.getDocumentElement();
                }
                LinkedHashMap<Node, List<IBindingObject>> map = new LinkedHashMap<Node, List<IBindingObject>>();
                this.collectUsedBindingObjects(map, pageDefinition, node, stopIfMapIsNotEmpty);
                if (!map.isEmpty()) {
                    return Collections.unmodifiableMap(map);
                }
            }
        }
        return Collections.emptyMap();
    }

    private void collectUsedBindingObjects(Map<Node, List<IBindingObject>> map, IPageDefinition pageDefinition, Node node, boolean stopIfMapIsNotEmpty) {
        List bindingObjects = DTRTObjectUtil.findBindingObjects((IPageDefinition)pageDefinition, (Node)node);
        BoundSourceUtil.putBindings(map, node, bindingObjects);
        if (stopIfMapIsNotEmpty && !map.isEmpty()) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            this.collectUsedBindingObjects(map, pageDefinition, child, stopIfMapIsNotEmpty);
            if (stopIfMapIsNotEmpty && !map.isEmpty()) {
                return;
            }
            ++i;
        }
    }
}

