/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.boundsource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.DTRTvCommonBundle;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.TaskFlowActivityBoundSource;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.WebPageBoundSource;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.WebPageBoundSourceSubType;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoundSourceUtil {
    private static final Set<String> BOUND_SOURCE_TASK_FLOW_ACTIVITY_TYPES;
    private static final String PAGE_DEFINITION_SUFFIX = "PageDef";
    private static final String PAGE_DEFINITION_PACKAGE_SEGMENTS_NO_PACKAGE_DEFAULT = "pageDefs";
    private static final String PAGE_DEFINITION_PACKAGE_SEGMENTS_PACKAGE_DEFAULT = "view";
    private static final String UNBOUNDED_TASK_FLOW_PATH = "WEB-INF/adfc-config.xml";

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("method-call");
        set.add("task-flow-call");
        set.add("router");
        BOUND_SOURCE_TASK_FLOW_ACTIVITY_TYPES = Collections.unmodifiableSet(set);
    }

    private BoundSourceUtil() {
    }

    public static boolean isBindableSource(String activityType) {
        return BOUND_SOURCE_TASK_FLOW_ACTIVITY_TYPES.contains(activityType);
    }

    public static IPageDefinition.IBoundSource createWebPageBoundSource(IFile webPageFile, WebPageBoundSourceSubType ... supportedSubTypes) throws CoreException {
        if (webPageFile != null) {
            WebPageBoundSourceSubType webPageSourceType;
            if (supportedSubTypes == null || supportedSubTypes.length == 0) {
                supportedSubTypes = new WebPageBoundSourceSubType[]{WebPageBoundSourceSubType.JSPX};
            }
            if ((webPageSourceType = BoundSourceUtil.validateWebPageBoundSource(webPageFile, supportedSubTypes)) != null) {
                return new WebPageBoundSource(webPageFile, webPageSourceType);
            }
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Unable to determine WebPageBoundSourceType for: " + webPageFile.getName()));
        }
        return null;
    }

    public static IPageDefinition.IBoundSource createTaskFlowBoundSource(ITaskFlowContext.ITaskFlowProxy taskFlow, Object activity) throws CoreException {
        if (taskFlow != null) {
            BoundSourceUtil.validateTaskFlowBoundSource(taskFlow.getTaskFlowFile());
            return new TaskFlowActivityBoundSource(taskFlow.getTaskFlowFile(), taskFlow.getTaskFlowId(), taskFlow.getActivityId(activity));
        }
        return null;
    }

    private static void validateTaskFlowBoundSource(IFile file) throws CoreException {
        IStructuredModel model = null;
        try {
            try {
                Element documentElement;
                boolean isValid;
                IDOMDocument document;
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                if (model instanceof IDOMModel && (document = ((IDOMModel)model).getDocument()) != null && !(isValid = TaskFlowActivityBoundSource.isValid(file, documentElement = document.getDocumentElement()))) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", NLS.bind((String)Messages.invalidBoundSource, (Object)file)));
                }
            }
            catch (IOException e) {
                throw new CoreException(DTRTUtil.createErrorStatus((String)NLS.bind((String)Messages.invalidBoundSource, (Object)file), (Throwable)e));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static WebPageBoundSourceSubType validateWebPageBoundSource(IFile file, WebPageBoundSourceSubType[] supportedSubTypes) throws CoreException {
        IStructuredModel model = null;
        WebPageBoundSourceSubType webPageSourceType = null;
        try {
            try {
                Element documentElement;
                IDOMDocument document;
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                if (model instanceof IDOMModel && (document = ((IDOMModel)model).getDocument()) != null && (webPageSourceType = WebPageBoundSourceSubType.getWebPageSourceSubType(supportedSubTypes, file, documentElement = document.getDocumentElement())) == null) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", NLS.bind((String)Messages.invalidBoundSource, (Object)file)));
                }
            }
            catch (IOException e) {
                throw new CoreException(DTRTUtil.createErrorStatus((String)NLS.bind((String)Messages.invalidBoundSource, (Object)file), (Throwable)e));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return webPageSourceType;
    }

    static String computePageDefinitionFullName(String pagePath) {
        StringBuilder sb;
        Path path = new Path(pagePath);
        if (path.segmentCount() == 1) {
            sb = new StringBuilder(PAGE_DEFINITION_PACKAGE_SEGMENTS_PACKAGE_DEFAULT).append('.').append(PAGE_DEFINITION_PACKAGE_SEGMENTS_NO_PACKAGE_DEFAULT);
        } else {
            String pkg = path.removeLastSegments(1).toString();
            sb = new StringBuilder(JavaUtil.toJavaIdentifier((String)pkg, (char)'_'));
            if (sb.charAt(0) == '.') {
                sb.deleteCharAt(0);
            }
        }
        sb.append('.').append(JavaUtil.toJavaIdentifier((String)path.lastSegment(), (char)'_')).append(PAGE_DEFINITION_SUFFIX);
        return sb.toString();
    }

    public static IPageDefinition.IBoundSource createBoundSource(IProject webProject, String pagePath, WebPageBoundSourceSubType[] supportedSubTypes) {
        IContainer webContentContainer = ProjectUtils.getWebContentContainer((IProject)webProject);
        if (webContentContainer != null) {
            int atIndex;
            int numberSignIndex = pagePath.indexOf(35, 1);
            if (numberSignIndex > 0 && pagePath.startsWith("PageFlow#")) {
                IFile file = webContentContainer.getFile((IPath)new Path(UNBOUNDED_TASK_FLOW_PATH));
                return new TaskFlowActivityBoundSource(file, null, pagePath.substring(numberSignIndex + 1));
            }
            int n = atIndex = numberSignIndex > 0 ? pagePath.indexOf(64, numberSignIndex) : -1;
            if (atIndex < 0 || atIndex == numberSignIndex + 1 || atIndex == pagePath.length() - 1) {
                IFile file = webContentContainer.getFile((IPath)new Path(pagePath));
                try {
                    return BoundSourceUtil.createWebPageBoundSource(file, supportedSubTypes);
                }
                catch (Exception e) {
                    DTRTvCommonBundle.log(e);
                }
            } else {
                String filePath = pagePath.substring(0, numberSignIndex);
                IFile file = webContentContainer.getFile((IPath)new Path(filePath));
                return new TaskFlowActivityBoundSource(file, pagePath.substring(numberSignIndex + 1, atIndex), pagePath.substring(atIndex + 1));
            }
        }
        return null;
    }

    static void putBindings(Map<Node, List<IBindingObject>> map, Node node, List<? extends IBindingObject> bindingObjects) {
        if (!bindingObjects.isEmpty()) {
            List<IBindingObject> list = map.get(node);
            if (list == null) {
                list = new ArrayList<IBindingObject>(bindingObjects);
                map.put(node, list);
            } else {
                for (IBindingObject iBindingObject : bindingObjects) {
                    if (list.contains(iBindingObject)) continue;
                    list.add(iBindingObject);
                }
            }
        }
    }

    static class Messages
    extends NLS {
        public static String webPageToolTip;
        public static String taskFlowLabel;
        public static String taskFlowToolTip;
        public static String invalidBoundSource;

        static {
            NLS.initializeMessages((String)BoundSourceUtil.class.getName(), Messages.class);
        }

        Messages() {
        }
    }
}

