/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import oracle.eclipse.tools.adf.dtrt.object.IELField;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.object.IELType;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractParentProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IELMetadataPackage;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IPropertyProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IStaticProperty;

public abstract class ExtensibleProperty
extends AbstractParentProperty {
    protected IPropertyProvider[] propertyProviders;
    private int[] propertyLocator;

    private ExtensibleProperty(IPropertyProvider[] propertyProviders) {
        this.propertyProviders = propertyProviders;
    }

    protected IPropertyProvider[] getPropertyProviders() {
        return this.propertyProviders;
    }

    public final IELProperty getProperty(String propertyId) {
        return ELUtil.getProperty(this.getPropertyProviders(), propertyId);
    }

    @Override
    protected final int getPropertyCount() {
        return this.getPropertyLocator().length;
    }

    @Override
    protected AbstractProperty getProperty(int index) {
        return ELUtil.getProperty(this.getPropertyProviders(), this.getPropertyLocator(), index);
    }

    @Override
    protected final int getIndex(Class<? extends IELProperty> type, int typeIndex) {
        return ELUtil.computeIndex(this.getPropertyProviders(), this.getPropertyLocator(), type, typeIndex);
    }

    @Override
    protected final int getPropertyCount(Class<? extends IELProperty> type) {
        return ELUtil.computePropertyCount(this.getPropertyProviders(), this.getPropertyLocator(), type);
    }

    private int[] getPropertyLocator() {
        return this.propertyLocator == null ? (this.propertyLocator = ELUtil.computePropertyLocator(this.getPropertyProviders())) : this.propertyLocator;
    }

    /* synthetic */ ExtensibleProperty(IPropertyProvider[] iPropertyProviderArray, ExtensibleProperty extensibleProperty) {
        this(iPropertyProviderArray);
    }

    public static final class BasicParentField
    extends BasicParentProperty
    implements IELField {
        public BasicParentField(String id, IELType elType, IPropertyProvider[] propertyProviders) {
            super(id, elType, propertyProviders);
        }

        public BasicParentField(String id, IPropertyProvider[] propertyProviders) {
            super(id, propertyProviders);
        }
    }

    public static abstract class BasicParentProperty
    extends ExtensibleProperty {
        private final String id;
        private final IELType elType;
        private ImageManager.IImageData imageData;

        private BasicParentProperty(String id, IPropertyProvider[] propertyProviders) {
            this(id, null, propertyProviders);
        }

        private BasicParentProperty(String id, IELType elType, IPropertyProvider[] propertyProviders) {
            super(propertyProviders, null);
            this.id = id;
            this.elType = elType;
        }

        public String getId() {
            return this.id;
        }

        public void setImageData(ImageManager.IImageData imageData) {
            this.imageData = imageData;
        }

        @Override
        protected ImageManager.IImageData getImageData() {
            return this.imageData != null ? this.imageData : AbstractProperty.getImageData(this);
        }

        @Override
        public IELType getELType() {
            return this.elType != null ? this.elType : super.getELType();
        }
    }

    public static final class DynamicField
    extends DynamicProperty
    implements IELField {
        public DynamicField(IELMetadataPackage metadataPackage, short staticPropertyId, IELType elType, IPropertyProvider[] propertyProviders) {
            super(metadataPackage, staticPropertyId, elType, propertyProviders);
            ELUtil.validateIsField(metadataPackage.getStaticPropertyType(staticPropertyId));
        }

        public DynamicField(IELMetadataPackage metadataPackage, short staticPropertyId, IPropertyProvider[] propertyProviders) {
            super(metadataPackage, staticPropertyId, propertyProviders);
            ELUtil.validateIsField(metadataPackage.getStaticPropertyType(staticPropertyId));
        }
    }

    public static abstract class DynamicProperty
    extends ExtensibleProperty {
        private final IELMetadataPackage metadataPackage;
        private final short staticPropertyId;
        private final IELType elType;

        private DynamicProperty(IELMetadataPackage metadataPackage, short staticPropertyId, IPropertyProvider[] propertyProviders) {
            this(metadataPackage, staticPropertyId, null, propertyProviders);
        }

        private DynamicProperty(IELMetadataPackage metadataPackage, short staticPropertyId, IELType elType, IPropertyProvider[] propertyProviders) {
            super(propertyProviders, null);
            this.metadataPackage = metadataPackage;
            this.staticPropertyId = staticPropertyId;
            this.elType = elType;
        }

        private IStaticProperty getStaticProperty() {
            return this.metadataPackage.getStaticProperty(this.staticPropertyId);
        }

        public String getId() {
            return this.getStaticProperty().getId();
        }

        @Override
        public String getDescription() {
            return this.getStaticProperty().getDescription();
        }

        @Override
        protected ImageManager.IImageData getImageData() {
            return this.getStaticProperty().getImageData();
        }

        @Override
        protected IPropertyProvider[] getPropertyProviders() {
            return ELUtil.appendIfNecessary(this.propertyProviders, this.getStaticProperty());
        }

        @Override
        public IELType getELType() {
            return this.elType != null ? this.elType : this.getStaticProperty().getELType();
        }
    }

    public static final class FieldDecorator
    extends PropertyDecorator
    implements IELField {
        public FieldDecorator(AbstractProperty property, IELType elType, IPropertyProvider[] propertyProviders) {
            super(property, elType, propertyProviders);
            ELUtil.validateIsField(property);
        }

        public FieldDecorator(AbstractProperty property, IPropertyProvider[] propertyProviders) {
            super(property, propertyProviders);
            ELUtil.validateIsField(property);
        }
    }

    public static abstract class PropertyDecorator
    extends ExtensibleProperty {
        private final AbstractProperty property;
        private final IELType elType;

        private PropertyDecorator(AbstractProperty property, IPropertyProvider[] propertyProviders) {
            this(property, null, propertyProviders);
        }

        private PropertyDecorator(AbstractProperty property, IELType elType, IPropertyProvider[] propertyProviders) {
            super(propertyProviders, null);
            this.property = property;
            this.elType = elType;
            assert (property.getProperties().isEmpty()) : property;
        }

        public String getId() {
            return this.property.getId();
        }

        @Override
        public String getDescription() {
            return this.property.getDescription();
        }

        @Override
        protected ImageManager.IImageData getImageData() {
            return this.property.getImageData();
        }

        @Override
        public IELType getELType() {
            return this.elType != null ? this.elType : this.property.getELType();
        }
    }
}

