/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import oracle.eclipse.tools.adf.dtrt.object.IELField;
import oracle.eclipse.tools.adf.dtrt.object.IELMethod;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELMetadataPackageGenerator;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IPropertyProvider;

public final class ELUtil {
    public static final AbstractProperty[] EMPTY_ABSTRACT_PROPERTY_ARRAY = new AbstractProperty[0];

    private ELUtil() {
    }

    public static int computePropertyCount(IPropertyProvider propertyProvider, Class<? extends IELProperty> type) {
        if (type != null && propertyProvider != null) {
            int counter = 0;
            int i = 0;
            int max = propertyProvider.getPropertyCount();
            while (i < max) {
                if (type == propertyProvider.getType(i)) {
                    ++counter;
                }
                ++i;
            }
            return counter;
        }
        return 0;
    }

    public static int computeIndex(IPropertyProvider propertyProvider, Class<? extends IELProperty> type, int typeIndex) {
        int propertyCount;
        if (propertyProvider != null && type != null && (propertyCount = propertyProvider.getPropertyCount()) > typeIndex) {
            int i = 0;
            while (i < propertyCount) {
                if (type == propertyProvider.getType(i)) {
                    if (typeIndex == 0) {
                        return i;
                    }
                    --typeIndex;
                }
                ++i;
            }
        }
        return -1;
    }

    public static Class<? extends IELProperty> computeType(IPropertyProvider propertyProvider, int index) {
        if (propertyProvider != null) {
            AbstractProperty property = propertyProvider.getProperty(index);
            return property instanceof IELField ? IELField.class : (property instanceof IELMethod ? IELMethod.class : null);
        }
        return null;
    }

    public static int computeIndex(IPropertyProvider[] propertyProviders, int[] propertyLocator, Class<? extends IELProperty> type, int typeIndex) {
        if (type != null) {
            int i = 0;
            int max = propertyLocator.length;
            while (i < max) {
                int[] indexes = ELUtil.decodeLocator(propertyLocator, i);
                if (propertyProviders[indexes[0]].getType(indexes[1]) == type) {
                    if (typeIndex == 0) {
                        return i;
                    }
                    --typeIndex;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int computePropertyCount(IPropertyProvider[] propertyProviders, int[] propertyLocator, Class<? extends IELProperty> type) {
        if (type != null) {
            int counter = 0;
            int i = 0;
            int max = propertyLocator.length;
            while (i < max) {
                int[] indexes = ELUtil.decodeLocator(propertyLocator, i);
                if (propertyProviders[indexes[0]].getType(indexes[1]) == type) {
                    ++counter;
                }
                ++i;
            }
            return counter;
        }
        return 0;
    }

    public static IPropertyProvider[] appendIfNecessary(IPropertyProvider[] propertyProviders, IPropertyProvider propertyProvider) {
        if (propertyProvider != null) {
            if (propertyProviders == null || propertyProviders.length == 0) {
                return new IPropertyProvider[]{propertyProvider};
            }
            if (propertyProviders[propertyProviders.length - 1] != propertyProvider) {
                IPropertyProvider[] array = new IPropertyProvider[1 + propertyProviders.length];
                System.arraycopy(propertyProviders, 0, array, 0, propertyProviders.length);
                array[propertyProviders.length] = propertyProvider;
                return array;
            }
        }
        return propertyProviders;
    }

    public static IELProperty getProperty(IPropertyProvider[] propertyProviders, String propertyId) {
        if (propertyId != null) {
            IPropertyProvider[] iPropertyProviderArray = propertyProviders;
            int n = propertyProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyProvider propertyProvider = iPropertyProviderArray[n2];
                IELProperty property = propertyProvider.getProperty(propertyId);
                if (property != null) {
                    return property;
                }
                ++n2;
            }
        }
        return null;
    }

    public static AbstractProperty getProperty(IPropertyProvider[] propertyProviders, int[] propertyLocator, int index) {
        int[] indexes = ELUtil.decodeLocator(propertyLocator, index);
        return propertyProviders[indexes[0]].getProperty(indexes[1]);
    }

    private static int[] decodeLocator(int[] propertyLocator, int index) {
        int locator = propertyLocator[index];
        int propertyProviderMultiplier = ELUtil.computeMultiplier(propertyLocator.length);
        int propertyProviderIndexPlusOne = locator / propertyProviderMultiplier;
        int propertyIndex = locator - propertyProviderIndexPlusOne * propertyProviderMultiplier;
        return new int[]{propertyProviderIndexPlusOne - 1, propertyIndex};
    }

    public static int[] computePropertyLocator(IPropertyProvider[] propertyProviders) {
        int propertyCount = 0;
        IPropertyProvider[] iPropertyProviderArray = propertyProviders;
        int n = propertyProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyProvider propertyProvider = iPropertyProviderArray[n2];
            propertyCount += propertyProvider.getPropertyCount();
            ++n2;
        }
        if (propertyCount > 0) {
            HashMap<String, int[]> propertyIndexesMap = new HashMap<String, int[]>(propertyCount);
            int propertyProviderIndex = 0;
            while (propertyProviderIndex < propertyProviders.length) {
                IPropertyProvider propertyProvider = propertyProviders[propertyProviderIndex];
                String[] propertyIds = propertyProvider.getPropertyIds();
                int propertyIndex = 0;
                while (propertyIndex < propertyIds.length) {
                    String propertyId = propertyIds[propertyIndex];
                    if (!propertyIndexesMap.containsKey(propertyId)) {
                        propertyIndexesMap.put(propertyId, new int[]{propertyProviderIndex, propertyIndex});
                    }
                    ++propertyIndex;
                }
                ++propertyProviderIndex;
            }
            ArrayList propertyIdList = new ArrayList(propertyIndexesMap.keySet());
            Collections.sort(propertyIdList, ELMetadataPackageGenerator.PROPERTIES_COMPARATOR);
            propertyCount = propertyIdList.size();
            int propertyProviderMultiplier = ELUtil.computeMultiplier(propertyCount);
            int[] propertyLocator = new int[propertyCount];
            int counter = 0;
            for (String propertyId : propertyIdList) {
                int[] indexes = (int[])propertyIndexesMap.get(propertyId);
                propertyLocator[counter++] = (indexes[0] + 1) * propertyProviderMultiplier + indexes[1];
            }
            return propertyLocator;
        }
        return new int[0];
    }

    private static int computeMultiplier(int number) {
        int ret = 1;
        while (number > 0) {
            ret *= 10;
            number /= 10;
        }
        return ret;
    }

    public static void validateIsField(IELProperty property) {
        if (!(property instanceof IELField)) {
            throw new IllegalArgumentException("Must be an IELField: " + property);
        }
    }

    public static void validateIsField(Class<? extends IELProperty> type) {
        if (type != IELField.class) {
            throw new IllegalArgumentException("Must IELField: " + type);
        }
    }
}

