/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELType;
import oracle.eclipse.tools.common.util.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ELMetadataPackageGenerator {
    public static final Comparator<Object> PROPERTIES_COMPARATOR = DTRTUtil.COMPARATOR;
    private static final String DEFAULT_EL_TYPE_EXPRESSION = "ELType.STRING";
    private static final String DEFAULT_IMAGE_DATA = "DTRTvCommonBundleIcon.ATTRIBUTE_SM";
    private Set<MetaData> metaDatas;
    private Set<InsightObject> insightObjects;
    private Map<INamedObject, Set<InsightObject>> childrenMap;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("The argument must be the full path for the UIModel EL properties provider XML file");
        }
        URL resourceURL = new File(args[0]).toURI().toURL();
        System.out.println(ELMetadataPackageGenerator.generate(resourceURL));
    }

    private static String getImageData(InsightObject object) {
        if ("collectionModel".equals(object.getName())) {
            return "DTRTvCommonBundleIcon.ACCESSOR_ATTRIBUTE";
        }
        if ("treeModel".equals(object.getName())) {
            return "DTRTvCommonBundleIcon.ACCESSOR_ATTRIBUTE";
        }
        if (object instanceof InsightMethod) {
            return "DTRTvCommonBundleIcon.PUBLIC_METHOD";
        }
        return null;
    }

    public static String generate(URL xmlDefinitionURL) throws Exception {
        ELMetadataPackageGenerator generator = new ELMetadataPackageGenerator();
        generator.load(xmlDefinitionURL);
        return generator.generate();
    }

    private static String getValue(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return DTRTUtil.isEmpty((String)value) ? null : value;
    }

    private static String getResId(Element propertyElement, String elementName) {
        Element element = ELMetadataPackageGenerator.findFirstChildElement(propertyElement, elementName);
        if (element != null) {
            String value = ELMetadataPackageGenerator.getValue(element, "resId");
            if (value == null) {
                value = ELMetadataPackageGenerator.getValue(element, "value");
            }
            return value;
        }
        return null;
    }

    private static Element findFirstChildElement(Element parent, String elementName) {
        NodeList childList = parent.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            Node node = childList.item(i);
            if (node instanceof Element && elementName.equals(node.getNodeName())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private static List<Element> findChildElements(Element parent, String ... elementNames) {
        NodeList childList = parent.getChildNodes();
        if (childList.getLength() > 0) {
            ArrayList<Element> elements = new ArrayList<Element>(childList.getLength());
            int i = 0;
            while (i < childList.getLength()) {
                Node node = childList.item(i);
                if (node instanceof Element && DTRTUtil.indexOf((Object[])elementNames, (Object)node.getNodeName()) >= 0) {
                    elements.add((Element)node);
                }
                ++i;
            }
            return Collections.unmodifiableList(elements);
        }
        return Collections.emptyList();
    }

    private static DocumentBuilder createDocumentBuilder() throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    private ELMetadataPackageGenerator() {
    }

    public boolean load(URL xmlDefinitionURL) throws Exception {
        Element bindingELPropertiesMetaData = this.loadBindingELPropertiesMetaData(xmlDefinitionURL);
        NodeList childList = bindingELPropertiesMetaData.getChildNodes();
        int length = childList.getLength();
        if (length > 0) {
            this.metaDatas = new LinkedHashSet<MetaData>(length);
            this.insightObjects = new LinkedHashSet<InsightObject>(length * 5);
            this.childrenMap = new HashMap<INamedObject, Set<InsightObject>>(length * 6);
            int i = 0;
            while (i < childList.getLength()) {
                Node childNode = childList.item(i);
                if (childNode instanceof Element) {
                    this.addMetaData((Element)childNode);
                }
                ++i;
            }
            this.adjustModel();
            this.validateLoadedData();
            return true;
        }
        return false;
    }

    private Element loadBindingELPropertiesMetaData(URL url) throws Exception {
        DocumentBuilder documentBuilder = ELMetadataPackageGenerator.createDocumentBuilder();
        Document document = documentBuilder.parse(url.openStream());
        Element documentElement = document.getDocumentElement();
        return documentElement != null && "bindingElPropertiesMetaData".equals(documentElement.getNodeName()) ? documentElement : null;
    }

    private void addMetaData(Element metaDataElement) {
        MetaData metaData = new MetaData(metaDataElement);
        if (!this.metaDatas.add(metaData)) {
            throw new IllegalStateException("Duplicated meta data: " + metaData);
        }
        this.addChildren(metaData, metaDataElement);
    }

    private Set<InsightObject> addChildren(INamedObject namedObject, Element namedObjectElement) {
        List<Element> childElements = ELMetadataPackageGenerator.findChildElements(namedObjectElement, "insightProperty", "insightMethod");
        if (!childElements.isEmpty()) {
            LinkedHashSet<InsightObject> children = new LinkedHashSet<InsightObject>(childElements.size());
            if (this.childrenMap.put(namedObject, children) != null) {
                throw new IllegalStateException("namedObject has children: " + namedObject);
            }
            for (Element childElement : childElements) {
                InsightObject child = this.addInsightObject(childElement);
                children.add(child);
            }
            return children;
        }
        return null;
    }

    private InsightObject addInsightObject(Element element) {
        Element childrenElement;
        InsightObject insightObject;
        if ("insightProperty".equals(element.getNodeName())) {
            InsightProperty property = new InsightProperty(element);
            insightObject = property;
            childrenElement = property.getChildrenPropertiesElement();
        } else {
            insightObject = new InsightMethod(element);
            childrenElement = null;
        }
        if (this.insightObjects.add(insightObject) && childrenElement != null) {
            this.addChildren(insightObject, childrenElement);
        }
        return insightObject;
    }

    private void adjustModel() {
        for (MetaData metaData : this.metaDatas) {
            this.handleExtension(new HashSet<MetaData>(), metaData);
        }
        for (MetaData metaData : this.metaDatas) {
            this.handleHidden(metaData);
        }
        for (InsightObject insightObject : this.insightObjects) {
            this.handleExtension(insightObject);
        }
    }

    private void handleExtension(Set<MetaData> handled, MetaData metaData) {
        MetaData extended;
        if (!handled.contains(metaData) && (extended = this.findMetaData(metaData.getExtend())) != null) {
            this.handleExtension(handled, extended);
            this.basicHandleExtension(metaData, extended);
            handled.add(metaData);
        }
    }

    private MetaData findMetaData(String name) {
        if (name != null) {
            for (MetaData metaData : this.metaDatas) {
                if (!name.equals(metaData.getName())) continue;
                return metaData;
            }
        }
        return null;
    }

    private void handleExtension(InsightObject insightObject) {
        if (insightObject instanceof InsightProperty) {
            InsightProperty property = (InsightProperty)insightObject;
            this.basicHandleExtension(property, this.findMetaData(property.getExtend()));
        }
    }

    private void basicHandleExtension(INamedObject namedObject, MetaData extended) {
        Set<InsightObject> extendedChildren;
        if (extended != null && (extendedChildren = this.childrenMap.get(extended)) != null) {
            Set<InsightObject> children = this.childrenMap.get(namedObject);
            if (children == null) {
                children = new LinkedHashSet<InsightObject>();
                this.childrenMap.put(namedObject, children);
            }
            children.addAll(extendedChildren);
        }
    }

    private void handleHidden(MetaData metaData) {
        Set<InsightObject> children;
        if (!metaData.getHidden().isEmpty() && (children = this.childrenMap.get(metaData)) != null) {
            Iterator<InsightObject> i = children.iterator();
            while (i.hasNext()) {
                String childName = i.next().getName();
                if (!metaData.getHidden().contains(childName)) continue;
                i.remove();
            }
        }
    }

    private void validateLoadedData() {
        for (Map.Entry<INamedObject, Set<InsightObject>> entry : this.childrenMap.entrySet()) {
            Set<InsightObject> children = entry.getValue();
            if (children.isEmpty()) {
                throw new IllegalStateException("Empty children for " + entry.getKey());
            }
            if (!this.insightObjects.containsAll(children)) {
                throw new IllegalStateException("There are children that are not in the insight objects set.");
            }
            HashSet<String> names = new HashSet<String>(children.size());
            for (InsightObject child : children) {
                if (names.add(child.getName())) continue;
                throw new IllegalStateException("Duplicated property name '" + child.getName() + "' for " + entry.getKey());
            }
        }
    }

    public String generate() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        this.generateImports(nl, sb);
        sb.append(nl);
        sb.append(nl).append("/**");
        sb.append(nl).append(" * Generated code. Do not make any modification.");
        sb.append(nl).append(" * @see ").append(this.getClass().getName());
        sb.append(nl).append(" */");
        sb.append(nl).append("final class ELMetadataPackage implements IELMetadataPackage {");
        sb.append(nl);
        sb.append(nl).append("\t").append("/**");
        sb.append(nl).append("\t").append(" * @param metadata");
        sb.append(nl).append("\t").append(" * @return the positive, static id for the metadata or a negative number");
        sb.append(nl).append("\t").append(" */");
        sb.append(nl).append("\t").append("public static short getStaticId(IELMetadata metadata) {");
        sb.append(nl).append("\t\t").append("return metadata instanceof StaticMetadata ? ((StaticMetadata)metadata).getStaticId() : -1;");
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("/**");
        sb.append(nl).append("\t").append(" * @param property");
        sb.append(nl).append("\t").append(" * @return the positive, static id for the property or a negative number");
        sb.append(nl).append("\t").append(" */");
        sb.append(nl).append("\t").append("public static short getStaticId(IELProperty property) {");
        sb.append(nl).append("\t\t").append("return property instanceof StaticProperty ? ((StaticProperty)property).getStaticId() : -1;");
        sb.append(nl).append("\t").append('}');
        this.generateMessages(nl, sb);
        Map<INamedObject, JavaMembers> javaMembersMap = this.generateStaticIds(nl, sb);
        this.generateSwitchMethods(nl, sb, javaMembersMap);
        this.generateFields(nl, sb, javaMembersMap);
        this.generateGetters(nl, sb, javaMembersMap);
        this.generateMetadataClasses(nl, sb, javaMembersMap);
        this.generateStaticGetters(nl, sb, javaMembersMap);
        this.generatePropertyClasses(nl, sb, javaMembersMap);
        this.generateFieldClasses(nl, sb);
        this.generateMethodClasses(nl, sb, javaMembersMap);
        sb.append(nl).append('}');
        return sb.toString();
    }

    private void generateImports(String nl, StringBuilder sb) {
        String[] stringArray = new String[20];
        stringArray[0] = "java.util.AbstractList";
        stringArray[1] = "java.util.Collections";
        stringArray[2] = "java.util.List";
        stringArray[4] = "oracle.eclipse.tools.adf.dtrt.object.IELField";
        stringArray[5] = "oracle.eclipse.tools.adf.dtrt.object.IELMetadata";
        stringArray[6] = "oracle.eclipse.tools.adf.dtrt.object.IELMethod";
        stringArray[7] = "oracle.eclipse.tools.adf.dtrt.object.IELProperty";
        stringArray[8] = "oracle.eclipse.tools.adf.dtrt.object.IELType";
        stringArray[9] = "oracle.eclipse.tools.adf.dtrt.util.ImageManager.IImageData";
        stringArray[10] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractParentProperty";
        stringArray[11] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty";
        stringArray[12] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELType";
        stringArray[13] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELUtil";
        stringArray[14] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IELMetadataPackage";
        stringArray[15] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IStaticMetadata";
        stringArray[16] = "oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IStaticProperty";
        stringArray[17] = "oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon";
        stringArray[19] = "org.eclipse.osgi.util.NLS";
        String[] imports = stringArray;
        sb.append(nl);
        String[] stringArray2 = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            String imp = stringArray2[n2];
            sb.append(nl);
            if (imp != null) {
                sb.append("import ").append(imp).append(';');
            }
            ++n2;
        }
    }

    private void generateMessages(String nl, StringBuilder sb) {
        if (!this.insightObjects.isEmpty()) {
            LinkedHashSet<String> messages = new LinkedHashSet<String>((int)((double)this.insightObjects.size() * 1.3));
            for (InsightObject insightObject : this.insightObjects) {
                messages.add(insightObject.getTooltipResId());
                messages.add(insightObject.getLongLabelResId());
            }
            sb.append(nl);
            sb.append(nl).append("\t").append("private static class Messages extends NLS {");
            for (String message : messages) {
                sb.append(nl).append("\t\t").append("public static String ").append(message).append(';');
            }
            sb.append(nl);
            sb.append(nl).append("\t\t").append("static {");
            sb.append(nl).append("\t\t\t").append("NLS.initializeMessages(Messages.class.getPackage().getName() + \".ElPropertyAttributes\", Messages.class); //$NON-NLS-1$");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl).append("\t").append('}');
        }
    }

    private Map<INamedObject, JavaMembers> generateStaticIds(String nl, StringBuilder sb) {
        int capacity = this.metaDatas.size() + this.insightObjects.size();
        LinkedHashMap<INamedObject, JavaMembers> javaMembersMap = new LinkedHashMap<INamedObject, JavaMembers>(capacity);
        Pair pair = JavaUtil.collectMemberNames(Object.class);
        Set fieldNames = (Set)pair.getFirst();
        Set getterNames = (Set)pair.getSecond();
        int idCounter = 0;
        sb.append(nl);
        Iterator<InsightObject> o = this.insightObjects.iterator();
        Iterator<MetaData> m = this.metaDatas.iterator();
        Iterator<INamedObject> i = o;
        while (i.hasNext()) {
            INamedObject namedObject = i.next();
            JavaMembers javaMembers = this.computeJavaMembers(fieldNames, getterNames, namedObject);
            javaMembersMap.put(namedObject, javaMembers);
            sb.append(nl).append("\t").append("public static final short ").append(javaMembers.staticId).append(" = ").append(++idCounter).append(';');
            if (i != o || o.hasNext()) continue;
            sb.append(nl);
            i = m;
        }
        return javaMembersMap;
    }

    private JavaMembers computeJavaMembers(Set<String> fieldNames, Set<String> getterNames, INamedObject namedObject) {
        String staticIdPrefix;
        JavaMembers javaMembers = new JavaMembers();
        String string = namedObject instanceof MetaData ? "MTDT_" : (namedObject instanceof InsightProperty ? "PROP_" : (staticIdPrefix = namedObject instanceof InsightMethod ? "METH_" : null));
        assert (staticIdPrefix != null) : namedObject;
        javaMembers.staticId = JavaUtil.toFieldName((String)(String.valueOf(staticIdPrefix) + namedObject.getName()), (boolean)true, fieldNames);
        fieldNames.add(javaMembers.staticId);
        String memberPrefix = namedObject instanceof MetaData ? "metadata" : (namedObject instanceof InsightProperty ? "property" : (namedObject instanceof InsightMethod ? "method" : null));
        String memberName = String.valueOf(memberPrefix) + DTRTUtil.upperCaseFirstLetter((String)namedObject.getName());
        javaMembers.field = JavaUtil.toFieldName((String)memberName, (boolean)false, fieldNames);
        fieldNames.add(javaMembers.field);
        javaMembers.getter = JavaUtil.toGetterName((String)memberName, (boolean)false, getterNames);
        getterNames.add(javaMembers.getter);
        if (this.childrenMap.containsKey(namedObject)) {
            javaMembers.parentInsightObjectField = JavaUtil.toFieldName((String)(String.valueOf(javaMembers.field) + "Parent"), (boolean)false, fieldNames);
            fieldNames.add(javaMembers.parentInsightObjectField);
            javaMembers.parentInsightObjectGetter = JavaUtil.toGetterName((String)(String.valueOf(javaMembers.getter) + "Parent"), (boolean)false, getterNames);
            getterNames.add(javaMembers.parentInsightObjectGetter);
        }
        return javaMembers;
    }

    private void generateSwitchMethods(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        JavaMembers javaMembers;
        JavaMembers javaMembers2;
        sb.append(nl);
        sb.append(nl).append("\t").append("@Override");
        sb.append(nl).append("\t").append("public IStaticProperty getStaticProperty(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        boolean firstNamedObject = true;
        for (InsightObject insightObject : this.insightObjects) {
            if (firstNamedObject) {
                firstNamedObject = false;
            } else {
                sb.append(nl);
            }
            JavaMembers javaMembers22 = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers22.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return ").append(javaMembers22.parentInsightObjectField != null ? javaMembers22.parentInsightObjectGetter : javaMembers22.getter).append("();");
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append("return null;");
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("@Override");
        sb.append(nl).append("\t").append("public IStaticMetadata getStaticMetadata(short staticId, boolean parentProperties) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        firstNamedObject = true;
        for (MetaData metaData : this.metaDatas) {
            if (firstNamedObject) {
                firstNamedObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers2 = javaMembersMap.get(metaData);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers2.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return parentProperties ? ").append(javaMembers2.parentInsightObjectGetter).append("() : ").append(javaMembers2.getter).append("();");
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append("return null;");
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("public short getMetadataStaticId(String elementTag) {");
        sb.append(nl).append("\t\t").append("if (elementTag != null) {");
        sb.append(nl).append("\t\t\t").append("elementTag = elementTag.intern();");
        sb.append(nl).append("\t\t\t").append("return");
        for (MetaData metaData : this.metaDatas) {
            javaMembers2 = javaMembersMap.get(metaData);
            sb.append(nl).append("\t\t\t\t").append("elementTag == \"").append(metaData.getName()).append("\" ? ");
            sb.append(javaMembers2.staticId).append(" : //$NON-NLS-1$");
        }
        sb.append(nl).append("\t\t\t\t").append("-1;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append("return -1;");
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("@Override");
        sb.append(nl).append("\t").append("public Class<? extends IELProperty> getStaticPropertyType(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        Collection<InsightMethod> methods = this.filterMethods(this.insightObjects);
        for (InsightObject insightObject : this.insightObjects) {
            if (methods.contains(insightObject)) continue;
            javaMembers = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers.staticId).append(':');
        }
        sb.append(nl).append("\t\t\t\t").append("return IELField.class;");
        if (!methods.isEmpty()) {
            sb.append(nl);
            for (InsightObject insightObject : methods) {
                javaMembers = javaMembersMap.get(insightObject);
                sb.append(nl).append("\t\t\t").append("case ").append(javaMembers.staticId).append(':');
            }
            sb.append(nl).append("\t\t\t\t").append("return IELMethod.class;");
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append("return null;");
        sb.append(nl).append("\t").append('}');
    }

    private void generateFields(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        JavaMembers javaMembers;
        sb.append(nl);
        for (InsightObject insightObject : this.insightObjects) {
            javaMembers = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t").append("private ").append(insightObject instanceof InsightProperty ? "StaticField " : "StaticMethod ").append(javaMembers.field).append(';');
            if (javaMembers.parentInsightObjectField == null) continue;
            sb.append(nl).append("\t").append("private ").append(insightObject instanceof InsightProperty ? "StaticParentField " : "StaticParentMethod ").append(javaMembers.parentInsightObjectField).append(';');
        }
        sb.append(nl);
        for (MetaData metaData : this.metaDatas) {
            javaMembers = javaMembersMap.get(metaData);
            sb.append(nl).append("\t").append("private StaticMetadata ").append(javaMembers.field).append(';');
            sb.append(nl).append("\t").append("private StaticMetadataWithParentProperty ").append(javaMembers.parentInsightObjectField).append(';');
        }
    }

    private void generateGetters(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        JavaMembers javaMembers;
        for (InsightObject insightObject : this.insightObjects) {
            javaMembers = javaMembersMap.get(insightObject);
            String className = insightObject instanceof InsightProperty ? "StaticField" : "StaticMethod";
            this.generateGetter(nl, sb, javaMembers.staticId, javaMembers.field, javaMembers.getter, className, className);
            if (javaMembers.parentInsightObjectField == null) continue;
            className = insightObject instanceof InsightProperty ? "StaticParentField" : "StaticParentMethod";
            this.generateGetter(nl, sb, javaMembers.staticId, javaMembers.parentInsightObjectField, javaMembers.parentInsightObjectGetter, className, className);
        }
        for (MetaData metaData : this.metaDatas) {
            javaMembers = javaMembersMap.get(metaData);
            this.generateGetter(nl, sb, javaMembers.staticId, javaMembers.field, javaMembers.getter, "StaticMetadata", "StaticMetadata");
            this.generateGetter(nl, sb, javaMembers.staticId, javaMembers.parentInsightObjectField, javaMembers.parentInsightObjectGetter, "StaticMetadataWithParentProperty", "StaticMetadataWithParentProperty");
        }
    }

    private void generateGetter(String nl, StringBuilder sb, String staticId, String field, String getter, String returnType, String javaType) {
        sb.append(nl);
        sb.append(nl).append("\t").append("private ").append(returnType).append(' ').append(getter).append("() {");
        sb.append(nl).append("\t\t").append("return ").append(field).append(" == null ?").append(' ').append(field).append(" = new ").append(javaType).append('(').append(staticId).append(')').append(" : ").append(field).append(';');
        sb.append(nl).append("\t").append('}');
    }

    private void generateMetadataClasses(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        this.generateMetadataClass(nl, sb, javaMembersMap, false, "private class StaticMetadata implements IStaticMetadata {", "StaticMetadata");
        this.generateMetadataClass(nl, sb, javaMembersMap, true, "private final class StaticMetadataWithParentProperty extends StaticMetadata {", "StaticMetadataWithParentProperty");
    }

    private void generateMetadataClass(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap, boolean parentProperty, String classDeclaration, String classSimpleName) {
        sb.append(nl);
        sb.append(nl).append("\t").append(classDeclaration);
        if (!parentProperty) {
            sb.append(nl).append("\t\t").append("private final short staticId;");
            sb.append(nl).append("\t\t").append("private List<AbstractProperty> properties;");
        }
        sb.append(nl);
        sb.append(nl).append("\t\t").append("private ").append(classSimpleName).append("(short staticId) {");
        if (!parentProperty) {
            sb.append(nl).append("\t\t\t").append("this.staticId = staticId;");
        } else {
            sb.append(nl).append("\t\t\t").append("super(staticId);");
        }
        sb.append(nl).append("\t\t").append('}');
        if (!parentProperty) {
            sb.append(nl);
            sb.append(nl).append("\t\t").append("public final short getStaticId() {");
            sb.append(nl).append("\t\t\t").append("return staticId;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final List<AbstractProperty> getProperties() {");
            sb.append(nl).append("\t\t\t").append("if (properties == null) {");
            sb.append(nl).append("\t\t\t\t").append("properties = new AbstractList<AbstractProperty>() {");
            sb.append(nl).append("\t\t\t\t\t").append("@Override");
            sb.append(nl).append("\t\t\t\t\t").append("public int size() {");
            sb.append(nl).append("\t\t\t\t\t\t").append("return getPropertyCount();");
            sb.append(nl).append("\t\t\t\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t\t\t\t").append("@Override");
            sb.append(nl).append("\t\t\t\t\t").append("public AbstractProperty get(int index) {");
            sb.append(nl).append("\t\t\t\t\t\t").append("return getProperty(index);");
            sb.append(nl).append("\t\t\t\t\t").append('}');
            sb.append(nl).append("\t\t\t\t").append("};");
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return properties;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final boolean hasStaticProperty(short staticPropertyId) {");
            sb.append(nl).append("\t\t\t").append("if (staticPropertyId >= 0) {");
            sb.append(nl).append("\t\t\t\t").append("switch(getStaticId()) {");
            boolean firstNamedObject = true;
            for (INamedObject iNamedObject : this.metaDatas) {
                Set<InsightObject> children = this.childrenMap.get(iNamedObject);
                if (children == null) continue;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                JavaMembers javaMembers = javaMembersMap.get(iNamedObject);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(": {");
                sb.append(nl).append("\t\t\t\t\t").append("switch(staticPropertyId) {");
                for (InsightObject child : children) {
                    JavaMembers childJavaMembers = javaMembersMap.get(child);
                    sb.append(nl).append("\t\t\t\t\t\t").append("case ").append(childJavaMembers.staticId).append(':');
                }
                sb.append(nl).append("\t\t\t\t\t\t\t").append("return true;");
                sb.append(nl).append("\t\t\t\t\t").append('}');
                sb.append(nl).append("\t\t\t\t").append('}');
                sb.append(nl).append("\t\t\t\t").append("break;");
            }
            sb.append(nl).append("\t\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return false;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final String getType() {");
            sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
            firstNamedObject = true;
            for (MetaData metaData : this.metaDatas) {
                if (metaData.getOEPEELType() == null) continue;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                JavaMembers javaMembers = javaMembersMap.get(metaData);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(':');
                sb.append(nl).append("\t\t\t\t\t").append("return \"").append(metaData.getOEPEELType()).append("\"; //$NON-NLS-1$");
            }
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return null;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final <T extends IELProperty> List<? extends T> getProperties(final Class<T> type) {");
            sb.append(nl).append("\t\t\t").append("if (type != null) {");
            sb.append(nl).append("\t\t\t\t").append("List<T> properties = new AbstractList<T>() {");
            sb.append(nl).append("\t\t\t\t\t").append("@Override");
            sb.append(nl).append("\t\t\t\t\t").append("public int size() {");
            sb.append(nl).append("\t\t\t\t\t\t").append("return getPropertyCount(type);");
            sb.append(nl).append("\t\t\t\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t\t\t\t").append("@Override");
            sb.append(nl).append("\t\t\t\t\t").append("public T get(int index) {");
            sb.append(nl).append("\t\t\t\t\t\t").append("return type.cast(getProperty(getIndex(type, index)));");
            sb.append(nl).append("\t\t\t\t\t").append('}');
            sb.append(nl).append("\t\t\t\t").append("};");
            sb.append(nl).append("\t\t\t\t").append("return properties;");
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return Collections.emptyList();");
            sb.append(nl).append("\t\t").append('}');
        }
        String unknownMetadataException = "throw new IllegalStateException(\"Unknown metadata: \" + getStaticId()); //$NON-NLS-1$";
        this.generateCommonClassParts(nl, sb, javaMembersMap, parentProperty, this.metaDatas, unknownMetadataException);
        if (!parentProperty) {
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@SuppressWarnings(\"nls\")");
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final String toString() {");
            sb.append(nl).append("\t\t\t").append("StringBuilder builder = new StringBuilder();");
            sb.append(nl).append("\t\t\t").append("builder.append(getClass().getSimpleName()).append(\" [staticId=\").append(getStaticId()).append(\"]\");");
            sb.append(nl).append("\t\t\t").append("return builder.toString();");
            sb.append(nl).append("\t\t").append('}');
        }
        sb.append(nl).append("\t").append('}');
    }

    private void generateStaticGetters(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        JavaMembers javaMembers;
        JavaMembers javaMembers2;
        String unknownPropertyException = "throw new IllegalStateException(\"Unknown property: \" + staticId); //$NON-NLS-1$";
        sb.append(nl);
        sb.append(nl).append("\t").append("private static String getPropertyId(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        boolean firstInsightObject = true;
        for (InsightObject insightObject : this.insightObjects) {
            if (firstInsightObject) {
                firstInsightObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers2 = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers2.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return \"").append(insightObject.getName()).append("\"; //$NON-NLS-1$");
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append(unknownPropertyException);
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("private static String getPropertyToolTipText(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        firstInsightObject = true;
        for (InsightObject insightObject : this.insightObjects) {
            if (firstInsightObject) {
                firstInsightObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers2 = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers2.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return Messages.").append(insightObject.getTooltipResId()).append(';');
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append(unknownPropertyException);
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("private static String getPropertyDescription(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        firstInsightObject = true;
        for (InsightObject insightObject : this.insightObjects) {
            if (firstInsightObject) {
                firstInsightObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers2 = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers2.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return Messages.").append(insightObject.getLongLabelResId()).append(';');
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append(unknownPropertyException);
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("private static IImageData getPropertyImageData(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        firstInsightObject = true;
        for (InsightObject insightObject : this.insightObjects) {
            String imageData = ELMetadataPackageGenerator.getImageData(insightObject);
            if (imageData == null) continue;
            if (firstInsightObject) {
                firstInsightObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return ").append(imageData).append(';');
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append("return ").append(DEFAULT_IMAGE_DATA).append(';');
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("private static IELType getPropertyELType(short staticId) {");
        sb.append(nl).append("\t\t").append("switch(staticId) {");
        firstInsightObject = true;
        for (InsightObject insightObject : this.insightObjects) {
            String type = null;
            if (insightObject instanceof InsightProperty) {
                InsightProperty property = (InsightProperty)insightObject;
                if (property.getOEPEELType() != null) {
                    type = property.getOEPEELType();
                }
            } else {
                InsightMethod method = (InsightMethod)insightObject;
                String string = type = method.getReturnType() != null ? method.getReturnType() : "void";
            }
            if (type == null) continue;
            if (firstInsightObject) {
                firstInsightObject = false;
            } else {
                sb.append(nl);
            }
            String elTypeExpression = ELType.getELTypeConstantName(type);
            assert (elTypeExpression != null) : "We hit a type that is not defined in ELType. Now we need to declare a field and a getter for it - " + type;
            JavaMembers javaMembers3 = javaMembersMap.get(insightObject);
            sb.append(nl).append("\t\t\t").append("case ").append(javaMembers3.staticId).append(':');
            sb.append(nl).append("\t\t\t\t").append("return ").append(elTypeExpression).append(';');
        }
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t\t").append("return ").append(DEFAULT_EL_TYPE_EXPRESSION).append(';');
        sb.append(nl).append("\t").append('}');
        Collection<InsightMethod> methods = this.filterMethods(this.insightObjects);
        if (!methods.isEmpty()) {
            sb.append(nl);
            sb.append(nl).append("\t").append("private static int getMethodParameterCount(short staticId) {");
            sb.append(nl).append("\t\t").append("switch(staticId) {");
            firstInsightObject = true;
            for (InsightMethod method : methods) {
                if (method.getParameters().isEmpty()) continue;
                if (firstInsightObject) {
                    firstInsightObject = false;
                } else {
                    sb.append(nl);
                }
                javaMembers = javaMembersMap.get(method);
                sb.append(nl).append("\t\t\t").append("case ").append(javaMembers.staticId).append(':');
                sb.append(nl).append("\t\t\t\t").append("return ").append(method.getParameters().size()).append(';');
            }
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl).append("\t\t").append("throw new IllegalArgumentException(\"No parameters for staticId '\" + staticId + \"'\"); //$NON-NLS-1$ //$NON-NLS-2$");
            sb.append(nl).append("\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t").append("private static IELType getMethodParameterELType(short staticId, int parameterIndex) {");
            sb.append(nl).append("\t\t").append("switch(staticId) {");
            firstInsightObject = true;
            for (InsightMethod method : methods) {
                if (method.getParameters().isEmpty()) continue;
                if (firstInsightObject) {
                    firstInsightObject = false;
                } else {
                    sb.append(nl);
                }
                javaMembers = javaMembersMap.get(method);
                sb.append(nl).append("\t\t\t").append("case ").append(javaMembers.staticId).append(": {");
                sb.append(nl).append("\t\t\t\t").append("switch(parameterIndex) {");
                int i = 0;
                while (i < method.getParameters().size()) {
                    String parameter = method.getParameters().get(i);
                    String elTypeExpression = ELType.getELTypeConstantName(parameter);
                    if (i > 0) {
                        sb.append(nl);
                    }
                    sb.append(nl).append("\t\t\t\t\t").append("case ").append(i).append(':');
                    sb.append(nl).append("\t\t\t\t\t\t").append("return ").append(elTypeExpression).append(';');
                    ++i;
                }
                sb.append(nl).append("\t\t\t\t").append('}');
                sb.append(nl).append("\t\t\t\t").append("throw new IllegalArgumentException(\"Invalid parameterIndex '\" + parameterIndex + \" for staticId '\" + staticId + \"'\");  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$");
                sb.append(nl).append("\t\t\t").append('}');
            }
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl).append("\t\t").append("throw new IllegalArgumentException(\"No parameters for staticId '\" + staticId + \"'\"); //$NON-NLS-1$ //$NON-NLS-2$");
            sb.append(nl).append("\t").append('}');
        }
    }

    private Collection<InsightMethod> filterMethods(Collection<? extends InsightObject> insightObjects) {
        ArrayList<InsightMethod> methods = new ArrayList<InsightMethod>(insightObjects.size() / 3);
        for (InsightObject insightObject : insightObjects) {
            if (!(insightObject instanceof InsightMethod)) continue;
            methods.add((InsightMethod)insightObject);
        }
        return methods;
    }

    private void generatePropertyClasses(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        this.generatePropertyClassBeginning(nl, sb, "private class StaticProperty extends AbstractProperty implements IStaticProperty {", "StaticProperty");
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final IELProperty getProperty(String propertyId) {");
        sb.append(nl).append("\t\t\t").append("return null;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final List<? extends IELProperty> getProperties() {");
        sb.append(nl).append("\t\t\t").append("return Collections.emptyList();");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final int getPropertyCount() {");
        sb.append(nl).append("\t\t\t").append("return 0;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final String[] getPropertyIds() {");
        sb.append(nl).append("\t\t\t").append("return new String[0];");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final AbstractProperty getProperty(int index) {");
        sb.append(nl).append("\t\t\t").append("return ELUtil.EMPTY_ABSTRACT_PROPERTY_ARRAY[0];");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final <T extends IELProperty> List<? extends T> getProperties(final Class<T> type) {");
        sb.append(nl).append("\t\t\t").append("return Collections.emptyList();");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final Class<? extends IELProperty> getType(int index) {");
        sb.append(nl).append("\t\t\t").append("return null;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final int getPropertyCount(Class<? extends IELProperty> type) {");
        sb.append(nl).append("\t\t\t").append("return 0;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final int getIndex(Class<? extends IELProperty> type, int typeIndex) {");
        sb.append(nl).append("\t\t\t").append("return -1;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t").append('}');
        this.generatePropertyClassBeginning(nl, sb, "private class StaticParentProperty extends AbstractParentProperty implements IStaticProperty {", "StaticParentProperty");
        String unknownPropertyException = "throw new IllegalStateException(\"Unknown property (or method): \" + getStaticId()); //$NON-NLS-1$";
        this.generateCommonClassParts(nl, sb, javaMembersMap, true, this.insightObjects, unknownPropertyException);
        sb.append(nl).append("\t").append('}');
    }

    private void generatePropertyClassBeginning(String nl, StringBuilder sb, String classDeclaration, String classSimpleName) {
        sb.append(nl);
        sb.append(nl).append("\t").append(classDeclaration);
        sb.append(nl).append("\t\t").append("private final short staticId;");
        sb.append(nl);
        sb.append(nl).append("\t\t").append("private ").append(classSimpleName).append("(short staticId) {");
        sb.append(nl).append("\t\t\t").append("this.staticId = staticId;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("public final short getStaticId() {");
        sb.append(nl).append("\t\t\t").append("return staticId;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final IELType getELType() {");
        sb.append(nl).append("\t\t\t").append("return getPropertyELType(getStaticId());");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final String getId() {");
        sb.append(nl).append("\t\t\t").append("return getPropertyId(getStaticId());");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("protected final String getToolTipTextDescription() {");
        sb.append(nl).append("\t\t\t").append("return getPropertyToolTipText(getStaticId());");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final String getDescription() {");
        sb.append(nl).append("\t\t\t").append("return getPropertyDescription(getStaticId());");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final IImageData getImageData() {");
        sb.append(nl).append("\t\t\t").append("return getPropertyImageData(getStaticId());");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@SuppressWarnings(\"nls\")");
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public final String toString() {");
        sb.append(nl).append("\t\t\t").append("String id;");
        sb.append(nl).append("\t\t\t").append("try {");
        sb.append(nl).append("\t\t\t\t").append("id = getId();");
        sb.append(nl).append("\t\t\t").append("} catch (Exception e) {");
        sb.append(nl).append("\t\t\t\t").append("id = \"<unknown static property>\";");
        sb.append(nl).append("\t\t\t").append("}");
        sb.append(nl).append("\t\t\t").append("StringBuilder builder = new StringBuilder(getClass().getSimpleName());");
        sb.append(nl).append("\t\t\t").append("builder.append(\" [staticId=\").append(getStaticId()).append(\", id=\").append(id).append(\"]\");");
        sb.append(nl).append("\t\t\t").append("return builder.toString();");
        sb.append(nl).append("\t\t").append('}');
    }

    private void generateFieldClasses(String nl, StringBuilder sb) {
        sb.append(nl);
        sb.append(nl).append("\t").append("private class StaticField extends StaticProperty implements IELField {");
        sb.append(nl).append("\t\t").append("private StaticField(short staticId) {");
        sb.append(nl).append("\t\t\t").append("super(staticId);");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t").append("private class StaticParentField extends StaticParentProperty implements IELField {");
        sb.append(nl).append("\t\t").append("private StaticParentField(short staticId) {");
        sb.append(nl).append("\t\t\t").append("super(staticId);");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl).append("\t").append('}');
    }

    private void generateMethodClasses(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap) {
        Collection<InsightMethod> methods = this.filterMethods(this.insightObjects);
        if (!methods.isEmpty()) {
            this.generateMethodClassBeginning(nl, sb, javaMembersMap, "private class StaticMethod extends StaticProperty implements IELMethod {", "StaticMethod", methods);
            sb.append(nl).append("\t").append('}');
            boolean generateStaticParentMethodClass = false;
            for (InsightMethod method : methods) {
                if (!this.childrenMap.containsKey(method)) continue;
                generateStaticParentMethodClass = true;
                break;
            }
            if (generateStaticParentMethodClass) {
                this.generateMethodClassBeginning(nl, sb, javaMembersMap, "private class StaticParentMethod extends StaticParentProperty implements IELMethod {", "StaticParentMethod", methods);
                sb.append(nl).append("\t").append('}');
            }
        }
    }

    private void generateMethodClassBeginning(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap, String classDeclaration, String classSimpleName, Collection<InsightMethod> methods) {
        JavaMembers javaMembers;
        sb.append(nl);
        sb.append(nl).append("\t").append(classDeclaration);
        sb.append(nl).append("\t\t").append("private List<IELType> parameterELTypes;");
        sb.append(nl);
        sb.append(nl).append("\t\t").append("private ").append(classSimpleName).append("(short staticId) {");
        sb.append(nl).append("\t\t\t").append("super(staticId);");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public List<? extends IELType> getParameterELTypes() {");
        sb.append(nl).append("\t\t\t").append("if (parameterELTypes == null) {");
        sb.append(nl).append("\t\t\t\t").append("switch (getStaticId()) {");
        ArrayList<InsightMethod> methodsWithoutParameters = new ArrayList<InsightMethod>(methods.size() / 2 + 1);
        for (InsightMethod method : methods) {
            if (method.getParameters().isEmpty()) {
                methodsWithoutParameters.add(method);
                continue;
            }
            javaMembers = javaMembersMap.get(method);
            sb.append(nl).append("\t\t\t\t\t").append("case ").append(javaMembers.staticId).append(':');
        }
        if (methods.size() != methodsWithoutParameters.size()) {
            sb.append(nl).append("\t\t\t\t\t\t").append("parameterELTypes = new AbstractList<IELType>() {");
            sb.append(nl).append("\t\t\t\t\t\t\t").append("@Override");
            sb.append(nl).append("\t\t\t\t\t\t\t").append("public int size() {");
            sb.append(nl).append("\t\t\t\t\t\t\t\t").append("return getMethodParameterCount(getStaticId());");
            sb.append(nl).append("\t\t\t\t\t\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t\t\t\t\t\t").append("@Override");
            sb.append(nl).append("\t\t\t\t\t\t\t").append("public IELType get(int index) {");
            sb.append(nl).append("\t\t\t\t\t\t\t\t").append("return getMethodParameterELType(getStaticId(), index);");
            sb.append(nl).append("\t\t\t\t\t\t\t").append('}');
            sb.append(nl).append("\t\t\t\t\t\t").append("};");
            sb.append(nl).append("\t\t\t\t\t\t").append("break;");
        }
        if (!methodsWithoutParameters.isEmpty()) {
            sb.append(nl);
            for (InsightMethod method : methodsWithoutParameters) {
                javaMembers = javaMembersMap.get(method);
                sb.append(nl).append("\t\t\t\t\t").append("case ").append(javaMembers.staticId).append(':');
            }
            sb.append(nl).append("\t\t\t\t\t\t").append("parameterELTypes = Collections.emptyList();");
            sb.append(nl).append("\t\t\t\t\t\t").append("break;");
        }
        sb.append(nl).append("\t\t\t\t").append('}');
        sb.append(nl).append("\t\t\t").append('}');
        sb.append(nl).append("\t\t\t").append("return parameterELTypes;");
        sb.append(nl).append("\t\t").append('}');
    }

    private void generateCommonClassParts(String nl, StringBuilder sb, Map<INamedObject, JavaMembers> javaMembersMap, boolean parentInsightObject, Collection<? extends INamedObject> namedObjects, String unknownNamedObjectException) {
        ArrayList<InsightObject> sortedChildren;
        JavaMembers javaMembers;
        Set<InsightObject> children;
        boolean firstNamedObject;
        if (namedObjects.iterator().next() instanceof InsightProperty || !parentInsightObject) {
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final int getPropertyCount() {");
            sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
            firstNamedObject = true;
            for (INamedObject iNamedObject : namedObjects) {
                children = this.childrenMap.get(iNamedObject);
                if (children == null) continue;
                assert (!children.isEmpty()) : iNamedObject;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                javaMembers = javaMembersMap.get(iNamedObject);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(':');
                sb.append(nl).append("\t\t\t\t\t").append("return ").append(children.size()).append(';');
            }
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return 0;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final int getPropertyCount(Class<? extends IELProperty> type) {");
            sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
            firstNamedObject = true;
            for (INamedObject iNamedObject : namedObjects) {
                children = this.childrenMap.get(iNamedObject);
                if (children == null) continue;
                assert (!children.isEmpty()) : iNamedObject;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                Collection<InsightMethod> methods = this.filterMethods(children);
                JavaMembers javaMembers2 = javaMembersMap.get(iNamedObject);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers2.staticId).append(':');
                sb.append(nl).append("\t\t\t\t\t").append("return ");
                int fieldCounter = children.size() - methods.size();
                if (fieldCounter > 0) {
                    sb.append(nl).append("\t\t\t\t\t\t").append("type == IELField.class ? ").append(children.size() - methods.size()).append(':');
                }
                if (!methods.isEmpty()) {
                    sb.append(nl).append("\t\t\t\t\t\t").append("type == IELMethod.class ? ").append(methods.size()).append(':');
                }
                sb.append(nl).append("\t\t\t\t\t\t").append("0;");
            }
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return 0;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final String[] getPropertyIds() {");
            sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
            firstNamedObject = true;
            for (INamedObject iNamedObject : namedObjects) {
                children = this.childrenMap.get(iNamedObject);
                if (children == null) continue;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                javaMembers = javaMembersMap.get(iNamedObject);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(':');
                sb.append(nl).append("\t\t\t\t\t").append("return new String[] {");
                sortedChildren = new ArrayList<InsightObject>(children);
                Collections.sort(sortedChildren);
                int childrenCounter = 0;
                for (InsightObject child : sortedChildren) {
                    sb.append(nl).append("\t\t\t\t\t\t").append('\"').append(child.getName()).append('\"');
                    if (++childrenCounter != children.size()) {
                        sb.append(',');
                    }
                    sb.append(" //$NON-NLS-1$");
                }
                sb.append(nl).append("\t\t\t\t\t").append("};");
            }
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl).append("\t\t\t").append("return new String[0];");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final Class<? extends IELProperty> getType(int index) {");
            sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
            firstNamedObject = true;
            for (INamedObject iNamedObject : namedObjects) {
                children = this.childrenMap.get(iNamedObject);
                if (children == null) continue;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                javaMembers = javaMembersMap.get(iNamedObject);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(": {");
                sb.append(nl).append("\t\t\t\t\t").append("switch(index) {");
                sortedChildren = new ArrayList<InsightObject>(children);
                Collections.sort(sortedChildren);
                String lastType = null;
                int i = 0;
                int max = sortedChildren.size() - 1;
                while (i <= max) {
                    String type;
                    InsightObject child = (InsightObject)sortedChildren.get(i);
                    String string = type = child instanceof InsightMethod ? "IELMethod.class" : "IELField.class";
                    if (lastType == null) {
                        lastType = type;
                    }
                    sb.append(nl).append("\t\t\t\t\t\t").append("case ").append(i).append(':');
                    if (lastType != type || i == max) {
                        sb.append(nl).append("\t\t\t\t\t\t\t").append("return ").append(lastType).append(';');
                        lastType = type;
                        if (i < max) {
                            sb.append(nl);
                        }
                    }
                    ++i;
                }
                sb.append(nl).append("\t\t\t\t\t").append('}');
                sb.append(nl).append("\t\t\t\t").append('}');
                sb.append(nl).append("\t\t\t\t").append("break;");
            }
            if (!firstNamedObject) {
                sb.append(nl);
            }
            sb.append(nl).append("\t\t\t\t").append("default:");
            sb.append(nl).append("\t\t\t\t\t").append(unknownNamedObjectException);
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t\t").append("return ELUtil.EMPTY_ABSTRACT_PROPERTY_ARRAY[0] == null ? null : null;");
            sb.append(nl).append("\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t").append("@Override");
            sb.append(nl).append("\t\t").append("public final int getIndex(Class<? extends IELProperty> type, int typeIndex) {");
            sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
            firstNamedObject = true;
            for (INamedObject iNamedObject : namedObjects) {
                children = this.childrenMap.get(iNamedObject);
                if (children == null) continue;
                if (firstNamedObject) {
                    firstNamedObject = false;
                } else {
                    sb.append(nl);
                }
                javaMembers = javaMembersMap.get(iNamedObject);
                sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(": {");
                Collection<InsightMethod> methods = this.filterMethods(children);
                ArrayList<InsightObject> sortedChildren2 = new ArrayList<InsightObject>(children);
                Collections.sort(sortedChildren2);
                if (methods.isEmpty()) {
                    sb.append(nl).append("\t\t\t\t\t").append("if (type == IELField.class) {");
                    sb.append(nl).append("\t\t\t\t\t\t").append("return typeIndex;");
                    sb.append(nl).append("\t\t\t\t\t").append('}');
                } else if (methods.size() == children.size()) {
                    sb.append(nl).append("\t\t\t\t\t").append("if (type == IELMethod.class) {");
                    sb.append(nl).append("\t\t\t\t\t\t").append("return typeIndex;");
                    sb.append(nl).append("\t\t\t\t\t").append('}');
                } else {
                    sb.append(nl).append("\t\t\t\t\t").append("if (type == IELField.class) {");
                    sb.append(nl).append("\t\t\t\t\t\t").append("switch(typeIndex) {");
                    int fieldCounter = 0;
                    int i = 0;
                    int max = sortedChildren2.size() - 1;
                    while (i <= max) {
                        InsightObject child = (InsightObject)sortedChildren2.get(i);
                        if (!methods.contains(child)) {
                            sb.append(nl).append("\t\t\t\t\t\t\t").append("case ").append(fieldCounter++).append(':');
                            sb.append(nl).append("\t\t\t\t\t\t\t\t").append("return ").append(i).append(';');
                        }
                        ++i;
                    }
                    sb.append(nl).append("\t\t\t\t\t\t").append('}');
                    sb.append(nl).append("\t\t\t\t\t").append("} else if (type == IELMethod.class) {");
                    sb.append(nl).append("\t\t\t\t\t\t").append("switch(typeIndex) {");
                    int methodCounter = 0;
                    int i2 = 0;
                    int max2 = sortedChildren2.size() - 1;
                    while (i2 <= max2) {
                        InsightObject child = (InsightObject)sortedChildren2.get(i2);
                        if (methods.contains(child)) {
                            sb.append(nl).append("\t\t\t\t\t\t\t").append("case ").append(methodCounter++).append(':');
                            sb.append(nl).append("\t\t\t\t\t\t\t\t").append("return ").append(i2).append(';');
                        }
                        ++i2;
                    }
                    sb.append(nl).append("\t\t\t\t\t\t").append('}');
                    sb.append(nl).append("\t\t\t\t\t").append('}');
                }
                sb.append(nl).append("\t\t\t\t").append('}');
                sb.append(nl).append("\t\t\t\t").append("break;");
            }
            if (!firstNamedObject) {
                sb.append(nl);
            }
            sb.append(nl).append("\t\t\t\t").append("default:");
            sb.append(nl).append("\t\t\t\t\t").append(unknownNamedObjectException);
            sb.append(nl).append("\t\t\t").append('}');
            sb.append(nl);
            sb.append(nl).append("\t\t\t").append("return -1;");
            sb.append(nl).append("\t\t").append('}');
        }
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public IELProperty getProperty(String propertyId) {");
        sb.append(nl).append("\t\t\t").append("if (propertyId != null) {");
        sb.append(nl).append("\t\t\t\t").append("switch(getStaticId()) {");
        firstNamedObject = true;
        for (INamedObject iNamedObject : namedObjects) {
            children = this.childrenMap.get(iNamedObject);
            if (children == null) continue;
            if (firstNamedObject) {
                firstNamedObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers = javaMembersMap.get(iNamedObject);
            sb.append(nl).append("\t\t\t\t\t").append("case ").append(javaMembers.staticId).append(':');
            if (children.size() > 5) {
                sb.append(nl).append("\t\t\t\t\t\t").append("propertyId = propertyId.intern();");
            }
            sb.append(nl).append("\t\t\t\t\t\t").append("return ");
            for (InsightObject child : children) {
                sb.append(nl).append("\t\t\t\t\t\t\t").append("propertyId");
                if (children.size() > 5) {
                    sb.append(" == \"").append(child.getName()).append('\"');
                } else {
                    sb.append(".equals(\"").append(child.getName()).append("\")");
                }
                JavaMembers childJavaMembers = javaMembersMap.get(child);
                sb.append(" ? ").append(parentInsightObject && childJavaMembers.parentInsightObjectField != null ? childJavaMembers.parentInsightObjectGetter : childJavaMembers.getter).append("() :");
                sb.append(" //$NON-NLS-1$");
            }
            sb.append(nl).append("\t\t\t\t\t\t\t").append("null;");
        }
        sb.append(nl).append("\t\t\t\t").append('}');
        sb.append(nl).append("\t\t\t").append('}');
        sb.append(nl).append("\t\t\t").append("return null;");
        sb.append(nl).append("\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t").append("@Override");
        sb.append(nl).append("\t\t").append("public AbstractProperty getProperty(int index) {");
        sb.append(nl).append("\t\t\t").append("switch(getStaticId()) {");
        firstNamedObject = true;
        for (INamedObject iNamedObject : namedObjects) {
            children = this.childrenMap.get(iNamedObject);
            if (children == null) continue;
            if (firstNamedObject) {
                firstNamedObject = false;
            } else {
                sb.append(nl);
            }
            javaMembers = javaMembersMap.get(iNamedObject);
            sb.append(nl).append("\t\t\t\t").append("case ").append(javaMembers.staticId).append(": {");
            sb.append(nl).append("\t\t\t\t\t").append("switch(index) {");
            sortedChildren = new ArrayList<InsightObject>(children);
            Collections.sort(sortedChildren);
            int i = 0;
            while (i < sortedChildren.size()) {
                InsightObject child;
                if (i > 0) {
                    sb.append(nl);
                }
                child = (InsightObject)sortedChildren.get(i);
                JavaMembers childJavaMembers = javaMembersMap.get(child);
                sb.append(nl).append("\t\t\t\t\t\t").append("case ").append(i).append(':');
                sb.append(nl).append("\t\t\t\t\t\t\t").append("return ").append(parentInsightObject && childJavaMembers.parentInsightObjectField != null ? childJavaMembers.parentInsightObjectGetter : childJavaMembers.getter).append("();");
                ++i;
            }
            sb.append(nl).append("\t\t\t\t\t").append('}');
            sb.append(nl).append("\t\t\t\t").append('}');
            sb.append(nl).append("\t\t\t\t").append("break;");
        }
        if (!firstNamedObject) {
            sb.append(nl);
        }
        sb.append(nl).append("\t\t\t\t").append("default:");
        sb.append(nl).append("\t\t\t\t\t").append(unknownNamedObjectException);
        sb.append(nl).append("\t\t\t").append('}');
        sb.append(nl);
        sb.append(nl).append("\t\t\t").append("return ELUtil.EMPTY_ABSTRACT_PROPERTY_ARRAY[0];");
        sb.append(nl).append("\t\t").append('}');
    }

    private static interface INamedObject {
        public String getName();
    }

    private static final class InsightMethod
    extends InsightObject {
        private final List<String> parameters;
        private final String returnType;

        public InsightMethod(Element methodElement) {
            super(methodElement);
            if (!"insightMethod".equals(methodElement.getNodeName())) {
                throw new IllegalArgumentException(methodElement.getNodeName());
            }
            this.parameters = this.loadParameters(methodElement);
            this.returnType = this.getReturnType(methodElement);
        }

        private String getReturnType(Element methodElement) {
            Element return_type = ELMetadataPackageGenerator.findFirstChildElement(methodElement, "RETURN_TYPE");
            return return_type != null ? return_type.getAttribute("type") : null;
        }

        private List<String> loadParameters(Element methodElement) {
            Element parameters = ELMetadataPackageGenerator.findFirstChildElement(methodElement, "PARAMETERS");
            if (parameters != null) {
                ArrayList<String> params = new ArrayList<String>();
                NodeList nodes = parameters.getElementsByTagName("PARAMETER_TYPE");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element param_type = (Element)nodes.item(i);
                    String type = param_type.getAttribute("type");
                    if (!type.equals("void")) {
                        params.add(type);
                    }
                    ++i;
                }
                return params;
            }
            return Collections.emptyList();
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public String getReturnType() {
            return this.returnType;
        }

        @Override
        public final int hashCode() {
            int result = 1;
            result = 23 * result + super.hashCode();
            result = 23 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            return result;
        }

        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            InsightMethod other = (InsightMethod)obj;
            return DTRTUtil.equals(this.parameters, other.parameters);
        }
    }

    private static abstract class InsightObject
    implements INamedObject,
    Comparable<InsightObject> {
        private final String name;
        private final String tooltipResId;
        private final String longLabelResId;

        public InsightObject(Element methodElement) {
            this.name = ELMetadataPackageGenerator.getValue(methodElement, "name");
            if (this.name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            this.tooltipResId = ELMetadataPackageGenerator.getResId(methodElement, "TOOLTIP");
            if (this.tooltipResId == null) {
                throw new IllegalArgumentException("tooltip cannot be null - " + this.name);
            }
            this.longLabelResId = ELMetadataPackageGenerator.getResId(methodElement, "LONG_LABEL");
            if (this.longLabelResId == null) {
                throw new IllegalArgumentException("longLabel cannot be null - " + this.name);
            }
        }

        @Override
        public final String getName() {
            return this.name;
        }

        public final String getTooltipResId() {
            return this.tooltipResId;
        }

        public final String getLongLabelResId() {
            return this.longLabelResId;
        }

        @Override
        public final int compareTo(InsightObject o) {
            return PROPERTIES_COMPARATOR.compare(this.name, o.name);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.tooltipResId == null ? 0 : this.tooltipResId.hashCode());
            result = 31 * result + (this.longLabelResId == null ? 0 : this.longLabelResId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InsightObject other = (InsightObject)obj;
            return DTRTUtil.equals((Object)this.name, (Object)other.name) && DTRTUtil.equals((Object)this.tooltipResId, (Object)other.tooltipResId) && DTRTUtil.equals((Object)this.longLabelResId, (Object)other.longLabelResId);
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [name=").append(this.name).append(", tooltipResId=").append(this.tooltipResId).append(", longLabelResId=").append(this.longLabelResId).append("]");
            return builder.toString();
        }
    }

    private static final class InsightProperty
    extends InsightObject {
        private final Element childrenPropertiesElement;
        private final String extend;
        private final String oepeELType;

        public InsightProperty(Element propertyElement) {
            super(propertyElement);
            if (!"insightProperty".equals(propertyElement.getNodeName())) {
                throw new IllegalArgumentException(propertyElement.getNodeName());
            }
            this.childrenPropertiesElement = ELMetadataPackageGenerator.findFirstChildElement(propertyElement, "childrenProperties");
            this.extend = this.childrenPropertiesElement != null ? ELMetadataPackageGenerator.getValue(this.childrenPropertiesElement, "extends") : null;
            this.oepeELType = ELMetadataPackageGenerator.getValue(propertyElement, "oepeELType");
        }

        public Element getChildrenPropertiesElement() {
            return this.childrenPropertiesElement;
        }

        public String getExtend() {
            return this.extend;
        }

        public String getOEPEELType() {
            return this.oepeELType;
        }
    }

    private static class JavaMembers {
        private String staticId;
        private String parentInsightObjectField;
        private String parentInsightObjectGetter;
        private String field;
        private String getter;

        private JavaMembers() {
        }
    }

    private static final class MetaData
    implements INamedObject {
        private final String name;
        private final String extend;
        private final Set<String> hidden;
        private final String oepeELType;

        public MetaData(Element metaDataElement) {
            this.name = metaDataElement.getNodeName();
            this.extend = ELMetadataPackageGenerator.getValue(metaDataElement, "extends");
            String value = ELMetadataPackageGenerator.getValue(metaDataElement, "hidden");
            this.hidden = value == null ? Collections.emptySet() : (value.indexOf(44) < 0 ? Collections.singletonMap(value, null).keySet() : new HashSet<String>(Arrays.asList(value.split(","))));
            this.oepeELType = ELMetadataPackageGenerator.getValue(metaDataElement, "oepeELType");
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getExtend() {
            return this.extend;
        }

        public Set<String> getHidden() {
            return this.hidden;
        }

        public String getOEPEELType() {
            return this.oepeELType;
        }

        public final int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.extend == null ? 0 : this.extend.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MetaData other = (MetaData)obj;
            return DTRTUtil.equals((Object)this.name, (Object)other.name) && DTRTUtil.equals((Object)this.extend, (Object)other.extend);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MetaData [name=").append(this.name).append(", extend=").append(this.extend).append("]");
            return builder.toString();
        }
    }
}

