/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import oracle.eclipse.tools.adf.dtrt.object.IELField;
import oracle.eclipse.tools.adf.dtrt.object.IELMethod;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.BasicProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELMetadataPackageGenerator;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IPropertyProvider;

public final class ArrayPropertyProvider
implements IPropertyProvider {
    private String[] propertyIds;
    private AbstractProperty[] properties;

    public ArrayPropertyProvider(Object[] array) {
        AbstractProperty property;
        assert (array != null);
        assert (array.length > 0);
        ArrayList<String> ids = new ArrayList<String>(array.length);
        HashMap<String, AbstractProperty> propertiesMap = new HashMap<String, AbstractProperty>(array.length);
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof String) {
                String id = (String)array[i];
                if (!ids.contains(id)) {
                    ids.add(id);
                }
            } else {
                property = (AbstractProperty)((Object)array[i]);
                String id = property.getId();
                if (!ids.contains(id)) {
                    ids.add(id);
                    propertiesMap.put(id, property);
                }
            }
            ++i;
        }
        Collections.sort(ids, ELMetadataPackageGenerator.PROPERTIES_COMPARATOR);
        this.propertyIds = ids.toArray(new String[ids.size()]);
        if (!propertiesMap.isEmpty()) {
            this.properties = new AbstractProperty[this.propertyIds.length];
            i = 0;
            while (i < this.propertyIds.length) {
                property = (AbstractProperty)((Object)propertiesMap.get(this.propertyIds[i]));
                if (property != null) {
                    this.properties[i] = property;
                }
                ++i;
            }
        }
    }

    @Override
    public int getPropertyCount() {
        return this.propertyIds.length;
    }

    @Override
    public IELProperty getProperty(String propertyId) {
        int index;
        if (propertyId != null && (index = DTRTUtil.indexOf((Object[])this.propertyIds, (Object)propertyId)) >= 0) {
            return this.getProperty(index);
        }
        return null;
    }

    @Override
    public String[] getPropertyIds() {
        return this.propertyIds;
    }

    @Override
    public AbstractProperty getProperty(int index) {
        AbstractProperty property;
        if (this.properties == null) {
            this.properties = new AbstractProperty[this.propertyIds.length];
        }
        if ((property = this.properties[index]) == null) {
            this.properties[index] = property = new BasicProperty.BasicField(this.propertyIds[index]);
        }
        return property;
    }

    @Override
    public int getIndex(Class<? extends IELProperty> type, int typeIndex) {
        if (this.properties == null) {
            return type == IELField.class ? typeIndex : -1;
        }
        int i = 0;
        while (i < this.properties.length) {
            if (this.getType(this.properties[i]) == type) {
                if (typeIndex == 0) {
                    return i;
                }
                --typeIndex;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getPropertyCount(Class<? extends IELProperty> type) {
        if (this.properties == null) {
            return type == IELField.class ? this.getPropertyCount() : 0;
        }
        int counter = 0;
        int i = 0;
        while (i < this.properties.length) {
            if (this.getType(this.properties[i]) == type) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    @Override
    public Class<? extends IELProperty> getType(int index) {
        return this.properties != null ? this.getType(this.properties[index]) : (this.propertyIds[index] != null ? IELField.class : null);
    }

    private Class<? extends IELProperty> getType(AbstractProperty property) {
        return property == null || property instanceof IELField ? IELField.class : (property instanceof IELMethod ? IELMethod.class : null);
    }
}

