/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import oracle.eclipse.tools.adf.dtrt.object.IELMethod;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.object.IELType;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ExtensibleProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IPropertyProvider;

public class AddChildrenPropertyProvider
implements IPropertyProvider {
    private final IPropertyProvider propertyProvider;
    private final IPropertyProvider[] childPropertyProviders;
    private AbstractProperty[] properties;
    private IELType elType;

    public AddChildrenPropertyProvider(IPropertyProvider propertyProvider, IPropertyProvider[] childPropertyProviders) {
        this(propertyProvider, null, childPropertyProviders);
    }

    public AddChildrenPropertyProvider(IPropertyProvider propertyProvider, IELType elType, IPropertyProvider[] childPropertyProviders) {
        this.propertyProvider = propertyProvider;
        this.elType = elType;
        this.childPropertyProviders = childPropertyProviders;
    }

    @Override
    public int getPropertyCount() {
        return this.propertyProvider.getPropertyCount();
    }

    @Override
    public IELProperty getProperty(String propertyId) {
        int index;
        if (propertyId != null && (index = DTRTUtil.indexOf((Object[])this.getPropertyIds(), (Object)propertyId)) >= 0) {
            return this.getProperty(index);
        }
        return null;
    }

    @Override
    public String[] getPropertyIds() {
        return this.propertyProvider.getPropertyIds();
    }

    @Override
    public int getPropertyCount(Class<? extends IELProperty> type) {
        return this.propertyProvider.getPropertyCount(type);
    }

    @Override
    public Class<? extends IELProperty> getType(int index) {
        return this.propertyProvider.getType(index);
    }

    @Override
    public int getIndex(Class<? extends IELProperty> type, int typeIndex) {
        return this.propertyProvider.getIndex(type, typeIndex);
    }

    @Override
    public AbstractProperty getProperty(int index) {
        AbstractProperty property;
        if (this.properties == null) {
            this.properties = new AbstractProperty[this.propertyProvider.getPropertyCount()];
        }
        if ((property = this.properties[index]) == null) {
            property = this.propertyProvider.getProperty(index);
            if (property.getProperties().isEmpty()) {
                assert (!(property instanceof IELMethod)) : property;
                property = new ExtensibleProperty.FieldDecorator(property, this.elType, this.childPropertyProviders);
            }
            this.properties[index] = property;
        }
        return property;
    }
}

