/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.java.jdt.JdtJavaType;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class JdtJavaTypeReferenceService
extends JavaTypeReferenceService {
    private IJavaProject project;
    private IElementChangedListener listener;

    public JdtJavaTypeReferenceService() {
    }

    public JdtJavaTypeReferenceService(IJavaProject project) {
        this.project = project;
    }

    protected void init() {
        super.init();
        this.project = JavaCore.create((IProject)((IProject)((Element)this.context(Element.class)).adapt(IProject.class)));
        final Value value = (Value)this.context(Value.class);
        this.listener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                IProject project = JdtJavaTypeReferenceService.this.project.getProject();
                if (!project.exists()) {
                    JavaCore.removeElementChangedListener((IElementChangedListener)this);
                } else if (project.isAccessible()) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            if (!value.disposed() && !value.root().disposed()) {
                                JdtJavaTypeReferenceService.this.broadcast();
                            }
                        }
                    };
                    thread.start();
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener, (int)1);
    }

    public JavaType resolve(String name) {
        if (name != null && name.trim().length() > 0 && !name.startsWith(".") && !name.endsWith(".")) {
            try {
                String n = name.replace('$', '.');
                IType type = this.project.findType(n);
                if (type != null && type.exists() && !type.isAnonymous()) {
                    return new JdtJavaType(type);
                }
            }
            catch (JavaModelException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.listener);
    }

    public static final class Condition
    extends ServiceCondition {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean applicable(ServiceContext context) {
            Property property = (Property)context.find(Property.class);
            if (!(property.definition() instanceof ValueProperty)) return false;
            Reference referenceAnnotation = (Reference)property.definition().getAnnotation(Reference.class);
            if (referenceAnnotation == null) return false;
            if (referenceAnnotation.target() != JavaType.class) return false;
            IProject project = (IProject)property.element().adapt(IProject.class);
            if (project == null) return false;
            try {
                String[] stringArray = project.getDescription().getNatureIds();
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String nature = stringArray[n2];
                    if (nature.equals("org.eclipse.jdt.core.javanature")) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            return false;
        }
    }
}

