/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUIUtil {
    private GeneratorUIUtil() {
    }

    public static List<GenModel> loadGenModels(IProgressMonitor progressMonitor, List<URI> uris, Shell shell) {
        if (!uris.isEmpty()) {
            progressMonitor.beginTask(GenModelEditPlugin.INSTANCE.getString("_UI_LoadingGenModel_message"), uris.size());
            ArrayList<GenModel> genModels = new ArrayList<GenModel>(uris.size());
            LinkedHashMap<String, Diagnostic> fileNameToErrorDiagnosticMap = new LinkedHashMap<String, Diagnostic>();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            for (URI uri : uris) {
                EObject eObject;
                progressMonitor.subTask(uri.toPlatformString(true));
                Resource resource = resourceSet.getResource(uri, true);
                if (resource != null && resource.getContents().size() == 1 && (eObject = (EObject)resource.getContents().get(0)) instanceof GenModel) {
                    GenModel genModel = (GenModel)eObject;
                    genModel.reconcile();
                    genModel.setCanGenerate(true);
                    genModel.setValidateModel(true);
                    Diagnostic diagnostic = genModel.diagnose();
                    if (diagnostic.getSeverity() != 4) {
                        genModels.add((GenModel)eObject);
                    } else {
                        fileNameToErrorDiagnosticMap.put(uri.lastSegment(), diagnostic);
                    }
                }
                progressMonitor.worked(1);
            }
            if (shell != null && !fileNameToErrorDiagnosticMap.isEmpty()) {
                String message;
                String reason = GenModelEditPlugin.INSTANCE.getString("_UI_InvalidGenModel_message");
                StringBuilder sb = new StringBuilder();
                BasicDiagnostic diagnosticChain = new BasicDiagnostic("", 4, reason, null);
                for (Map.Entry entry : fileNameToErrorDiagnosticMap.entrySet()) {
                    sb.append(", '").append((String)entry.getKey()).append("'");
                    diagnosticChain.add((Diagnostic)entry.getValue());
                }
                String title = GenModelEditPlugin.INSTANCE.getString("_UI_Error_title");
                String string = message = genModels.isEmpty() ? GenModelEditPlugin.INSTANCE.getString("_UI_SelectGenModelInvalid_message") : GenModelEditPlugin.INSTANCE.getString("_UI_SomeSelectGenModelInvalid_message", new Object[]{sb.delete(0, ", ".length()).toString()});
                if (DiagnosticDialog.open((Shell)shell, (String)title, (String)message, (Diagnostic)diagnosticChain) != 0) {
                    genModels.clear();
                }
            }
            return genModels;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeneratorOperation
    extends WorkspaceModifyOperation {
        protected Shell shell;
        protected List<Object[]> generatorAndArgumentsList;
        protected String rootDiagnosticMessage = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorOperationDiagnostic_message");

        public GeneratorOperation(Shell shell) {
            this.shell = shell;
        }

        public GeneratorOperation(Shell shell, List<Object[]> generatorAndArgumentsList) {
            this(shell);
            this.generatorAndArgumentsList = generatorAndArgumentsList;
        }

        public void setRootDiagnosticMessage(String rootDiagnosticMessage) {
            this.rootDiagnosticMessage = rootDiagnosticMessage;
        }

        public String getRootDiagnosticMessage() {
            return this.rootDiagnosticMessage;
        }

        public void addGeneratorAndArguments(Generator generator, Object object, Object projectType, String projectTypeName) {
            if (this.generatorAndArgumentsList == null) {
                this.generatorAndArgumentsList = new ArrayList<Object[]>();
            }
            this.generatorAndArgumentsList.add(new Object[]{generator, object, projectType, projectTypeName});
        }

        protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
            BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.codegen.ecore.ui", 0, this.getRootDiagnosticMessage(), null);
            progressMonitor.beginTask("", this.generatorAndArgumentsList.size());
            try {
                for (Object[] generatorAndArguments : this.generatorAndArgumentsList) {
                    Generator generator = (Generator)generatorAndArguments[0];
                    diagnostic.add(generator.generate(generatorAndArguments[1], generatorAndArguments[2], (String)generatorAndArguments[3], BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(progressMonitor, 1))));
                    if (!this.canContinue((Diagnostic)diagnostic)) break;
                }
                if (this.shell != null && diagnostic.getSeverity() != 0) {
                    BasicDiagnostic finalDiagnostic = diagnostic;
                    this.shell.getDisplay().asyncExec(new Runnable((Diagnostic)finalDiagnostic){
                        private final /* synthetic */ Diagnostic val$finalDiagnostic;
                        {
                            this.val$finalDiagnostic = diagnostic;
                        }

                        public void run() {
                            DiagnosticDialog.openProblem((Shell)GeneratorOperation.this.shell, (String)GenModelEditPlugin.INSTANCE.getString("_UI_GenerationProblems_title"), (String)GenModelEditPlugin.INSTANCE.getString("_UI_GenerationProblems_message"), (Diagnostic)this.val$finalDiagnostic);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                GenModelEditPlugin.INSTANCE.log(throwable);
            }
            progressMonitor.done();
        }

        protected boolean canContinue(Diagnostic diagnostic) {
            return diagnostic.getSeverity() != 8;
        }
    }
}

