/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.variables.AdfControllerExternalVariable;
import oracle.eclipse.tools.adf.view.variables.AdfControllerVariablesDiscoveryParticipant;
import oracle.eclipse.tools.adf.view.variables.BindingsVariableCache;
import oracle.eclipse.tools.application.common.services.variables.IProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.webtier.jsf.variable.FacesBundleExternalVariable;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProjectAndBindingVariablesCacheCleanupListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            switch (event.getType()) {
                case 4: {
                    final IProject project = (IProject)event.getResource();
                    Job projSchedulerJob = new Job("Project Variable Cache cleanup.."){

                        protected IStatus run(IProgressMonitor monitor) {
                            ProjectAndBindingVariablesCacheCleanupListener.cleanupProjectVariableCache(project);
                            BindingsVariableCache.getInstance().removeAllBindingEntriesForProject(project);
                            return Status.OK_STATUS;
                        }
                    };
                    projSchedulerJob.schedule();
                    break;
                }
                case 1: {
                    final HashSet<IFile> deletedFiles = new HashSet<IFile>();
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaVisitor(deletedFiles));
                    if (deletedFiles.size() <= 0) break;
                    Job schedulerJob = new Job("Project Variable Cache cleanup.."){

                        protected IStatus run(IProgressMonitor monitor) {
                            ProjectAndBindingVariablesCacheCleanupListener.cleanupProjectVariableCache(deletedFiles);
                            ProjectAndBindingVariablesCacheCleanupListener.cleanupBindingsVariableCache(deletedFiles);
                            return Status.OK_STATUS;
                        }
                    };
                    schedulerJob.schedule();
                }
                default: {
                    break;
                }
            }
        }
        catch (CoreException ce) {
            ADFPlugin.log(ce);
        }
    }

    private static void cleanupProjectVariableCache(Set<IFile> deletedFiles) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IFile file : deletedFiles) {
            IProject project = file.getProject();
            if (projects.contains(project)) continue;
            projects.add(project);
            ProjectAndBindingVariablesCacheCleanupListener.cleanupProjectVariableCache(project);
        }
    }

    private static void cleanupProjectVariableCache(IProject project) {
        boolean fireChange = false;
        IProjectVariablesCache cache = VariablesController.getInstance().getProjectCache(project);
        for (Variable var : cache.getVariables()) {
            IResource markerRes;
            if (!(var instanceof AdfControllerExternalVariable) && !(var instanceof FacesExternalVariable) && !(var instanceof FacesBundleExternalVariable)) continue;
            ResourceLocation resLoc = var.getDefinitionLocation();
            if (resLoc != null && resLoc.getResource() != null && !resLoc.getResource().exists()) {
                cache.remove(var);
                fireChange = true;
                continue;
            }
            IMarker marker = var.getMarker();
            if (marker == null || (markerRes = marker.getResource()).exists()) continue;
            cache.remove(var);
            fireChange = true;
        }
        if (fireChange) {
            VariablesController.getInstance().updateListeners(project, new IVariablesListener.VariableChangeEvent(AdfControllerVariablesDiscoveryParticipant.class, (IResource)project, IVariablesListener.VariableChangeEvent.AllCaches, IVariablesListener.VariableChangeEvent.AllVariableChange, null));
        }
    }

    private static void cleanupBindingsVariableCache(Set<IFile> deletedFiles) {
        for (IFile file : deletedFiles) {
            BindingsVariableCache.getInstance().removeBindingFileEntry(file);
        }
    }

    private static class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        final Set<IFile> _deletedFiles;

        ResourceDeltaVisitor(Set<IFile> set) {
            this._deletedFiles = set;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    switch (delta.getKind()) {
                        case 2: {
                            this._deletedFiles.add((IFile)resource);
                            return false;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

