/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.util.List;
import oracle.eclipse.tools.adf.view.controller.AdfControllerConfigTypeFilter;
import oracle.eclipse.tools.adf.view.variables.AdfControllerExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.AbstractVariablesDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.variables.ExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class AdfControllerVariablesDiscoveryParticipant
extends AbstractVariablesDiscoveryParticipant {
    public void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
        if (this.isADFControllerFile(context)) {
            IFile file = (IFile)context.getResource();
            IDiscoveryContext projectContext = this.getProjectContext();
            IVariablesCache cache = (IVariablesCache)projectContext.getAdapter(IVariablesCache.class);
            if (cache != null) {
                for (Variable var : cache.getVariables()) {
                    IResource markerRes;
                    IMarker marker;
                    if (!(var instanceof AdfControllerExternalVariable) || (marker = var.getMarker()) == null || !file.equals((Object)(markerRes = marker.getResource()))) continue;
                    cache.remove(var);
                }
                super.discover(context, monitor);
            }
        }
    }

    private boolean isADFControllerFile(IResourceDiscoveryContext context) {
        return context.getResource().getType() == 1 && AdfControllerConfigTypeFilter.getInstance().match((IResourceContext)context);
    }

    protected boolean visit(IDOMElement element, IFile file, List<ExternalVariable> discoveredVars) {
        AdfControllerExternalVariable externalVar;
        Project project = (Project)file.getProject().getAdapter(Project.class);
        String elementName = element.getNodeName();
        if ("managed-bean".equals(elementName) && (externalVar = AdfControllerExternalVariable.fromBeanElement(project, element, file)) != null) {
            discoveredVars.add((ExternalVariable)externalVar);
        }
        return true;
    }
}

