/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.io.Serializable;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ManagedBeanExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdfControllerExternalVariable
extends ManagedBeanExternalVariable
implements Serializable {
    private static final long serialVersionUID = -3046978814140302843L;

    private AdfControllerExternalVariable(String name, DataType type, Variable.SCOPE scope, ResolutionTime resolutionTime, ResourceLocation location) {
        super(name, type, scope, resolutionTime, location);
    }

    public static AdfControllerExternalVariable fromBeanElement(Project project, IDOMElement beanElement, IFile file) {
        if ("managed-bean".equals(beanElement.getNodeName())) {
            StructuredDocumentResourceLocationFactory factory = new StructuredDocumentResourceLocationFactory(file);
            ResourceLocation location = factory.createForEntireElement(beanElement);
            NodeList nameNodes = beanElement.getElementsByTagName("managed-bean-name");
            if (nameNodes.getLength() != 1) {
                return null;
            }
            String name = AdfControllerExternalVariable.getNodeText(nameNodes.item(0));
            NodeList classNodes = beanElement.getElementsByTagName("managed-bean-class");
            if (classNodes.getLength() != 1) {
                return null;
            }
            String className = AdfControllerExternalVariable.getNodeText(classNodes.item(0));
            DataType dt = DataType.getUnspecifiedType();
            IDatatypeProvider dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
            if (dtp != null) {
                dt = dtp.getDataType(className, null);
            }
            Variable.SCOPE scopeValue = Variable.SCOPE.SESSION_SCOPE;
            NodeList scopeNodes = beanElement.getElementsByTagName("managed-bean-scope");
            if (scopeNodes.getLength() != 1) {
                return null;
            }
            String scope = AdfControllerExternalVariable.getNodeText(scopeNodes.item(0));
            if ("request".equals(scope)) {
                scopeValue = Variable.SCOPE.REQUEST_SCOPE;
            } else if ("application".equals(scope)) {
                scopeValue = Variable.SCOPE.APPLICATION_SCOPE;
            } else if ("pageFlow".equals(scope)) {
                scopeValue = Variable.SCOPE.ADF_PAGE_SCOPE;
            } else if ("view".equals(scope)) {
                scopeValue = Variable.SCOPE.ADF_VIEW_SCOPE;
            } else if ("backingBean".equals(scope)) {
                scopeValue = Variable.SCOPE.ADF_BACKING_BEAN_SCOPE;
            } else if ("none".equals(scope)) {
                scopeValue = Variable.SCOPE.NONE_SCOPE;
            }
            return new AdfControllerExternalVariable(name, dt, scopeValue, ResolutionTime.PAGE_RUN_OR_COMPILE, location);
        }
        return null;
    }

    private static String getNodeText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }
}

