/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.view.controller.ADFmPageDefinitionConfigTypeFilter;
import oracle.eclipse.tools.adf.view.internal.TraceOptions;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.adf.view.variables.BindingsVariable;
import oracle.eclipse.tools.adf.view.variables.BindingsVariableCache;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredDocumentDiscoveryContext;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredDocumentResourceDiscoveryContext;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredModelDiscoveryVisitor;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class AdfBindingsPageDefDiscoveryParticipant
implements IStructuredModelDiscoveryVisitor {
    private static final ContentTypeCollectionFilter FILTER;

    static {
        LinkedHashSet<String> types = new LinkedHashSet<String>(2, 1.0f);
        types.add(DTRTContentType.PAGE_DEFINITION.getId());
        FILTER = new ContentTypeCollectionFilter(types);
    }

    public void startDiscovery(IStructuredDocumentDiscoveryContext context, IProgressMonitor monitor) {
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public IStatus stopDiscovery(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void beginResource(IStructuredDocumentResourceDiscoveryContext resourceContext, IProgressMonitor monitor) {
        IResource res = resourceContext.getResource();
        String resPath = res.getProjectRelativePath().toString();
        String string = resPath = resPath.startsWith("/") ? resPath.substring(1) : resPath;
        if (res instanceof IFile && resPath.startsWith("adfmsrc")) {
            DataType dataType;
            IFile file = (IFile)res;
            BindingsVariable bindingsVar = BindingsVariableCache.getInstance().getBindingsVariable(file);
            boolean fieldsEmpty = true;
            if (bindingsVar != null && (dataType = bindingsVar.getType()) != null) {
                List fields = dataType.getFields(null);
                boolean bl = fieldsEmpty = fields == null || fields.size() == 0;
            }
            if (bindingsVar == null || fieldsEmpty || !resourceContext.isWorkingCopy()) {
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("creating new binding variable in " + file);
                }
                bindingsVar = ADFUtil.createBindingsVariable(file.getProject(), file, monitor);
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("done creating new binding variable in " + file);
                }
            } else if (TraceOptions.BINDINGS_VARIABLES) {
                TraceOptions.log("reusing binding variable in " + file);
            }
        }
    }

    public void endResource(IStructuredDocumentResourceDiscoveryContext resourceContext, IProgressMonitor monitor) {
    }

    public boolean match(IResourceDiscoveryContext context) {
        return FILTER.match((IResourceContext)context);
    }

    public Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        if (changedResources == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<IResource> dependentResources = new HashSet<IResource>();
        for (IResource res : changedResources) {
            String resPath = res.getProjectRelativePath().toString();
            String string = resPath = resPath.startsWith("/") ? resPath.substring(1) : resPath;
            if (!(res instanceof IFile) || !resPath.startsWith("adfmsrc") || !ADFmPageDefinitionConfigTypeFilter.getInstance().match(res)) continue;
            dependentResources.addAll(ADFUtil.getViewFilesForPagedef((IFile)res));
            dependentResources.addAll(ADFUtil.getTaskflowFilesForPagedef((IFile)res));
        }
        return dependentResources;
    }
}

