/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.ContextCache;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.internal.TraceOptions;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.adf.view.variables.BindingsVariable;
import oracle.eclipse.tools.adf.view.variables.BindingsVariableCache;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class AbstractADFBindingsDiscoveryParticipant {
    protected void discoverResource(IResourceDiscoveryContext resourceContext, IProgressMonitor monitor) {
        IFileVariablesCache cache = (IFileVariablesCache)resourceContext.getAdapter(IFileVariablesCache.class);
        if (cache == null) {
            return;
        }
        IResource res = resourceContext.getResource();
        if (res instanceof IFile) {
            BindingsVariable bindingsVariable;
            IFile file = (IFile)res;
            if (resourceContext.isWorkingCopy() && (bindingsVariable = this.createWorkingCopyOfBindingVariable(file)) != null) {
                cache.add((Variable)bindingsVariable);
                return;
            }
            this.discoverFromDisk(file, cache, monitor);
        }
    }

    protected void discoverFromDisk(IFile file, IFileVariablesCache cache, IProgressMonitor monitor) {
        IFile pageDefinitionFile;
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)file);
        if (earProject == null) {
            return;
        }
        IPageDefinition pageDefinition = locator.getPageDefinitionForWebPage(earProject, file);
        if (pageDefinition != null && (pageDefinitionFile = locator.getAccessibleFile((IObject)pageDefinition)) != null) {
            BindingsVariable bindingsVar = BindingsVariableCache.getInstance().getBindingsVariable(pageDefinitionFile);
            boolean fieldsEmpty = true;
            if (bindingsVar != null) {
                DataType dataType;
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("reusing binding variable in " + file);
                }
                if ((dataType = bindingsVar.getType()) != null) {
                    List fields = dataType.getFields(null);
                    boolean bl = fieldsEmpty = fields == null || fields.size() == 0;
                }
            }
            if (bindingsVar == null || fieldsEmpty) {
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("creating new binding variable in " + file);
                }
                bindingsVar = ADFUtil.createBindingsVariable(file.getProject(), pageDefinitionFile, monitor);
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("done creating new binding variable in " + file);
                }
            }
            cache.add((Variable)bindingsVar);
        }
    }

    protected final BindingsVariable createWorkingCopyOfBindingVariable(IFile file) {
        IWebPageContext webPageContext = (IWebPageContext)ContextCache.getInstance().get(IWebPageContext.class, (Object)file);
        if (webPageContext != null && (webPageContext.needsSaving() || webPageContext.isDirty())) {
            IPageDefinition pageDefinition = webPageContext.getPageDefinition();
            if (TraceOptions.BINDINGS_VARIABLES) {
                TraceOptions.log("creating new binding variable from webPageContext in " + file);
            }
            if (pageDefinition != null) {
                Project project = (Project)file.getProject().getAdapter(Project.class);
                IFile accessibleFile = webPageContext.getAccessibleFile((IObject)pageDefinition);
                return new BindingsVariable(project, pageDefinition, accessibleFile != null ? new ResourceLocation((IResource)accessibleFile, null) : null);
            }
        }
        return null;
    }
}

