/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.tagsupport;

import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.adf.view.tagsupport.ADFBindingsTypedSymbol;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTaglibContextResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.designtime.symbols.AbstractDataModelVariableFactory;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ADFSymbolFactory
extends AbstractContextSymbolFactory {
    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems, IAdditionalContextSymbolInfo additionalInfo) {
        Attr attr;
        Element owningElement;
        Node curNode;
        ISymbol symbol = null;
        IStructuredDocumentContext sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class);
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(sContext);
        if (domResolver != null && (curNode = domResolver.getNode()) instanceof Attr && (owningElement = (attr = (Attr)curNode).getOwnerElement()) != null && owningElement.getNodeType() == 1) {
            symbol = this.handleSymbolCreation(symbolName, sContext, attr, owningElement, problems);
        }
        if (symbol == null) {
            symbol = this.getDefaultSymbol(symbolName);
        }
        return symbol;
    }

    public boolean supports(IAdaptable context) {
        return context != null && context.getAdapter(IStructuredDocumentContext.class) != null && this.getJavaProject(context) != null;
    }

    private ISymbol handleSymbolCreation(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement, List<?> problems) {
        MergedTaglibContextResolver resolver = null;
        if (!(owningElement instanceof IDOMElement)) {
            return null;
        }
        IMergedModelNode mmNode = (IMergedModelNode)((IDOMElement)owningElement).getAdapterFor(IMergedModelNode.class);
        if (mmNode != null) {
            resolver = new MergedTaglibContextResolver(context);
        }
        if (resolver == null) {
            resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        }
        if (resolver == null || !resolver.canResolveContext((IModelContext)context)) {
            return null;
        }
        String uri = resolver.getTagURIForNodeName((Node)owningElement);
        ISymbol symbol = null;
        if ("http://xmlns.oracle.com/adf/faces/rich".equals(uri)) {
            symbol = this.handleADFFacesTags(symbolName, context, attr, owningElement);
        }
        return symbol;
    }

    private ISymbol handleADFFacesTags(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement) {
        ISymbol symbol = null;
        String elementName = owningElement.getLocalName();
        String attrName = attr.getName();
        if ("forEach".equals(elementName)) {
            if ("var".equals(attrName)) {
                symbol = this.handleForEachTag(symbolName, context, attr, owningElement);
            }
        } else if (!"componentDef".equals(elementName) && !"pageTemplateDef".equals(elementName) && "var".equals(attrName)) {
            symbol = this.createSymbolFromValueAttr(symbolName, context, attr, owningElement);
        }
        return symbol;
    }

    private ISymbol handleForEachTag(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement) {
        return this.createSymbol(symbolName, context, owningElement, "items");
    }

    private ISymbol createSymbolFromValueAttr(String symbolName, IStructuredDocumentContext context, Attr attr, Element owningElement) {
        return this.createSymbol(symbolName, context, owningElement, "value");
    }

    private ISymbol createSymbol(String symbolName, IStructuredDocumentContext context, Element element, String valueAttrName) {
        MyDataModelVariableFactory dataModelVarFactory = new MyDataModelVariableFactory(element.getLocalName());
        String elText = MyDataModelVariableFactory.getELText(element, valueAttrName);
        IFile file = FileContextUtil.deriveIFileFromContext((IAdaptable)context);
        if (elText != null && file != null) {
            DataType dataType;
            if (elText.startsWith("bindings.") && elText.endsWith(".collectionModel") && (dataType = this.getCollectionModelDataType(element, this.getFile(context), elText)) != null) {
                ISymbol symbol = dataModelVarFactory.getSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null);
                ADFBindingsTypedSymbol typedSymbol = new ADFBindingsTypedSymbol(symbol);
                typedSymbol.setDataType(dataType);
                return typedSymbol;
            }
            IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), (Node)element.getAttributeNode(valueAttrName));
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            ValueType valueExpr = new JSFSymbolFactory().getValueTypeFromEL(elText, elContext, file);
            if (valueExpr != null) {
                return dataModelVarFactory.createFromType(symbolName, valueExpr, javaProject);
            }
        }
        return dataModelVarFactory.getSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null);
    }

    private ISymbol getDefaultSymbol(String symbolName) {
        IComponentSymbol cSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        cSymbol.setName(symbolName);
        cSymbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        IComponentSymbol symbol = cSymbol;
        return symbol;
    }

    private IJavaProject getJavaProject(IAdaptable context) {
        IProject project;
        IStructuredDocumentContext sContext;
        if (context != null && (sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class)) != null && (project = FileContextUtil.getProject((IStructuredDocumentContext)((IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class)))) != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    private DataType getCollectionModelDataType(Element owningElement, IFile file, String elText) {
        List variables = VariablesController.getInstance().iterator(file, true, false, null).getVariables();
        DataType bindingDT = null;
        if (variables != null) {
            for (Variable var : variables) {
                if (!var.getName().equals("bindings")) continue;
                bindingDT = var.getType();
                break;
            }
        }
        if (bindingDT != null) {
            StringTokenizer tokenizer = new StringTokenizer(elText.substring("bindings.".length()), ".");
            DataType dt = bindingDT;
            boolean foundToken = false;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                List fields = dt.getFields(null);
                foundToken = false;
                if (fields != null) {
                    for (DataType.Field field : fields) {
                        if (!field.getName().equals(token)) continue;
                        dt = field.getType();
                        foundToken = true;
                        break;
                    }
                }
                if (!foundToken) break;
            }
            if (foundToken) {
                return dt;
            }
        }
        return null;
    }

    private final IFile getFile(IStructuredDocumentContext context) {
        return this.getFile(this.getWorkspaceResolver(context));
    }

    private IFile getFile(IWorkspaceContextResolver resolver) {
        IResource curRes;
        if (resolver != null && (curRes = resolver.getResource()) instanceof IFile) {
            return (IFile)curRes;
        }
        return null;
    }

    private IWorkspaceContextResolver getWorkspaceResolver(IStructuredDocumentContext context) {
        IDOMContextResolver domContextResolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getDOMContextResolver(context);
        if (domContextResolver == null) {
            return null;
        }
        final Document owningDocument = domContextResolver.getDOMDocument();
        final IWorkspaceContextResolver rootResolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getWorkspaceContextResolver(context);
        if (owningDocument instanceof IDOMDocument && ((IDOMDocument)owningDocument).getAdapterFor(IMergedModelNode.class) != null) {
            return new IWorkspaceContextResolver(){

                public boolean canResolveContext(IModelContext modelContext) {
                    return rootResolver.canResolveContext(modelContext);
                }

                public IResource getResource() {
                    IMergedModelNode mmNode;
                    IResource testRes = rootResolver.getResource();
                    if (!testRes.exists() && (mmNode = (IMergedModelNode)((IDOMDocument)owningDocument).getAdapterFor(IMergedModelNode.class)) != null && mmNode.getBaseSourceFile() != null) {
                        testRes = mmNode.getBaseSourceFile();
                    }
                    return testRes;
                }

                public IProject getProject() {
                    return rootResolver.getProject();
                }
            };
        }
        return rootResolver;
    }

    private static class MyDataModelVariableFactory
    extends AbstractDataModelVariableFactory {
        private final String _variableSourceName;

        public MyDataModelVariableFactory(String sourceName) {
            this._variableSourceName = sourceName;
        }

        protected static String getELText(Element element, String valueAttrName) {
            assert (element != null);
            assert (valueAttrName != null);
            String attrVal = element.getAttribute(valueAttrName);
            if (attrVal != null) {
                return AppConfigValidationUtil.extractELExpression((String)attrVal).getElText();
            }
            return null;
        }

        protected String getVariableSourceName() {
            return this._variableSourceName;
        }
    }
}

