/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.server.internal;

import java.util.List;
import oracle.eclipse.tools.adf.view.internal.Messages;
import oracle.eclipse.tools.adf.view.internal.ServerModuleHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class AdfDomainCheckTask
extends PublishTaskDelegate {
    public PublishOperation[] getTasks(IServer server, int kind, List modules, List kindList) {
        IWeblogicServer ws = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (ws == null) {
            return new PublishOperation[0];
        }
        if (modules == null || modules.isEmpty()) {
            return new PublishOperation[0];
        }
        return new PublishOperation[]{new AdfDomainCheckOperation(server)};
    }

    class AdfDomainCheckOperation
    extends PublishOperation {
        IServer server = null;

        public AdfDomainCheckOperation(IServer server) {
            this.server = server;
        }

        public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
            IModule[] iModuleArray = this.server.getModules();
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule m = iModuleArray[n2];
                if (!(m instanceof DeletedModule) && ServerModuleHelper.hasAdfFacets(m)) {
                    if (ServerModuleHelper.isAdfDomainExtensionInstalled(this.server)) {
                        return;
                    }
                    String msg = Messages.ErrorADFWebProjectRequiresADFDomainExtension;
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", msg, (Throwable)new UnsupportedOperationException()));
                }
                ++n2;
            }
        }

        public int getOrder() {
            return 50;
        }

        public String getDescription() {
            return "ADF Domain Extension Check";
        }

        public int getKind() {
            return 2;
        }
    }
}

