/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFAppFileInfo {
    private IFile cpxFile;
    private IContainer webRoot;
    private IPath jspfileProjRelativePath;

    public ADFAppFileInfo(IFile cpxFile, IFile jspFile) throws InvalidADFAppFileException {
        if (cpxFile == null || !cpxFile.exists()) {
            throw new InvalidADFAppFileException("Invalid CPX file");
        }
        this.cpxFile = cpxFile;
        if (jspFile != null && jspFile.exists()) {
            this.computeJSPFileInfo(jspFile);
        }
    }

    public ADFAppFileInfo(IFile jspFile) throws InvalidADFAppFileException {
        if (jspFile == null || !jspFile.exists()) {
            throw new InvalidADFAppFileException("Invalid JSP file");
        }
        this.computeJSPFileInfo(jspFile);
        this.cpxFile = ADFUtil.getApplicationForViewFile(jspFile);
        if (this.cpxFile == null || !this.cpxFile.exists()) {
            throw new InvalidADFAppFileException("Invalid cpx file");
        }
    }

    public final IFile getADFAppFile() {
        return this.cpxFile;
    }

    public final MatchingPageSourceInformation getSourceInfoForMatchingPage() throws CoreException, IOException, InvalidADFAppFileException {
        MatchingPageSourceInformation pageSourceInfo;
        block15: {
            if (this.jspfileProjRelativePath == null || this.webRoot == null) {
                throw new InvalidADFAppFileException("Invalid JSP file information");
            }
            pageSourceInfo = new MatchingPageSourceInformation();
            int toRemove = this.jspfileProjRelativePath.matchingFirstSegments(this.webRoot.getProjectRelativePath());
            this.jspfileProjRelativePath = this.jspfileProjRelativePath.removeFirstSegments(toRemove);
            IStructuredModel sm = null;
            try {
                IDOMElement pageDefUsagesElement;
                NodeList pageElements;
                Node pageDefUsagesNode;
                IDOMElement pageMapElement;
                NodeList pageElements2;
                Node pageMapNode;
                sm = StructuredModelManager.getModelManager().getModelForRead(this.cpxFile);
                IDOMModel domModel = (IDOMModel)sm;
                Element element = domModel.getDocument().getDocumentElement();
                String usageId = null;
                NodeList pageMapNodes = element.getElementsByTagName("pageMap");
                Node node = pageMapNode = pageMapNodes != null ? pageMapNodes.item(0) : null;
                if (pageMapNode instanceof IDOMElement && (pageElements2 = (pageMapElement = (IDOMElement)pageMapNode).getElementsByTagName("page")) != null) {
                    int i = 0;
                    int len = pageElements2.getLength();
                    while (i < len) {
                        String pagePath;
                        IDOMElement page = (IDOMElement)pageElements2.item(i);
                        IDOMAttr pathAttr = (IDOMAttr)page.getAttributeNode("path");
                        String string = pagePath = pathAttr != null ? pathAttr.getValue() : null;
                        if (pagePath != null) {
                            Path path;
                            if (pagePath.startsWith("/")) {
                                pagePath = pagePath.substring(1, pagePath.length());
                            }
                            if (this.jspfileProjRelativePath.equals((Object)(path = new Path(pagePath))) && page.getStartOffset() != -1 && page.getEndOffset() != -1) {
                                IDOMAttr usageIdAttr = (IDOMAttr)page.getAttributeNode("usageId");
                                String string2 = usageId = usageIdAttr != null ? usageIdAttr.getValue() : null;
                                if (usageId != null) {
                                    pageSourceInfo.pageMapPageInfo = new PageMapPageInfo(new AttrInfo("/" + pagePath, pathAttr.getValueRegionStartOffset() + 1), new AttrInfo(usageId, usageIdAttr.getValueRegionStartOffset() + 1), page.getStartOffset(), page.getEndOffset());
                                    break;
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (usageId == null || usageId.equals("")) {
                    MatchingPageSourceInformation matchingPageSourceInformation = pageSourceInfo;
                    return matchingPageSourceInformation;
                }
                NodeList pageDefUsagesNodes = element.getElementsByTagName("pageDefinitionUsages");
                Node node2 = pageDefUsagesNode = pageDefUsagesNodes != null ? pageDefUsagesNodes.item(0) : null;
                if (!(pageDefUsagesNode instanceof IDOMElement) || (pageElements = (pageDefUsagesElement = (IDOMElement)pageDefUsagesNode).getElementsByTagName("page")) == null) break block15;
                int i = 0;
                int len = pageElements.getLength();
                while (i < len) {
                    String id;
                    IDOMElement pageElem = (IDOMElement)pageElements.item(i);
                    IDOMAttr idAttr = (IDOMAttr)pageElem.getAttributeNode("id");
                    String string = id = idAttr != null ? idAttr.getValue() : null;
                    if (id != null && usageId.equals(id) && pageElem.getStartOffset() != -1 && pageElem.getEndOffset() != -1) {
                        IDOMAttr pathAttr = (IDOMAttr)pageElem.getAttributeNode("path");
                        String path = pathAttr != null ? pathAttr.getValue() : null;
                        pageSourceInfo.pageDefnUsagePageInfo = new PageDefnUsagePageInfo(new AttrInfo(path, pathAttr != null ? pathAttr.getValueRegionStartOffset() + 1 : -1), new AttrInfo(id, idAttr.getValueRegionStartOffset() + 1), pageElem.getStartOffset(), pageElem.getEndOffset());
                        break;
                    }
                    ++i;
                }
            }
            finally {
                if (sm != null) {
                    sm.releaseFromRead();
                }
            }
        }
        return pageSourceInfo;
    }

    public MatchingPageDefNameInformation findMatchingPageDefNameInformation(String pageDefName) throws CoreException, IOException {
        MatchingPageDefNameInformation matchingPageDefInfo = null;
        String pageDefId = null;
        IStructuredModel sm = null;
        try {
            IDOMElement pageMapElement;
            NodeList pageElements;
            Node pageMapNode;
            IDOMElement pageDefUsagesElement;
            NodeList pageElements2;
            Node pageDefUsagesNode;
            sm = StructuredModelManager.getModelManager().getModelForRead(this.cpxFile);
            IDOMModel domModel = (IDOMModel)sm;
            Element element = domModel.getDocument().getDocumentElement();
            NodeList pageDefUsagesNodes = element.getElementsByTagName("pageDefinitionUsages");
            Node node = pageDefUsagesNode = pageDefUsagesNodes != null ? pageDefUsagesNodes.item(0) : null;
            if (pageDefUsagesNode instanceof IDOMElement && (pageElements2 = (pageDefUsagesElement = (IDOMElement)pageDefUsagesNode).getElementsByTagName("page")) != null) {
                int i = 0;
                int len = pageElements2.getLength();
                while (i < len) {
                    String path;
                    IDOMElement pageElem = (IDOMElement)pageElements2.item(i);
                    IDOMAttr pathAttr = (IDOMAttr)pageElem.getAttributeNode("path");
                    String string = path = pathAttr != null ? pathAttr.getValue() : null;
                    if (path != null && path.equals(pageDefName)) {
                        String id;
                        matchingPageDefInfo = new MatchingPageDefNameInformation();
                        IDOMAttr idAttr = (IDOMAttr)pageElem.getAttributeNode("id");
                        pageDefId = id = idAttr != null ? idAttr.getValue() : null;
                        matchingPageDefInfo.pageDefnUsagePageInfo = new PageDefnUsagePageInfo(new AttrInfo(path, pathAttr != null ? pathAttr.getValueRegionStartOffset() + 1 : -1), new AttrInfo(id, idAttr.getValueRegionStartOffset() + 1), pageElem.getStartOffset(), pageElem.getEndOffset());
                        break;
                    }
                    ++i;
                }
            }
            if (matchingPageDefInfo == null) {
                return null;
            }
            NodeList pageMapNodes = element.getElementsByTagName("pageMap");
            Node node2 = pageMapNode = pageMapNodes != null ? pageMapNodes.item(0) : null;
            if (pageMapNode instanceof IDOMElement && (pageElements = (pageMapElement = (IDOMElement)pageMapNode).getElementsByTagName("page")) != null) {
                int i = 0;
                int len = pageElements.getLength();
                while (i < len) {
                    String usageId;
                    IDOMElement page = (IDOMElement)pageElements.item(i);
                    IDOMAttr usageIdAttr = (IDOMAttr)page.getAttributeNode("usageId");
                    String string = usageId = usageIdAttr != null ? usageIdAttr.getValue() : null;
                    if (pageDefId.equals(usageId)) {
                        IDOMAttr pathAttr = (IDOMAttr)page.getAttributeNode("path");
                        String pagePath = pathAttr != null ? pathAttr.getValue() : null;
                        matchingPageDefInfo.addPageMapPageInfo(new PageMapPageInfo(new AttrInfo("/" + pagePath, pathAttr.getValueRegionStartOffset() + 1), new AttrInfo(usageId, usageIdAttr.getValueRegionStartOffset() + 1), page.getStartOffset(), page.getEndOffset()));
                    }
                    ++i;
                }
            }
        }
        finally {
            if (sm != null) {
                sm.releaseFromRead();
            }
        }
        return matchingPageDefInfo;
    }

    private void computeJSPFileInfo(IFile jspFile) {
        this.webRoot = ADFAppFileInfo.getWebContentResource(jspFile.getProject());
        this.jspfileProjRelativePath = jspFile.getProjectRelativePath();
    }

    private static IContainer getWebContentResource(IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder();
        }
        return null;
    }

    public static final class AttrInfo {
        private String value;
        private int startOffset;

        public AttrInfo(String attrValue, int startOffset) {
            this.value = attrValue;
            this.startOffset = startOffset;
        }

        public String getAttrValue() {
            return this.value;
        }

        public int getValueStartOffset() {
            return this.startOffset;
        }
    }

    public static class InvalidADFAppFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidADFAppFileException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidADFAppFileException(String message) {
            super(message);
        }

        public InvalidADFAppFileException(Throwable cause) {
            super(cause);
        }
    }

    public static final class MatchingPageDefNameInformation {
        private List<PageMapPageInfo> pageMapPageInfo;
        private PageDefnUsagePageInfo pageDefnUsagePageInfo;

        public List<PageMapPageInfo> getPageMapPageInfo() {
            return this.pageMapPageInfo;
        }

        public PageDefnUsagePageInfo getPageDefnUsagePageInfo() {
            return this.pageDefnUsagePageInfo;
        }

        private void addPageMapPageInfo(PageMapPageInfo pageMap) {
            if (this.pageMapPageInfo == null) {
                this.pageMapPageInfo = new ArrayList<PageMapPageInfo>();
            }
            this.pageMapPageInfo.add(pageMap);
        }
    }

    public static final class MatchingPageSourceInformation {
        private PageMapPageInfo pageMapPageInfo;
        private PageDefnUsagePageInfo pageDefnUsagePageInfo;

        public PageMapPageInfo getPageMapPageInfo() {
            return this.pageMapPageInfo;
        }

        public PageDefnUsagePageInfo getPageDefnUsagePageInfo() {
            return this.pageDefnUsagePageInfo;
        }
    }

    public static final class PageDefnUsagePageInfo {
        private AttrInfo pathAttrInfo;
        private AttrInfo idAttrInfo;
        private int startOffset;
        private int endOffset;

        public PageDefnUsagePageInfo(AttrInfo pathAttrInfo, AttrInfo idAttrInfo, int startOffset, int endOffset) {
            this.pathAttrInfo = pathAttrInfo;
            this.idAttrInfo = idAttrInfo;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public AttrInfo getPathAttrInfo() {
            return this.pathAttrInfo;
        }

        public AttrInfo getIdAttrInfo() {
            return this.idAttrInfo;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    public static final class PageMapPageInfo {
        private AttrInfo pathAttrInfo;
        private AttrInfo usageIdAttrInfo;
        private int startOffset;
        private int endOffset;

        public PageMapPageInfo(AttrInfo pathAttrInfo, AttrInfo usageIdAttrInfo, int startOffset, int endOffset) {
            this.pathAttrInfo = pathAttrInfo;
            this.usageIdAttrInfo = usageIdAttrInfo;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public AttrInfo getPathAttrInfo() {
            return this.pathAttrInfo;
        }

        public AttrInfo getUsageIdAttrInfo() {
            return this.usageIdAttrInfo;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

