/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.launch;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.common.util.ADFCommonUtils;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.launch.TaskFlowLaunchUtil;
import oracle.eclipse.tools.adf.view.launch.TaskFlowLaunchable;
import oracle.eclipse.tools.adf.view.launch.ViewActivityData;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.WebResource;

public class TaskFlowLaunchableAdapter
extends LaunchableAdapterDelegate {
    public TaskFlowLaunchable getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        WebResource webResource;
        if (server != null && server.getRuntime() != null && ADFCommonUtils.SUPPORTED_RUNTIME_TYPES.contains(server.getRuntime().getRuntimeType()) && moduleArtifact instanceof WebResource && (webResource = (WebResource)moduleArtifact).getPath() != null) {
            IResource resource;
            IProject project = webResource.getModule().getProject();
            IContainer webContentFolder = ProjectUtil.getWebContentFolderIResource((IProject)project);
            if (webContentFolder == null) {
                webContentFolder = project;
            }
            if ((resource = webContentFolder.findMember(webResource.getPath())) instanceof IFile) {
                IFile file = (IFile)resource;
                ITaskFlow taskFlow = TaskFlowFactory.createTaskFlow((IFile)file);
                if (taskFlow != null) {
                    TaskFlowLaunchable.Type type = TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)taskFlow) ? TaskFlowLaunchable.Type.BOUNDED_TASK_FLOW : TaskFlowLaunchable.Type.UNBOUNDED_TASK_FLOW;
                    TaskFlowLaunchable launchable = new TaskFlowLaunchable(type, file, webResource, webContentFolder);
                    launchable.setTaskFlow(taskFlow);
                    return launchable;
                }
            } else {
                IFile file;
                Collection<? extends ViewActivityData> viewActivities;
                IPath path;
                IPath facesPath = TaskFlowLaunchUtil.computeFacesPath(webContentFolder);
                if (facesPath != null && (resource = webContentFolder.findMember(path = webResource.getPath().makeRelativeTo(facesPath))) instanceof IFile && !(viewActivities = this.getReferencingViews(file = (IFile)resource)).isEmpty()) {
                    TaskFlowLaunchable launchable = new TaskFlowLaunchable(TaskFlowLaunchable.Type.JSP_PAGE, file, webResource, webContentFolder);
                    launchable.getViewActivities().addAll(viewActivities);
                    return launchable;
                }
            }
        }
        return null;
    }

    private Collection<? extends ViewActivityData> getReferencingViews(IFile file) {
        HashSet<ViewActivityData> viewActivities = new HashSet<ViewActivityData>();
        try {
            IDependencyModel model = DependencyModelManager.getInstance().getModel();
            ResourceArtifact artifact = model.ensureResourceArtifact((IResource)file);
            HashSet<String> types = new HashSet<String>(2);
            types.add("adf-control-flow-rule");
            types.add("adf-view-activity");
            Set typedArtifacts = model.queryArtifactsByTypes(types, file.getProject());
            for (IArtifact typedArtifact : typedArtifacts) {
                IFile activityFile;
                IResource activityResource;
                String activityId = typedArtifact.getName();
                if (activityId == null || typedArtifact.getLocation() == null || !((activityResource = typedArtifact.getLocation().getResource()) instanceof IFile) || TaskFlowUtil.getTaskFlowType((IFile)(activityFile = (IFile)activityResource)) != TaskFlowType.Unbounded) continue;
                for (IArtifactReference reference : typedArtifact.getReferences()) {
                    if (!reference.refersTo((IArtifact)artifact)) continue;
                    viewActivities.add(new ViewActivityData(activityId, (IFile)activityResource));
                }
            }
        }
        catch (Exception e) {
            ADFPlugin.log(e);
        }
        return viewActivities;
    }
}

