/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.launch;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.controller.model.IADFView;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IInputParameterDefinition;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.launch.TaskFlowLaunchUtil;
import oracle.eclipse.tools.adf.view.launch.TaskFlowLaunchable;
import oracle.eclipse.tools.adf.view.launch.ViewActivityData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.ClientDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;

public abstract class TaskFlowLaunchClient
extends ClientDelegate {
    public boolean supports(IServer server, Object launchable, String launchMode) {
        return launchable instanceof TaskFlowLaunchable && ((TaskFlowLaunchable)launchable).getType() != null;
    }

    public IStatus launch(IServer server, Object launchable, String launchMode, ILaunch launch) {
        try {
            return this.doLaunch(server, launchable, launchMode, launch);
        }
        catch (Exception e) {
            ADFPlugin.log(e);
            return new Status(4, "oracle.eclipse.tools.adf.view", Messages.getFailToLaunchTaskFlowMessage(launchMode), (Throwable)e);
        }
    }

    private IStatus doLaunch(IServer server, Object launchable, String launchMode, ILaunch launch) throws Exception {
        Status status;
        TaskFlowLaunchable taskFlowLaunchable = (TaskFlowLaunchable)launchable;
        String facesURL = TaskFlowLaunchUtil.computeFacesURL(server, taskFlowLaunchable.getWebResource().getModule(), taskFlowLaunchable.getWebContentFolder());
        switch (taskFlowLaunchable.getType()) {
            case BOUNDED_TASK_FLOW: {
                status = this.getURLForBoundedTaskFlow(launchMode, server, facesURL, taskFlowLaunchable.getTaskFlow(), taskFlowLaunchable.getFile(), taskFlowLaunchable.getWebResource().getPath());
                break;
            }
            case UNBOUNDED_TASK_FLOW: {
                status = this.getURLForUnboundedTaskFlow(launchMode, server, facesURL, taskFlowLaunchable.getTaskFlow(), taskFlowLaunchable.getFile(), taskFlowLaunchable.getWebResource().getPath());
                break;
            }
            case JSP_PAGE: {
                status = this.getURLForJSFPage(launchMode, server, facesURL, taskFlowLaunchable.getFile(), taskFlowLaunchable.getViewActivities());
                break;
            }
            default: {
                status = new Status(4, "oracle.eclipse.tools.adf.view", Messages.getFailToLaunchTaskFlowMessage(launchMode));
            }
        }
        if (status.isOK()) {
            String url = status.getMessage();
            HttpLaunchable httpLaunchable = new HttpLaunchable(new URL(url));
            ADFPlugin.logInfo(NLS.bind((String)Messages.targetURL, (Object)url));
            status = this.launch(server, httpLaunchable, launchMode, launch);
        }
        return status;
    }

    protected abstract IStatus launch(IServer var1, HttpLaunchable var2, String var3, ILaunch var4);

    protected abstract IADFView selectViewActivity(String var1, ITaskFlow var2, IFile var3, IPath var4, Collection<? extends IADFView> var5);

    protected abstract ViewActivityData selectViewActivity(String var1, IFile var2, Collection<? extends ViewActivityData> var3);

    protected abstract boolean setValues(String var1, IFile var2, Map<IInputParameterDefinition, String> var3);

    private IStatus getURLForBoundedTaskFlow(String launchMode, IServer server, String facesURL, ITaskFlow taskFlow, IFile file, IPath webResourcePath) {
        if (taskFlow.isUsePageFragments().content() == Boolean.TRUE) {
            return new Status(4, "oracle.eclipse.tools.adf.view", NLS.bind((String)Messages.usesPageFragmentError, (Object)TaskFlowLaunchUtil.getDisplayName(taskFlow, webResourcePath)));
        }
        LinkedHashMap<IInputParameterDefinition, String> valuesMap = null;
        if (!taskFlow.getInputParameters().isEmpty()) {
            valuesMap = new LinkedHashMap<IInputParameterDefinition, String>(taskFlow.getInputParameters().size());
            for (IInputParameterDefinition inputParameterDefinition : taskFlow.getInputParameters()) {
                valuesMap.put(inputParameterDefinition, null);
            }
            if (!this.setValues(launchMode, file, valuesMap)) {
                return new Status(8, "oracle.eclipse.tools.adf.view", null);
            }
            for (Map.Entry entry : valuesMap.entrySet()) {
                if (entry.getValue() != null || ((IInputParameterDefinition)entry.getKey()).isRequired().content() != Boolean.TRUE) continue;
                return new Status(4, "oracle.eclipse.tools.adf.view", NLS.bind((String)Messages.missingRequiredParameter, (Object)TaskFlowLaunchUtil.getDisplayName(taskFlow, webResourcePath)));
            }
        }
        String url = String.valueOf(facesURL) + "adf.task-flow?" + this.computeBoundedTaskFlowURLQuery(taskFlow, webResourcePath, valuesMap);
        return new Status(0, "oracle.eclipse.tools.adf.view", url);
    }

    private IStatus getURLForUnboundedTaskFlow(String launchMode, IServer server, String facesURL, ITaskFlow taskFlow, IFile file, IPath webResourcePath) {
        IADFView viewActivity;
        ArrayList<IADFView> viewActivities = new ArrayList<IADFView>(taskFlow.getActivities().size());
        for (IActivity activity : taskFlow.getActivities()) {
            if (!(activity instanceof IADFView)) continue;
            viewActivities.add((IADFView)activity);
        }
        if (viewActivities.isEmpty()) {
            return new Status(4, "oracle.eclipse.tools.adf.view", NLS.bind((String)Messages.noViewActivityError, (Object)TaskFlowLaunchUtil.getDisplayName(taskFlow, webResourcePath)));
        }
        IADFView iADFView = viewActivity = viewActivities.size() == 1 ? (IADFView)viewActivities.get(0) : this.selectViewActivity(launchMode, taskFlow, file, webResourcePath, viewActivities);
        if (viewActivity != null && viewActivity.getActivityId() != null) {
            String url = String.valueOf(facesURL) + viewActivity.getActivityId();
            return new Status(0, "oracle.eclipse.tools.adf.view", url);
        }
        return new Status(8, "oracle.eclipse.tools.adf.view", null);
    }

    private IStatus getURLForJSFPage(String launchMode, IServer server, String facesURL, IFile file, Collection<? extends ViewActivityData> viewActivities) {
        ViewActivityData viewActivity;
        ViewActivityData viewActivityData = viewActivity = viewActivities.size() == 1 ? viewActivities.iterator().next() : this.selectViewActivity(launchMode, file, viewActivities);
        if (viewActivity != null) {
            String url = String.valueOf(facesURL) + viewActivity.getId();
            return new Status(0, "oracle.eclipse.tools.adf.view", url);
        }
        return new Status(8, "oracle.eclipse.tools.adf.view", null);
    }

    private String computeBoundedTaskFlowURLQuery(ITaskFlow taskFlow, IPath webResourcePath, Map<? extends IInputParameterDefinition, ? extends String> valuesMap) {
        StringBuilder query = new StringBuilder();
        query.append("adf.tfId=").append(this.encodeQueryElement(taskFlow.getTaskFlowId()));
        query.append("&adf.tfDoc=").append(this.encodeQueryElement(webResourcePath));
        if (valuesMap != null) {
            for (Map.Entry<? extends IInputParameterDefinition, ? extends String> entry : valuesMap.entrySet()) {
                query.append('&').append(this.encodeQueryElement(entry.getKey().getName())).append('=').append(this.encodeQueryElement(entry.getValue()));
            }
        }
        return query.toString();
    }

    private String encodeQueryElement(Object element) {
        if (element == null) {
            return "";
        }
        String encoded = element.toString();
        encoded = URI.encodeQuery((String)encoded, (boolean)true);
        encoded = encoded.replace(";", "%3B");
        encoded = encoded.replace("/", "%2F");
        encoded = encoded.replace("?", "%3F");
        encoded = encoded.replace(":", "%3A");
        encoded = encoded.replace("@", "%40");
        encoded = encoded.replace("&", "%26");
        encoded = encoded.replace("=", "%3D");
        encoded = encoded.replace("+", "%2B");
        encoded = encoded.replace(",", "%2C");
        encoded = encoded.replace("$", "%24");
        encoded = encoded.replace("%2F", "/");
        return encoded;
    }

    private static final class Messages
    extends NLS {
        public static String usesPageFragmentError;
        public static String missingRequiredParameter;
        public static String noViewActivityError;
        public static String targetURL;
        public static String failToRunError;
        public static String failToDebugError;
        public static String failToProfileError;
        public static String failToLaunchError;

        static {
            Messages.initializeMessages((String)TaskFlowLaunchClient.class.getName(), Messages.class);
        }

        private Messages() {
        }

        public static String getFailToLaunchTaskFlowMessage(String launchMode) {
            return "run".equals(launchMode) ? failToRunError : ("debug".equals(launchMode) ? failToDebugError : ("profile".equals(launchMode) ? failToProfileError : failToLaunchError));
        }
    }
}

