/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.jsp.document;

import java.util.List;
import oracle.eclipse.tools.adf.view.internal.Messages;
import oracle.eclipse.tools.adf.view.jsp.document.ValueBindableComponentProviderForADF;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IValueBindableComponent;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.IComponentGenerationInfoProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceObservableValue;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.model.core.FacetType;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.context.IModelContext;

public class TableGenerator
extends EnumVarGenerator {
    private static final String FOOTER_FACET = "footer";
    private boolean _shouldGenerateColumnHeaders = true;
    private boolean _shouldGenerateColumnFooters = false;
    private AbstractBaseTag _tableElem;
    private IValueBindableComponentProvider _valueBindableComponentProvider = new ValueBindableComponentProviderForADF(this.getDocument());

    private static String getContentGeneratorDisplayName() {
        return Messages.TableGenerator_generator_name;
    }

    public TableGenerator(IDocument document) {
        super(document, TableGenerator.getContentGeneratorDisplayName());
    }

    public TableGenerator(IDocument document, AbstractBaseTag tableElem) {
        this(document);
        this._tableElem = tableElem;
    }

    public EObject getFragment() {
        Variable iterationVariable = this.getIterationVariable();
        List fields = this.getFieldsGenerationInfos();
        if (this._tableElem == null) {
            this._tableElem = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "table");
            this.setTagFeature(this._tableElem, "id", "table" + this.getIterationVariable().getName());
        }
        if (this.getDocumentBinderProvider() != null) {
            IObservableValue tagObservable = EMFObservables.observeValue((EObject)this._tableElem, (EStructuralFeature)this.getDefaultBindableFeature(this._tableElem.eClass()));
            ValueReferenceObservableValue modelObservable = new ValueReferenceObservableValue(this.getEnumeration());
            Binding binding = this.getDocumentBinderProvider().createBinding(null, tagObservable, (IObservableValue)modelObservable);
            if (binding != null) {
                binding.updateModelToTarget();
                binding.dispose();
            }
        }
        this.setTagFeature(this._tableElem, "var", this.getIterationVariable().getName());
        EnumVarGenerator.IDataTypeHint hint = this.createDataTypeHint();
        hint.getFlag();
        if (fields.size() == 0 && iterationVariable.getType().getFields((IModelContext)new FilePositionContext(this.getDocument().getFile())).isEmpty()) {
            fields.add(new FieldGenerationInfo(new ValueReference(iterationVariable, null), (IComponentGenerationInfoProvider)this, this.getDocument().getFile()));
        }
        if (fields.size() != 0) {
            this.addTableColumns(this._tableElem, fields);
        }
        this.createValidationIfNecessary(fields);
        if (this.doFooter()) {
            FacetType facet = this.createFacetWithLabel(FOOTER_FACET, "Footer");
            this._tableElem.getChildTags().add((Object)facet);
        }
        return this._tableElem;
    }

    private void createValidationIfNecessary(List<FieldGenerationInfo> fields) {
        if (this.doValidationMessage()) {
            AbstractBaseTag column = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "column");
            this._tableElem.getChildTags().add((Object)column);
            this.setTagFeature(column, "sortable", Boolean.FALSE);
            this.setTagFeature(column, "id", "validation");
            if (this._shouldGenerateColumnHeaders) {
                String fieldName = Messages.TableGenerator_validationColumnName;
                this.setTagFeature(column, "headerText", fieldName);
            }
            AbstractBaseTag validationMsgs = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "messages");
            if (this.getValidationStyleClassName() != null) {
                this.setTagFeature(validationMsgs, "styleClass", this.getValidationStyleClassName());
            }
            column.getChildTags().add((Object)validationMsgs);
        }
    }

    private FacetType createFacetWithLabel(String type, String display) {
        FacetType facet = (FacetType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/core", "facet");
        facet.setName(type);
        AbstractBaseTag label = (AbstractBaseTag)this.getValueBindableComponentProvider().getValueBindableComponent(ComponentGenerationInfo.ComponentType.Label).getComponent();
        this.setTagFeature(label, "value", display);
        this.setTagFeature(label, "id", String.valueOf(display) + "_out");
        facet.getChildTags().add((Object)label);
        return facet;
    }

    private void addTableColumns(AbstractBaseTag tableElem, List<FieldGenerationInfo> fields) {
        int colCount = 0;
        for (FieldGenerationInfo fieldGenInfo : fields) {
            AbstractBaseTag column = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "column");
            tableElem.getChildTags().add((Object)column);
            this.setTagFeature(column, "sortProperty", fieldGenInfo.getValueReference().getFieldName());
            this.setTagFeature(column, "sortable", Boolean.FALSE);
            this.setTagFeature(column, "id", "c" + colCount++);
            if (this._shouldGenerateColumnHeaders && fields.size() > 1) {
                this.setTagFeature(column, "headerText", fieldGenInfo.getLabel());
            }
            IValueBindableComponent fieldComp = this.getValueBindableComponent(fieldGenInfo);
            AbstractBaseTag bindableValueTag = null;
            EStructuralFeature bindableValueFeature = null;
            if (fieldComp != null) {
                bindableValueTag = (AbstractBaseTag)fieldComp.getComponent();
                bindableValueFeature = fieldComp.getBindableValueAttribute();
            }
            if (bindableValueTag == null) {
                bindableValueTag = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "outputText");
                bindableValueFeature = this.getDefaultBindableFeature(bindableValueTag.eClass());
            }
            if (fieldComp != null) {
                bindableValueTag.eSet(fieldComp.getIdAttribute(), (Object)this.generateId(fieldGenInfo));
            }
            if (!fieldGenInfo.getComponentGenerationInfo().isEnabled() && bindableValueTag.eClass().getEStructuralFeature("disabled") != null) {
                bindableValueTag.eSet(bindableValueTag.eClass().getEStructuralFeature("disabled"), (Object)"true");
            }
            if (this.getDocumentBinderProvider() != null) {
                IObservableValue tagAttrObservable = EMFObservables.observeValue((EObject)bindableValueTag, (EStructuralFeature)bindableValueFeature);
                ValueReferenceObservableValue valRefObservable = new ValueReferenceObservableValue(fieldGenInfo.getValueReference());
                Binding binder = this.getDocumentBinderProvider().createBinding(null, tagAttrObservable, (IObservableValue)valRefObservable);
                if (binder != null) {
                    binder.updateModelToTarget();
                    binder.dispose();
                    column.getChildTags().add((Object)bindableValueTag);
                }
            }
            if (!this._shouldGenerateColumnFooters) continue;
            FacetType footerFacet = this.createFacetWithLabel(FOOTER_FACET, FOOTER_FACET);
            column.getChildTags().add((Object)footerFacet);
        }
    }

    public boolean shouldGenerateColumnFooters() {
        return this._shouldGenerateColumnFooters;
    }

    public void setShouldGenerateColumnFooters(boolean shouldGenerateColumnFooters) {
        this._shouldGenerateColumnFooters = shouldGenerateColumnFooters;
    }

    public boolean shouldGenerateColumnHeaders() {
        return this._shouldGenerateColumnHeaders;
    }

    public void setShouldGenerateColumnHeaders(boolean shouldGenerateHeaders) {
        this._shouldGenerateColumnHeaders = shouldGenerateHeaders;
    }

    protected IValueBindableComponentProvider getValueBindableComponentProvider() {
        return this._valueBindableComponentProvider;
    }

    private boolean setTagFeature(AbstractBaseTag tag, String featureName, Object featureValue) {
        EStructuralFeature feature = tag.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            tag.eSet(feature, featureValue);
            return true;
        }
        return false;
    }
}

