/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.jsp.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfTaskflowActivityIDArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowCaseOutcomeArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ControlCaseOutcomeProvider
extends AbstractDocumentService
implements INavigationCaseProvider {
    public ControlCaseOutcomeProvider(IDocument document) {
        super(document);
    }

    public Collection<? extends ControlFlowCaseOutcomeArtifact> getFromNavigationCases() {
        return this.getNavigationCases(true);
    }

    public Collection<? extends ControlFlowCaseOutcomeArtifact> getToNavigationCases() {
        return this.getNavigationCases(false);
    }

    private Collection<? extends ControlFlowCaseOutcomeArtifact> getNavigationCases(boolean from) {
        IDependencyModel model;
        ResourceArtifact documentArtifact;
        IFile file;
        if (this.getDocument() != null && (file = this.getDocument().getFile()) != null && file.isAccessible() && (documentArtifact = (model = DependencyModelManager.getInstance().getModel()).ensureResourceArtifact((IResource)file)) != null) {
            HashSet<ControlFlowCaseOutcomeArtifact> navigationCases = new HashSet<ControlFlowCaseOutcomeArtifact>();
            Collection viewArtifacts = model.queryArtifactsByTypes(Collections.singleton("adf-view-activity"), file.getProject());
            if (!viewArtifacts.isEmpty()) {
                viewArtifacts = new ArrayList(viewArtifacts);
                Iterator i = viewArtifacts.iterator();
                block0: while (i.hasNext()) {
                    IArtifact viewArtifact = (IArtifact)i.next();
                    for (IArtifactReference reference : viewArtifact.getReferences()) {
                        if (reference.refersTo((IArtifact)documentArtifact)) continue block0;
                    }
                    i.remove();
                }
                if (!viewArtifacts.isEmpty()) {
                    if (from) {
                        HashSet<Object> taskFlowResources = new HashSet<Object>(viewArtifacts.size());
                        Iterator i2 = viewArtifacts.iterator();
                        while (i2.hasNext()) {
                            IArtifact viewArtifact = (IArtifact)i2.next();
                            IResource resource = this.getResource(viewArtifact);
                            if (resource instanceof IFile) {
                                taskFlowResources.add(resource);
                                continue;
                            }
                            i2.remove();
                        }
                        if (!viewArtifacts.isEmpty()) {
                            Set ruleArtifacts = model.queryArtifactsByTypes(Collections.singleton("adf-control-flow-rule"), file.getProject());
                            for (IArtifact ruleArtifact : ruleArtifacts) {
                                boolean wildcard;
                                IResource ruleResource = this.getResource(ruleArtifact);
                                if (!taskFlowResources.contains(ruleResource)) continue;
                                String ruleName = ruleArtifact.getName();
                                if (ruleName == null || ruleName.length() == 0 || ruleName.equals("*")) {
                                    navigationCases.addAll(((ControlFlowRuleArtifact)ruleArtifact).getNavigationOutcomes());
                                    continue;
                                }
                                boolean bl = wildcard = ruleName.charAt(ruleName.length() - 1) == '*';
                                if (wildcard) {
                                    ruleName = ruleName.substring(0, ruleName.length() - 1);
                                }
                                for (IArtifact viewArtifact : viewArtifacts) {
                                    String viewName = viewArtifact.getName();
                                    if (!(viewName != null && wildcard ? viewName.startsWith(ruleName) : viewName.equals(ruleName)) || !viewArtifact.getLocation().getResource().equals((Object)ruleResource)) continue;
                                    navigationCases.addAll(((ControlFlowRuleArtifact)ruleArtifact).getNavigationOutcomes());
                                }
                            }
                        }
                    } else {
                        Set caseArtifacts = model.queryArtifactsByTypes(Collections.singleton("adf-taskflow-from-outcome"), file.getProject());
                        for (IArtifact caseArtifact : caseArtifacts) {
                            for (IArtifactReference reference : caseArtifact.getReferences()) {
                                IArtifact targetArtifact = reference.getTargetArtifact();
                                if (!viewArtifacts.contains(targetArtifact)) continue;
                                navigationCases.add((ControlFlowCaseOutcomeArtifact)caseArtifact);
                            }
                        }
                    }
                }
            }
            return navigationCases;
        }
        return new HashSet(0);
    }

    private IResource getResource(IArtifact artifact) {
        ResourceLocation resourceLocation;
        if (artifact != null && (resourceLocation = artifact.getLocation()) != null) {
            return resourceLocation.getResource();
        }
        return null;
    }

    public IArtifact getToArtifact(IArtifact navigationCase) {
        if (navigationCase instanceof ControlFlowCaseOutcomeArtifact) {
            Set references = navigationCase.getReferences();
            for (IArtifactReference reference : references) {
                IArtifact targetArtifact;
                if (!(reference instanceof AdfTaskflowActivityIDArtifactReference) || (targetArtifact = reference.getTargetArtifact()) == null) continue;
                return targetArtifact;
            }
        }
        return null;
    }

    public IResource getToArtifactResource(IArtifact navigationCase, IArtifact toArtifact) {
        if (navigationCase instanceof ControlFlowCaseOutcomeArtifact) {
            if (toArtifact instanceof ResourceArtifact) {
                IResource[] resources = ((ResourceArtifact)toArtifact).getAffectedResources();
                if (resources.length == 1) {
                    return resources[0];
                }
            } else if (toArtifact != null) {
                for (IArtifactReference reference : toArtifact.getReferences()) {
                    if (!(reference instanceof ResourceReference)) continue;
                    return ((ResourceReference)reference).getRefereeResource();
                }
            }
        }
        return null;
    }
}

