/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.validation;

import java.util.List;
import oracle.eclipse.tools.application.common.services.document.validator.AbstractValidate;
import oracle.eclipse.tools.common.services.catalogue.message.CataloguedMessage;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidateInvalidHTMLTag
extends AbstractValidate {
    private String[] _tags;
    private String _nameSpace;
    private static final String DIRECTIVE_TAGLIB = "jsp:directive.taglib";
    private static final String NAMESPACE_URI_ATTR = "uri";
    private static final String PREFIX_ATTR = "prefix";
    private static final String HTTP_JAVA_SUN_COM_JSP_PAGE = "http://java.sun.com/JSP/Page";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_JSP = "xmlns:jsp";

    public ValidateInvalidHTMLTag(ProblemCatalogueIndex index, String nameSpace, String ... tags) {
        super(index);
        this._nameSpace = nameSpace;
        this._tags = tags;
    }

    public boolean validate(IFile targetFile, Document document, List<CataloguedMessage> reporter) {
        String prefix;
        boolean isXMLJSP = this.isXMLJSP(document);
        boolean hasHTMLFeature = this.hasHTMLFeature(document);
        if (!isXMLJSP && hasHTMLFeature && (prefix = this.findPrefix(document)) != null) {
            String[] stringArray = this._tags;
            int n = this._tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                NodeList list = document.getElementsByTagName(String.valueOf(prefix) + ":" + tag);
                if (list != null && list.getLength() > 0) {
                    CataloguedMessage message = this.createMessage(targetFile);
                    message.setLineNo(1);
                    reporter.add(message);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean find(NodeList children, String prefix, String tag) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element target = (Element)child;
                    if (!tag.equals(target.getLocalName())) break;
                    if (prefix == null) {
                        return false;
                    }
                    prefix.equals(target.getPrefix());
                    break;
                }
            }
            ++i;
        }
        return true;
    }

    private String findPrefix(Document document) {
        NodeList list = document.getElementsByTagName(DIRECTIVE_TAGLIB);
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element target = (Element)child;
                    if (!this._nameSpace.equals(target.getAttribute(NAMESPACE_URI_ATTR))) break;
                    return target.getAttribute(PREFIX_ATTR);
                }
            }
            ++i;
        }
        return null;
    }

    private boolean hasHTMLFeature(Document document) {
        if (document instanceof IDOMDocument) {
            IDOMDocument domDocument = (IDOMDocument)document;
            DocumentTypeAdapter adapter = (DocumentTypeAdapter)domDocument.getAdapterFor(DocumentTypeAdapter.class);
            if (adapter == null) {
                return false;
            }
            return adapter.hasFeature("HTML");
        }
        return false;
    }

    private boolean isXMLJSP(Document document) {
        Element root = document.getDocumentElement();
        return root != null && (root.hasAttribute(XMLNS_JSP) || HTTP_JAVA_SUN_COM_JSP_PAGE.equals(root.getAttribute(XMLNS)));
    }
}

