/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.FolderResourceProxyVisitor;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.JSPPageMoveRefactoringHelper;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class JSPPageRenameFolderRefactoringParticipant
extends RenameParticipant {
    private List<IFile> jspFiles = new ArrayList<IFile>();
    private JSPPageMoveRefactoringHelper jspMoveHelper = new JSPPageMoveRefactoringHelper();

    protected boolean initialize(Object element) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            String newName = this.getArguments().getNewName();
            FolderResourceProxyVisitor.JSPFolderResourceProxyVisitor folderVisitor = new FolderResourceProxyVisitor.JSPFolderResourceProxyVisitor(this.jspFiles);
            folderVisitor.visitFolder(folder);
            IFolder newContainer = folder.getParent().getFolder((IPath)new Path(newName));
            JSPPageRenameFolderRefactoringParticipant.determinePageDefFiles(this.jspFiles, (IContainer)newContainer, folder, false, this.jspMoveHelper);
            return this.jspMoveHelper.hasPageDefFile();
        }
        return false;
    }

    public String getName() {
        return Messages.JSPPageRenameFolderRefactoringParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return this.jspMoveHelper.checkConditions(pm, context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.jspMoveHelper.createChange(pm, (RefactoringParticipant)this);
    }

    static void determinePageDefFiles(List<IFile> jspFiles, IContainer destination, IFolder oldFolder, boolean move, JSPPageMoveRefactoringHelper jspMoveHelper) {
        for (IFile jspFile : jspFiles) {
            IPath relativePath = jspFile.getFullPath().makeRelativeTo(move ? oldFolder.getParent().getFullPath() : oldFolder.getFullPath());
            IContainer newContainerForJsp = destination;
            if (relativePath.segmentCount() > 1) {
                newContainerForJsp = destination.getFolder(relativePath.removeLastSegments(1));
            }
            jspMoveHelper.addElement(jspFile, newContainerForJsp);
        }
    }
}

