/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.JSPPageRenameRefactoringParticipant;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.adf.view.model.ADFAppFileInfo;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPPageMoveRefactoringHelper {
    private Map<IFile, IFile> jspFileToPageDefFileMap;
    private IFile cpxFile;
    private Map<IFile, IContainer> jspToTargetContainerMap;
    private List<ReplaceEdit> cpxFileEdits = null;
    private Map<IFile, ReplaceEdit> pageDefEditsMap = null;
    private Map<IFile, IContainer> newPageDefContainerMap = null;

    boolean addElement(IFile jspFile, IContainer destination) {
        if (this.determinePageDefFile(jspFile)) {
            if (this.jspToTargetContainerMap == null) {
                this.jspToTargetContainerMap = new HashMap<IFile, IContainer>();
            }
            this.jspToTargetContainerMap.put(jspFile, destination);
            return true;
        }
        return false;
    }

    boolean hasPageDefFile() {
        return this.jspFileToPageDefFileMap != null && this.jspFileToPageDefFileMap.keySet().size() > 0;
    }

    RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.jspFileToPageDefFileMap == null) {
            return null;
        }
        Set<IFile> jspFiles = this.jspFileToPageDefFileMap.keySet();
        if (jspFiles == null) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)jspFiles.size());
        sm.subTask(Messages.JSPPageMoveRefactoringParticipant_checkConditionsSubTaskName);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        IProject project = null;
        for (IFile jspFile : jspFiles) {
            if (project == null) {
                project = jspFile.getProject();
                this.cpxFile = ADFUtil.getApplicationForViewFile(jspFile);
                this.cpxFileEdits = new ArrayList<ReplaceEdit>();
                this.pageDefEditsMap = new HashMap<IFile, ReplaceEdit>();
                this.newPageDefContainerMap = new HashMap<IFile, IContainer>();
            } else if (project != jspFile.getProject()) {
                return RefactoringStatus.createErrorStatus((String)Messages.JSPPageMoveHelper_jspFilesShouldBeFromSameProj);
            }
            IContainer targetContainer = this.jspToTargetContainerMap.get(jspFile);
            if (!JSPPageMoveRefactoringHelper.isUnderWebContent(targetContainer)) {
                return RefactoringStatus.createErrorStatus((String)Messages.JSPPageMoveRefactoringParticipant_destinationNotUnderWebcontentError);
            }
            IFile pageDefFile = this.jspFileToPageDefFileMap.get(jspFile);
            String newPageDefPath = null;
            if (this.cpxFile != null) {
                newPageDefPath = JSPPageMoveRefactoringHelper.getPageDefFilePathFromPageFile(jspFile, targetContainer);
                if (newPageDefPath != null) {
                    IFile file = (IFile)jspFile.getProject().findMember(newPageDefPath);
                    if (file != null && file.exists()) {
                        newPageDefPath = JSPPageRenameRefactoringParticipant.getUniquePageDefName(newPageDefPath, pageDefFile.getParent());
                        file = (IFile)jspFile.getProject().findMember(newPageDefPath);
                        if (file != null && file.exists()) {
                            return RefactoringStatus.createErrorStatus((String)(String.valueOf(Messages.JSPPageMoveRefactoringParticipant_pageDefFileAlreadyExistsError1) + file.getName() + Messages.JSPPageMoveRefactoringParticipant_pageDefFileAlreadyExistsError2));
                        }
                    }
                    IFolder newPageDefContainer = project.getFolder(new Path(newPageDefPath).removeLastSegments(1));
                    this.newPageDefContainerMap.put(pageDefFile, (IContainer)newPageDefContainer);
                }
            } else {
                return RefactoringStatus.createErrorStatus((String)Messages.JSPPageMoveRefactoringParticipant_projectMissingADFMExtension);
            }
            deltaFactory.change(pageDefFile);
            try {
                this.determineReplaceEdits(jspFile, pageDefFile, targetContainer);
            }
            catch (Exception e) {
                ADFPlugin.logError(Messages.JSPPageMoveRefactoringParticipant_errorDetermingReplaceEdits, e);
                return RefactoringStatus.createErrorStatus((String)Messages.JSPPageMoveRefactoringParticipant_errorDetermingReplaceEdits);
            }
            sm.worked(1);
        }
        if (this.cpxFileEdits != null && this.cpxFileEdits.size() > 0) {
            deltaFactory.change(this.cpxFile);
        }
        return new RefactoringStatus();
    }

    Change createChange(IProgressMonitor pm, RefactoringParticipant refactoringParticipant) throws OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.JSPPageMoveRefactoringParticipant_compositeChangeName);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        if (this.cpxFile != null) {
            this.addAppFileReplaceChangeType(compositeChange, refactoringParticipant);
        }
        this.addPageDefFileReplaceChangeType(compositeChange, refactoringParticipant);
        sm.worked(1);
        if (this.newPageDefContainerMap == null) {
            return null;
        }
        Set<IFile> pageDefFiles = this.newPageDefContainerMap.keySet();
        HashSet<IContainer> containers = new HashSet<IContainer>();
        for (IFile pageDefFile : pageDefFiles) {
            IContainer newPageDefContainer = this.newPageDefContainerMap.get(pageDefFile);
            if (!containers.contains(newPageDefContainer)) {
                containers.add(newPageDefContainer);
                if (!newPageDefContainer.exists()) {
                    compositeChange.add((Change)new PageDefFolderCreateResourceChange(newPageDefContainer));
                }
            }
            compositeChange.add((Change)new PageDefMoveResourceChange((IResource)pageDefFile, newPageDefContainer));
        }
        sm.worked(1);
        return compositeChange;
    }

    private void addAppFileReplaceChangeType(CompositeChange compositeChange, RefactoringParticipant refactoringParticipant) {
        TextChange textChange = refactoringParticipant.getTextChange((Object)this.cpxFile);
        if (textChange == null) {
            textChange = new TextFileChange(Messages.JSPPageMoveRefactoringParticipant_cpxFileChangesName, this.cpxFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        if (this.cpxFileEdits != null) {
            for (ReplaceEdit replaceEdit : this.cpxFileEdits) {
                textChange.addEdit((TextEdit)replaceEdit);
            }
        }
    }

    private void addPageDefFileReplaceChangeType(CompositeChange compositeChange, RefactoringParticipant refactoringParticipant) {
        Set<IFile> pageDefFiles = this.pageDefEditsMap.keySet();
        if (pageDefFiles == null) {
            return;
        }
        for (IFile pageDefFile : pageDefFiles) {
            ReplaceEdit pageDefEdit = this.pageDefEditsMap.get(pageDefFile);
            TextChange textChange = refactoringParticipant.getTextChange((Object)pageDefFile);
            if (textChange == null) {
                textChange = new TextFileChange(Messages.JSPPageMoveRefactoringParticipant_pageDefFileNameChange, pageDefFile);
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                textChange.setEdit((TextEdit)multiTextEdit);
                compositeChange.add((Change)textChange);
            }
            if (pageDefEdit == null) continue;
            textChange.addEdit((TextEdit)pageDefEdit);
        }
    }

    private void determineReplaceEdits(IFile jspFile, IFile pageDefFile, IContainer targetContainer) throws CoreException, IOException, ADFAppFileInfo.InvalidADFAppFileException {
        int index;
        String destContainerWebContentRelativePath = ADFUtil.getResourcePathRelativeToWebContent((IResource)targetContainer);
        IPath pathToNewJSPFileRelativeToWebContent = new Path(destContainerWebContentRelativePath).append(jspFile.getName());
        String pageDefPath = ADFUtil.getPageDefPathFromPagePath(pathToNewJSPFileRelativeToWebContent.toString());
        String newPagePathStr = pathToNewJSPFileRelativeToWebContent.toString();
        String string = newPagePathStr = !newPagePathStr.startsWith("/") ? "/" + newPagePathStr : newPagePathStr;
        if (this.cpxFile != null) {
            IPath newjspProjectRelativePath = targetContainer.getProjectRelativePath().append(jspFile.getName());
            String newUsageId = ADFUtil.generateUniqueUsageId(this.cpxFile, newjspProjectRelativePath);
            JSPPageMoveRefactoringHelper.determineCPXFileReplaceEdits(jspFile, this.cpxFileEdits, newUsageId, pageDefPath);
        }
        String pageDefPkg = (index = pageDefPath.lastIndexOf(46)) != -1 ? pageDefPath.substring(0, index) : "";
        this.determinePageDefReplaceEdits(pageDefPkg, pageDefFile);
    }

    private void determinePageDefReplaceEdits(String pageDefPkg, IFile pageDefFile) throws CoreException, IOException {
        IStructuredModel sm = null;
        try {
            try {
                sm = StructuredModelManager.getModelManager().getModelForRead(pageDefFile);
                IDOMModel domModel = (IDOMModel)sm;
                IDOMElement element = (IDOMElement)domModel.getDocument().getDocumentElement();
                IDOMAttr pkgAttr = (IDOMAttr)element.getAttributeNode("Package");
                if (pkgAttr != null) {
                    this.pageDefEditsMap.put(pageDefFile, new ReplaceEdit(pkgAttr.getValueRegionStartOffset() + 1, pkgAttr.getValue().length(), pageDefPkg));
                }
            }
            catch (CoreException ce) {
                ADFPlugin.logError(Messages.JSPPageMoveRefactoringParticipant_errorProcessingPageDef, ce);
                throw ce;
            }
            catch (IOException ioe) {
                ADFPlugin.logError(Messages.JSPPageMoveRefactoringParticipant_errorProcessingPageDef, ioe);
                throw ioe;
            }
        }
        finally {
            sm.releaseFromRead();
        }
    }

    private boolean determinePageDefFile(IFile jspFile) {
        IFile pageDefFile = ADFUtil.getPageDefFileForViewFile(jspFile);
        if (pageDefFile != null && pageDefFile.exists()) {
            if (this.jspFileToPageDefFileMap == null) {
                this.jspFileToPageDefFileMap = new HashMap<IFile, IFile>();
            }
            this.jspFileToPageDefFileMap.put(jspFile, pageDefFile);
            return true;
        }
        return false;
    }

    static void determineCPXFileReplaceEdits(IFile jspFile, List<ReplaceEdit> replaceEdits, String newUsageId, String pageDefPath) throws CoreException, IOException, ADFAppFileInfo.InvalidADFAppFileException {
        try {
            ADFAppFileInfo appFileInfo = new ADFAppFileInfo(jspFile);
            ADFAppFileInfo.MatchingPageSourceInformation pageSourceInfo = appFileInfo.getSourceInfoForMatchingPage();
            if (pageSourceInfo != null) {
                ADFAppFileInfo.AttrInfo usageIdAttrInfo;
                ADFAppFileInfo.PageMapPageInfo pageMapInfo = pageSourceInfo.getPageMapPageInfo();
                if (pageMapInfo != null && (usageIdAttrInfo = pageMapInfo.getUsageIdAttrInfo()) != null) {
                    String usageId = usageIdAttrInfo.getAttrValue();
                    replaceEdits.add(new ReplaceEdit(usageIdAttrInfo.getValueStartOffset(), usageId.length(), newUsageId));
                }
                if (newUsageId == null) {
                    return;
                }
                ADFAppFileInfo.PageDefnUsagePageInfo pageDefnUsagePageInfo = pageSourceInfo.getPageDefnUsagePageInfo();
                if (pageDefnUsagePageInfo != null) {
                    ADFAppFileInfo.AttrInfo pathAttrInfo;
                    ADFAppFileInfo.AttrInfo idAttrInfo = pageDefnUsagePageInfo.getIdAttrInfo();
                    if (idAttrInfo != null) {
                        String id = idAttrInfo.getAttrValue();
                        replaceEdits.add(new ReplaceEdit(idAttrInfo.getValueStartOffset(), id.length(), newUsageId));
                    }
                    if ((pathAttrInfo = pageDefnUsagePageInfo.getPathAttrInfo()) != null) {
                        String path = pathAttrInfo.getAttrValue();
                        replaceEdits.add(new ReplaceEdit(pathAttrInfo.getValueStartOffset(), path.length(), pageDefPath));
                    }
                }
            }
        }
        catch (IOException ioe) {
            ADFPlugin.logError(Messages.JSPPageRenameRefactoringParticipant_errorProcessingCPXFile, ioe);
            throw ioe;
        }
        catch (CoreException ce) {
            ADFPlugin.logError(Messages.JSPPageRenameRefactoringParticipant_errorProcessingCPXFile, ce);
            throw ce;
        }
        catch (ADFAppFileInfo.InvalidADFAppFileException iafe) {
            ADFPlugin.logError(Messages.JSPPageRenameRefactoringParticipant_errorProcessingCPXFile, iafe);
            throw iafe;
        }
    }

    private static String getPageDefFilePathFromPageFile(IFile jspFile, IContainer destContainer) {
        String newContainerRelativePath = ADFUtil.getResourcePathRelativeToWebContent((IResource)destContainer);
        String newViewPath = new Path(newContainerRelativePath).append(jspFile.getName()).toString();
        String pageDefPath = ADFUtil.getPageDefPathFromPagePath(newViewPath);
        return ADFUtil.getPageDefLocationFromPageDefDotQualifiedPath(pageDefPath);
    }

    private static boolean isUnderWebContent(IContainer container) {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)container.getProject());
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder().getFullPath().isPrefixOf(container.getFullPath());
        }
        return false;
    }

    private static class PageDefFolderCreateResourceChange
    extends ResourceChange {
        private IContainer target;
        private IContainer existingParentContainer;

        PageDefFolderCreateResourceChange(IContainer target) {
            this.target = target;
            if (!target.exists()) {
                this.existingParentContainer = this.getExistingParentContainer(target);
            }
        }

        protected IResource getModifiedResource() {
            return this.existingParentContainer;
        }

        public String getName() {
            return String.valueOf(Messages.JSPPageMoveRefactoringParticipant_createFolderChangeName) + this.target.getFullPath() + "'";
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (this.target.exists()) {
                return null;
            }
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            pm.beginTask("", 1);
            pm.setTaskName(Messages.JSPPageMoveRefactoringParticipant_createNewFolderTaskName);
            try {
                FolderUtil.ensureFolder((IFolder)((IFolder)this.target), (IProgressMonitor)pm);
            }
            finally {
                pm.done();
            }
            return null;
        }

        private IContainer getExistingParentContainer(IContainer container) {
            IContainer parent = container.getParent();
            if (parent.exists()) {
                return parent;
            }
            return this.getExistingParentContainer(parent);
        }
    }

    private static class PageDefMoveResourceChange
    extends MoveResourceChange {
        private final IResource source;
        private final IContainer target;

        public PageDefMoveResourceChange(IResource source, IContainer target) {
            super(source, target);
            this.source = source;
            this.target = target;
        }

        public String getName() {
            return Messages.format(RefactoringCoreMessages.MoveResourceChange_name, new String[]{BasicElementLabels.getPathLabel((IPath)this.source.getFullPath(), (boolean)false), BasicElementLabels.getPathLabel((IPath)this.target.getFullPath(), (boolean)false)});
        }
    }
}

