/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.adf.view.model.ADFAppFileInfo;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class JSPPageDeleteRefactoringParticipant
extends DeleteParticipant
implements ISharableParticipant {
    private Map<IFile, IFile> jspToPageDefMap = null;
    private Map<IFile, List<DeleteEdit>> cpxFileToDeleteEditMap = null;
    protected List<IFile> jspFiles = null;

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IFile && JSPUtil.isJSPContentType((IFile)((IFile)element))) {
            if (this.jspFiles == null) {
                this.jspFiles = new ArrayList<IFile>();
            }
            this.jspFiles.add((IFile)element);
        }
    }

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return this.jspFiles != null && this.jspFiles.size() > 0;
    }

    public String getName() {
        return Messages.JSPPageDeleteRefactoringParticipant_jspFileDeleteRefactoringParticipant;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.jspToPageDefMap == null) {
            this.jspToPageDefMap = new HashMap<IFile, IFile>();
        }
        if (this.cpxFileToDeleteEditMap == null) {
            this.cpxFileToDeleteEditMap = new HashMap<IFile, List<DeleteEdit>>();
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)(this.jspFiles.size() * 2));
        sm.subTask(Messages.JSPPageDeleteRefactoringParticipant_jspReferencesCheck);
        for (IFile jspFile : this.jspFiles) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFile pageDefFile = ADFUtil.getPageDefFileForViewFile(jspFile);
            if (pageDefFile != null) {
                this.jspToPageDefMap.put(jspFile, pageDefFile);
            }
            sm.worked(1);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        HashSet<IFile> pageDefDeletes = new HashSet<IFile>();
        for (IFile jspFile : this.jspToPageDefMap.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFile pageDefFile = this.jspToPageDefMap.get(jspFile);
            if (!pageDefDeletes.contains(pageDefFile)) {
                deltaFactory.delete((IResource)pageDefFile);
                pageDefDeletes.add(pageDefFile);
            }
            try {
                JSPPageDeleteRefactoringParticipant.computeADFAppFileDeleteEdits(jspFile, this.cpxFileToDeleteEditMap);
            }
            catch (Exception e) {
                ADFPlugin.logError(Messages.JSPPageDeleteRefactoringParticipant_errorComputingCPXFileEdits, e);
                return RefactoringStatus.createFatalErrorStatus((String)Messages.JSPPageDeleteRefactoringParticipant_errorComputingCPXFileEdits);
            }
            sm.worked(1);
        }
        for (IFile cpxFile : this.cpxFileToDeleteEditMap.keySet()) {
            if (cpxFile == null || !cpxFile.exists()) continue;
            deltaFactory.change(cpxFile);
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.JSPPageDeleteRefactoringParticipant_compositeChangeText);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        sm.subTask(Messages.JSPPageDeleteRefactoringParticipant_deleteReferencesText);
        HashSet<IFile> pageDefDeletes = new HashSet<IFile>();
        for (IFile pageDefFile : this.jspToPageDefMap.values()) {
            if (pageDefDeletes.contains(pageDefFile)) continue;
            compositeChange.add((Change)new DeleteResourceChange(pageDefFile.getFullPath(), true));
            pageDefDeletes.add(pageDefFile);
        }
        sm.worked(1);
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile cpxFile : this.cpxFileToDeleteEditMap.keySet()) {
            JSPPageDeleteRefactoringParticipant.addADFAppFileDeleteChangeType(cpxFile, compositeChange, (RefactoringParticipant)this, this.cpxFileToDeleteEditMap);
        }
        sm.worked(1);
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    static void addADFAppFileDeleteChangeType(IFile cpxFile, CompositeChange compositeChange, RefactoringParticipant participant, Map<IFile, List<DeleteEdit>> cpxFileToDeleteEditMap) {
        TextChange textChange = participant.getTextChange((Object)cpxFile);
        if (textChange == null) {
            textChange = new TextFileChange(Messages.JSPPageDeleteRefactoringParticipant_deleteReferenecesFromAppFile, cpxFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        List<DeleteEdit> deleteEdits = cpxFileToDeleteEditMap.get(cpxFile);
        for (TextEdit textEdit : deleteEdits) {
            textChange.addEdit(textEdit);
        }
    }

    static void computeADFAppFileDeleteEdits(IFile jspFile, Map<IFile, List<DeleteEdit>> cpxFileToDeleteEditMap) throws IOException, ADFAppFileInfo.InvalidADFAppFileException, CoreException {
        ADFAppFileInfo appFileInfo = new ADFAppFileInfo(jspFile);
        ADFAppFileInfo.MatchingPageSourceInformation pageSourceInfo = appFileInfo.getSourceInfoForMatchingPage();
        if (pageSourceInfo != null) {
            ADFAppFileInfo.PageDefnUsagePageInfo pageDefnUsagePageInfo;
            ADFAppFileInfo.PageMapPageInfo pageMapInfo;
            IFile cpxFile = appFileInfo.getADFAppFile();
            List<DeleteEdit> deleteEdits = cpxFileToDeleteEditMap.get(cpxFile);
            if (deleteEdits == null) {
                deleteEdits = new ArrayList<DeleteEdit>();
                cpxFileToDeleteEditMap.put(cpxFile, deleteEdits);
            }
            if ((pageMapInfo = pageSourceInfo.getPageMapPageInfo()) != null) {
                JSPPageDeleteRefactoringParticipant.addDeleteEditIntoList(deleteEdits, new DeleteEdit(pageMapInfo.getStartOffset(), pageMapInfo.getEndOffset() - pageMapInfo.getStartOffset()));
            }
            if ((pageDefnUsagePageInfo = pageSourceInfo.getPageDefnUsagePageInfo()) != null) {
                JSPPageDeleteRefactoringParticipant.addDeleteEditIntoList(deleteEdits, new DeleteEdit(pageDefnUsagePageInfo.getStartOffset(), pageDefnUsagePageInfo.getEndOffset() - pageDefnUsagePageInfo.getStartOffset()));
            }
        }
    }

    private static void addDeleteEditIntoList(List<DeleteEdit> deleteEditList, DeleteEdit deleteEdit) {
        if (deleteEdit == null) {
            return;
        }
        boolean found = false;
        for (DeleteEdit de : deleteEditList) {
            if (de.getOffset() != deleteEdit.getOffset() || de.getLength() != deleteEdit.getLength()) continue;
            found = true;
            break;
        }
        if (!found) {
            deleteEditList.add(deleteEdit);
        }
    }
}

