/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.emftools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.JsptagbasePackage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateEcoreFromMetadata {
    private static final String ENTITY_NODE_NAME = "entity";
    private static final String TRAIT_NODE_NAME = "trait";
    private static final String ITEM_NODE_NAME = "item";
    private static final String TRAIT_VALUE_NODE_NAME = "value";
    private static final String ENTITY_TYPE_ATTR_NAME = "type";
    private static final String ENTITY_ID_ATTR_NAME = "id";
    private static final String TRAIT_ID_ATTR_NAME = "id";
    private static final String ENTITY_TYPE_ATTR_TAG_VALUE = "tag";
    private static final String UPDATE_ATTR_TYPES = "-updateAttrTypes";
    private static final String UPDATE_ALL_SUBTYPES = "-updateAllSubtypes";
    private static final String UPDATE_ACTION_SUBTYPE = "-updateActionSubtype";
    private static final String UPDATE_CONVERTER_SUBTYPE = "-updateConverterSubtype";
    private static final String UPDATE_STYLE_SUBTYPE = "-updateStyleSubtype";
    private static final String UPDATE_STYLE_CLASS_SUBTYPE = "-updateStyleClassSubtype";
    private static final String UPDATE_BOOLEAN_DEFAULTS = "-updateBooleanDefaults";
    private static final String UPDATE_TEXT_DEFAULTS = "-updateTextDefaults";
    private static final String UPDATE_ENUMS = "-updateEnums";
    private static final String UPDATE_ENUMS_FOR_DIALOGS = "-updateEnumsForDialogs";
    private static final String UPDATE_BOOLEAN_TO_B_EL = "-updateBooleanToBooleanPlusEL";
    private static final String ATTRIBUTE_VALUE_RUNTIME_TYPE = "attribute-value-runtime-type";
    private static final String VALID_VALUES = "valid-values";
    private static final String DEFAULT_VALUE = "default-value";
    private static final String STRING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.StringType";
    private static final String BOOLEAN_TYPE = "org.eclipse.jst.jsf.core.attributevalues.BooleanType";
    private static final String INTEGER_TYPE = "org.eclipse.jst.jsf.core.attributevalues.IntegerType";
    private static final String LONG_TYPE = "org.eclipse.jst.jsf.core.attributevalues.LongType";
    private static final String DOUBLE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.DoubleType";
    private static final String COMPONENT_ID_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ComponentIDType";
    private static final String OBJECT_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ObjectType";
    private static final String VALUE_BINDING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ValueBindingType";
    private static final String METHOD_BINDING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.MethodBindingType";
    private static final String COMPONENT_BINDING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ComponentBindingType";
    private static final String ACTION_TYPE = "oracle.eclipse.tools.webtier.adf.attributevalues.ActionType";
    private static final String CSS_CLASS_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CSSClassType";
    private static final String CSS_STYLE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CSSStyleType";
    private static final String FACES_CONFIG_CONVERTER_ID_TYPE = "org.eclipse.jst.jsf.core.attributevalues.FacesConfigConverterIDType";
    private static final String ADF_ACTION_SUBTYPE = "adf-action";
    private static final String ADF_STYLE_CLASS_SUBTYPE = "adf-style-class";
    private static final String STYLE_SUBTYPE = "style";
    private static final String JSF_CONVERTER_ID_SUBTYPE = "jsf-converter-id";
    private static final String TLEI_URI = "http://oracle.com/eclipse/tools/metadata/tlei";
    private static final String SUBTYPE_KEY = "subType";
    private static final Map<String, EClassifier> TYPE_MAP = new HashMap<String, EClassifier>();
    private final Document _metadataDom;
    private EPackage _ePackage;
    private final Resource _resource;
    private final Set<String> _options;

    static {
        TYPE_MAP.put(BOOLEAN_TYPE, (EClassifier)EcorePackage.Literals.EBOOLEAN_OBJECT);
        TYPE_MAP.put(INTEGER_TYPE, (EClassifier)JsptagbasePackage.Literals.OPTIONAL_INTEGER);
        TYPE_MAP.put(LONG_TYPE, (EClassifier)JsptagbasePackage.Literals.OPTIONAL_LONG);
        TYPE_MAP.put(DOUBLE_TYPE, (EClassifier)JsptagbasePackage.Literals.OPTIONAL_DOUBLE);
        TYPE_MAP.put(STRING_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(COMPONENT_ID_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(OBJECT_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(FACES_CONFIG_CONVERTER_ID_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(ACTION_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(CSS_STYLE_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(CSS_CLASS_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(VALUE_BINDING_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(METHOD_BINDING_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(COMPONENT_BINDING_TYPE, (EClassifier)XMLTypePackage.Literals.STRING);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            UpdateEcoreFromMetadata.error(CommandLineError.NOT_ENOUGH_ARGUMENTS, String.format("Usage: %s <ecoreSrcFile> <ecoreDestFile> <metadataFile> <options>\n       <options>: <none> -updateAttrTypes -updateEnums", UpdateEcoreFromMetadata.class.getSimpleName()));
        }
        String ecoreSrcFileName = args[0];
        String ecoreDestFileName = args[1];
        String metadataFileName = args[2];
        HashSet<String> options = new HashSet<String>();
        int i = 3;
        while (i < args.length) {
            options.add(args[i]);
            ++i;
        }
        for (String option : options) {
            System.out.println("option: " + option);
        }
        try {
            new UpdateEcoreFromMetadata(ecoreSrcFileName, UpdateEcoreFromMetadata.getMetadata(metadataFileName), options).updateModel(ecoreDestFileName);
        }
        catch (FileNotFoundException e) {
            UpdateEcoreFromMetadata.error(CommandLineError.FILE_NOT_FOUND, e.getLocalizedMessage());
        }
        catch (IOException e) {
            UpdateEcoreFromMetadata.error(CommandLineError.GENERAL_IO_FAILURE, e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            UpdateEcoreFromMetadata.error(CommandLineError.DOM_PARSER_ERROR, e.getLocalizedMessage());
        }
        catch (SAXException e) {
            UpdateEcoreFromMetadata.error(CommandLineError.DOM_PARSER_ERROR, e.getLocalizedMessage());
        }
    }

    private static void error(CommandLineError errorCode, String message) {
        System.err.println(errorCode.toString());
        if (message != null) {
            System.err.println(message);
        }
        System.exit(errorCode.getCode());
    }

    private static Document getMetadata(String metadataFileName) throws ParserConfigurationException, SAXException, IOException {
        File metadataFile = new File(metadataFileName);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document metadataDom = docBuilder.parse(metadataFile);
        return metadataDom;
    }

    public UpdateEcoreFromMetadata(String ecoreSrcFileName, Document metadataDom, Set<String> options) throws IOException {
        this._metadataDom = metadataDom;
        this._options = options;
        ResourceSetImpl resSet = new ResourceSetImpl();
        this.initResourceSet((ResourceSet)resSet);
        URI uri = URI.createFileURI((String)ecoreSrcFileName);
        this._resource = resSet.createResource(uri);
        this._resource.load(Collections.EMPTY_MAP);
        if (!this._resource.getContents().isEmpty()) {
            this._ePackage = (EPackage)this._resource.getContents().get(0);
        }
    }

    private void initResourceSet(ResourceSet resourceSet) {
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
        resourceSet.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
    }

    protected void updateModel(String ecoreDestFileName) throws IOException {
        try (PrintStream out = null;){
            out = new PrintStream(ecoreDestFileName);
            if (this._options.contains(UPDATE_ATTR_TYPES)) {
                this.updateTypes();
            }
            if (this._options.contains(UPDATE_ENUMS)) {
                this.updateEnums();
            }
            if (this._options.contains(UPDATE_ENUMS_FOR_DIALOGS)) {
                this.updateEnumsForDialogs();
            }
            if (this._options.contains(UPDATE_ALL_SUBTYPES) || this._options.contains(UPDATE_ACTION_SUBTYPE) || this._options.contains(UPDATE_CONVERTER_SUBTYPE) || this._options.contains(UPDATE_STYLE_SUBTYPE) || this._options.contains(UPDATE_STYLE_CLASS_SUBTYPE)) {
                this.updateSubtypes();
            }
            if (this._options.contains(UPDATE_BOOLEAN_DEFAULTS)) {
                this.updateBooleanDefaults();
            }
            if (this._options.contains(UPDATE_TEXT_DEFAULTS)) {
                this.updateTextDefaults();
            }
            if (this._options.contains(UPDATE_BOOLEAN_TO_B_EL)) {
                this.updateBooleanToBooleanPlusEL();
            }
            this._resource.save((OutputStream)out, Collections.EMPTY_MAP);
        }
    }

    protected void updateSubtypes() {
        if (this._options.contains(UPDATE_ALL_SUBTYPES)) {
            this.updateSubtype(ACTION_TYPE, ADF_ACTION_SUBTYPE);
            this.updateSubtype(FACES_CONFIG_CONVERTER_ID_TYPE, JSF_CONVERTER_ID_SUBTYPE);
            this.updateSubtype(CSS_STYLE_TYPE, STYLE_SUBTYPE);
            this.updateSubtype(CSS_CLASS_TYPE, ADF_STYLE_CLASS_SUBTYPE);
        } else {
            if (this._options.contains(UPDATE_ACTION_SUBTYPE)) {
                this.updateSubtype(ACTION_TYPE, ADF_ACTION_SUBTYPE);
            }
            if (this._options.contains(UPDATE_CONVERTER_SUBTYPE)) {
                this.updateSubtype(FACES_CONFIG_CONVERTER_ID_TYPE, JSF_CONVERTER_ID_SUBTYPE);
            }
            if (this._options.contains(UPDATE_STYLE_SUBTYPE)) {
                this.updateSubtype(CSS_STYLE_TYPE, STYLE_SUBTYPE);
            }
            if (this._options.contains(UPDATE_STYLE_CLASS_SUBTYPE)) {
                this.updateSubtype(CSS_CLASS_TYPE, ADF_STYLE_CLASS_SUBTYPE);
            }
        }
    }

    protected void updateEnumsForDialogs() {
        Map<EEnum, EDataType> enumToDataType = this.createEDataTypes();
        for (EClassifier classifier : this._ePackage.getEClassifiers()) {
            EClass eClass;
            String tagType;
            String tagName;
            Node tagEntity;
            if (!(classifier instanceof EClass) || (tagEntity = this.getTagEntity(tagName = this.getTagName(tagType = (eClass = (EClass)classifier).getName()))) == null) continue;
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                EEnum attrEnumType;
                EDataType dataType;
                EClassifier attrClassifier;
                Node attrValidValuesTrait;
                String attrName = feature.getName();
                Node tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName);
                if (tagAttrEntity == null || (attrValidValuesTrait = this.getTagAttributeTrait(tagAttrEntity, VALID_VALUES)) == null || this.getTraitListOfValues(attrValidValuesTrait).isEmpty() || !((attrClassifier = feature.getEType()) instanceof EEnum) || (dataType = enumToDataType.get(attrEnumType = (EEnum)attrClassifier)) == null) continue;
                feature.setEType((EClassifier)dataType);
                Node attrDefaultValueTrait = this.getTagAttributeTrait(tagAttrEntity, DEFAULT_VALUE);
                String defaultValue = null;
                if (attrDefaultValueTrait != null) {
                    defaultValue = this.getTraitValue(attrDefaultValueTrait);
                }
                if (defaultValue != null) {
                    feature.setDefaultValueLiteral(defaultValue);
                }
                System.out.println("Set " + tagName + ':' + attrName + "'s type to " + dataType.getName());
                if (defaultValue == null) continue;
                System.out.println("\tand set the default value to " + defaultValue);
            }
        }
    }

    protected Map<EEnum, EDataType> createEDataTypes() {
        Map<EEnum, String> dataTypeNames = this.getDataTypeNames();
        TreeMap<EEnum, EDataType> enumToDataType = new TreeMap<EEnum, EDataType>(new EEnumComparator());
        for (EEnum enumeration : dataTypeNames.keySet()) {
            EDataType dataType = this.createEDataType(enumeration, dataTypeNames.get(enumeration));
            System.out.println("Created " + dataType.getName() + " from " + enumeration.getName());
            enumToDataType.put(enumeration, dataType);
        }
        return enumToDataType;
    }

    protected EDataType createEDataType(EEnum enumType, String dataTypeName) {
        EClassifier existingClassifier = this._ePackage.getEClassifier(dataTypeName);
        if (existingClassifier instanceof EDataType) {
            if (existingClassifier instanceof EEnum) {
                System.err.println("EDataType " + dataTypeName + " already exists as an EEnum");
                return null;
            }
            return (EDataType)existingClassifier;
        }
        EcoreFactory factory = EcoreFactory.eINSTANCE;
        EDataType dataType = factory.createEDataType();
        dataType.setName(dataTypeName);
        dataType.setInstanceClassName("java.lang.Object");
        EAnnotation annotation = factory.createEAnnotation();
        annotation.setSource("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        annotation.getDetails().put((Object)"name", (Object)dataTypeName);
        annotation.getDetails().put((Object)"memberTypes", (Object)(String.valueOf(enumType.getName()) + " String"));
        annotation.getDetails().put((Object)"baseType", (Object)"http://www.eclipse.org/emf/2003/XMLType#anySimpleType");
        dataType.getEAnnotations().add((Object)annotation);
        this._ePackage.getEClassifiers().add((Object)dataType);
        return dataType;
    }

    protected Map<EEnum, String> getDataTypeNames() {
        TreeMap<EEnum, String> dataTypeNames = new TreeMap<EEnum, String>(new EEnumComparator());
        for (EClassifier classifier : this._ePackage.getEClassifiers()) {
            EClass eClass;
            String tagType;
            String tagName;
            Node tagEntity;
            if (!(classifier instanceof EClass) || (tagEntity = this.getTagEntity(tagName = this.getTagName(tagType = (eClass = (EClass)classifier).getName()))) == null) continue;
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                EClassifier attrClassifier;
                Node attrValidValuesTrait;
                String attrName = feature.getName();
                Node tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName);
                if (tagAttrEntity == null || (attrValidValuesTrait = this.getTagAttributeTrait(tagAttrEntity, VALID_VALUES)) == null || this.getTraitListOfValues(attrValidValuesTrait).isEmpty() || !((attrClassifier = feature.getEType()) instanceof EEnum)) continue;
                EEnum attrEnumType = (EEnum)attrClassifier;
                dataTypeNames.put(attrEnumType, this.createDataTypeName(attrEnumType));
            }
        }
        return dataTypeNames;
    }

    protected String createDataTypeName(EEnum enumType) {
        StringBuilder dataTypeName = new StringBuilder();
        dataTypeName.append(enumType.getName().substring(0, enumType.getName().lastIndexOf("Type")));
        dataTypeName.append("Union");
        dataTypeName.append(enumType.getName().substring(enumType.getName().lastIndexOf("Type")));
        return dataTypeName.toString();
    }

    protected void updateSubtype(String metadataType, String subtype) {
        for (EClassifier classifiers : this._ePackage.getEClassifiers()) {
            if (!(classifiers instanceof EClass)) continue;
            EClass eClass = (EClass)classifiers;
            String tagType = eClass.getName();
            String tagName = this.getTagName(tagType);
            Node tagEntity = this.getTagEntity(tagName);
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                String runtimeType;
                Node tagAttrTrait;
                Node tagAttrEntity;
                String attrName = feature.getName();
                if (tagEntity == null || (tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName)) == null || (tagAttrTrait = this.getTagAttributeTrait(tagAttrEntity, ATTRIBUTE_VALUE_RUNTIME_TYPE)) == null || !(runtimeType = this.getTraitValue(tagAttrTrait)).equals(metadataType)) continue;
                System.out.println(String.valueOf(tagName) + ":" + feature.getName());
                System.out.println("\t" + attrName);
                System.out.println("\t\tmetadata type: " + runtimeType);
                System.out.println("\t\tupdating subtype to " + subtype);
                EcoreFactory factory = EcoreFactory.eINSTANCE;
                EAnnotation tlei = factory.createEAnnotation();
                tlei.setSource(TLEI_URI);
                tlei.getDetails().put((Object)SUBTYPE_KEY, (Object)subtype);
                boolean subtypeSet = false;
                for (EAnnotation annotation : feature.getEAnnotations()) {
                    if (!annotation.getSource().equals(TLEI_URI)) continue;
                    String detail = (String)annotation.getDetails().get((Object)SUBTYPE_KEY);
                    if (!subtype.equals(detail)) {
                        System.out.println("Updated tlei subtype from " + detail + " to " + subtype);
                        annotation.getDetails().put((Object)SUBTYPE_KEY, (Object)subtype);
                        subtypeSet = true;
                        continue;
                    }
                    subtypeSet = true;
                }
                if (subtypeSet) continue;
                System.out.println("Set tlei subtype to " + subtype);
                feature.getEAnnotations().add((Object)tlei);
            }
        }
    }

    protected void updateTypes() {
        TreeSet<String> typeStrings = new TreeSet<String>();
        for (EClassifier classifiers : this._ePackage.getEClassifiers()) {
            if (!(classifiers instanceof EClass)) continue;
            EClass eClass = (EClass)classifiers;
            String tagType = eClass.getName();
            String tagName = this.getTagName(tagType);
            System.out.println(tagName);
            Node tagEntity = this.getTagEntity(tagName);
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                Node tagAttrTrait;
                Node tagAttrEntity;
                String attrName = feature.getName();
                System.out.println("\t" + attrName);
                if (tagEntity == null || (tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName)) == null || (tagAttrTrait = this.getTagAttributeTrait(tagAttrEntity, ATTRIBUTE_VALUE_RUNTIME_TYPE)) == null) continue;
                String runtimeType = this.getTraitValue(tagAttrTrait);
                typeStrings.add(runtimeType);
                System.out.println("\t\tmetadata type: " + runtimeType);
                EClassifier emfType = feature.getEType();
                System.out.println("\t\temf type:      " + emfType);
                EClassifier newEmfType = TYPE_MAP.get(runtimeType);
                if (newEmfType == null) {
                    System.out.println("\t\tNo mapping from metatdata type to emf type available");
                    continue;
                }
                if (emfType.equals(newEmfType)) continue;
                feature.setEType(newEmfType);
                System.out.println("\t\tupdate emf type to " + newEmfType);
            }
        }
        System.out.println("\nRuntime types found:");
        for (String typeString : typeStrings) {
            System.out.println(typeString);
        }
    }

    protected void updateEnums() {
        List<EnumerationData> enumerations = this.generateEnums();
        System.out.println("Total enumerations");
        System.out.println(String.valueOf(enumerations.size()) + " enumerations");
        for (EnumerationData enumeration : enumerations) {
            System.out.println(enumeration);
        }
        System.out.println(String.valueOf(enumerations.size()) + " enumerations");
        System.out.println("====================================================");
        this.combineEnums(enumerations);
        System.out.println("Combined enumerations");
        System.out.println(String.valueOf(enumerations.size()) + " enumerations");
        for (EnumerationData enumeration : enumerations) {
            System.out.println("-------------------------------------");
            System.out.println(enumeration);
        }
        System.out.println(String.valueOf(enumerations.size()) + " enumerations");
        System.out.println("====================================================");
        int numTags = 0;
        for (EnumerationData ed : enumerations) {
            numTags += ed.getWhereUsed().size();
        }
        System.out.println("Number of tags in combined enumerations: " + numTags);
        this.generateEnums(enumerations);
    }

    protected List<EnumerationData> generateEnums() {
        ArrayList<EnumerationData> enumerations = new ArrayList<EnumerationData>();
        for (EClassifier classifiers : this._ePackage.getEClassifiers()) {
            if (!(classifiers instanceof EClass)) continue;
            EClass eClass = (EClass)classifiers;
            String tagType = eClass.getName();
            String tagName = this.getTagName(tagType);
            Node tagEntity = this.getTagEntity(tagName);
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                Node tagAttrEntity;
                String attrName = feature.getName();
                if (tagEntity == null || (tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName)) == null) continue;
                Node valuesAttrTrait = this.getTagAttributeTrait(tagAttrEntity, VALID_VALUES);
                List<Object> values = Collections.emptyList();
                if (valuesAttrTrait != null) {
                    values = this.getTraitListOfValues(valuesAttrTrait);
                }
                Node defaultAttrTrait = this.getTagAttributeTrait(tagAttrEntity, DEFAULT_VALUE);
                String defaultValue = null;
                if (defaultAttrTrait != null) {
                    defaultValue = this.getTraitValue(defaultAttrTrait);
                }
                if (values.size() <= 0) continue;
                AttributeData attr = new AttributeData(eClass, feature);
                EnumerationData enumeration = new EnumerationData(attr, values, defaultValue);
                enumerations.add(enumeration);
            }
        }
        Collections.sort(enumerations, new EnumDataComparator());
        this.putDefaultValueFirst(enumerations);
        return enumerations;
    }

    protected void putDefaultValueFirst(List<EnumerationData> enums) {
        for (EnumerationData enumData : enums) {
            String defaultValue = enumData.getDefaultValue();
            List<String> validValues = enumData.getEnumValues();
            if (validValues.get(0).equals(defaultValue)) continue;
            int location = validValues.indexOf(defaultValue);
            if (location != -1) {
                validValues.remove(location);
            }
            validValues.add(0, defaultValue);
        }
    }

    protected void combineEnums(List<EnumerationData> enums) {
        int i = 0;
        while (i < enums.size()) {
            int j = i + 1;
            while (j < enums.size()) {
                EnumerationData enumI = enums.get(i);
                EnumerationData enumJ = enums.get(j);
                if (enumI != null && enumJ != null && enumI.isMatching(enumJ)) {
                    List<AttributeData> enumJAttrs = enumJ.getWhereUsed();
                    Assert.isTrue((enumJAttrs.size() == 1 ? 1 : 0) != 0);
                    enumI.addAttribute(enumJAttrs.get(0));
                    enums.set(j, null);
                }
                ++j;
            }
            ++i;
        }
        ListIterator<EnumerationData> iter = enums.listIterator();
        while (iter.hasNext()) {
            EnumerationData enumData = iter.next();
            if (enumData != null) continue;
            iter.remove();
        }
    }

    protected void generateEnums(List<EnumerationData> enums) {
        Map<String, EnumerationData> enumNames = this.generateEnumNames(enums);
        for (String key : enumNames.keySet()) {
            EClassifier existingEClassifier = this._ePackage.getEClassifier(key);
            if (existingEClassifier instanceof EEnum) {
                System.out.println("Found an existing EEnum: " + existingEClassifier);
                continue;
            }
            EEnum emfEnum = EcoreFactory.eINSTANCE.createEEnum();
            emfEnum.setName(key);
            emfEnum.setInstanceTypeName("java.lang.String");
            EnumerationData enumData = enumNames.get(key);
            int i = 0;
            for (String validValue : enumData.getEnumValues()) {
                EEnumLiteral emfEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                emfEnumLiteral.setName(validValue);
                emfEnumLiteral.setLiteral(validValue);
                emfEnumLiteral.setValue(i++);
                emfEnum.getELiterals().add((Object)emfEnumLiteral);
            }
            this._ePackage.getEClassifiers().add((Object)emfEnum);
            for (AttributeData attrToSet : enumData.getWhereUsed()) {
                if (attrToSet.getAttribute().getEType() instanceof EEnum) {
                    System.out.println("An EEnum is already set on " + attrToSet.getAttribute());
                    System.out.println("Not setting its type to " + emfEnum);
                    continue;
                }
                System.out.println("Setting " + emfEnum + " on " + attrToSet.getAttribute());
                attrToSet.getAttribute().setEType((EClassifier)emfEnum);
            }
        }
    }

    protected Map<String, EnumerationData> generateEnumNames(List<EnumerationData> enums) {
        TreeMap<String, EnumerationData> enumNames = new TreeMap<String, EnumerationData>();
        for (EnumerationData enumData : enums) {
            String attrName = enumData.getAttributeName();
            String enumName = null;
            int i = 1;
            while (enumNames.containsKey(enumName = this.generateEnumName(attrName, i++))) {
            }
            enumNames.put(enumName, enumData);
        }
        return enumNames;
    }

    protected String generateEnumName(String attrName, int generationAttempt) {
        StringBuilder builder = new StringBuilder(attrName);
        builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        builder.append("Type");
        if (generationAttempt > 1) {
            builder.append(generationAttempt);
        }
        return builder.toString();
    }

    protected String getTagName(String tagType) {
        if (tagType == null) {
            return null;
        }
        String myTagType = tagType.trim();
        if (myTagType.length() == 0) {
            return myTagType;
        }
        StringBuilder builder = new StringBuilder(myTagType.substring(0, myTagType.lastIndexOf("Type")));
        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        return builder.toString();
    }

    protected Node getTagEntity(String tagName) {
        Element root = this._metadataDom.getDocumentElement();
        NodeList entities = root.getElementsByTagName(ENTITY_NODE_NAME);
        int i = 0;
        while (i < entities.getLength()) {
            Node idAttr;
            NamedNodeMap attrs;
            Node typeAttr;
            Node node = entities.item(i);
            if (node.hasAttributes() && (typeAttr = (attrs = node.getAttributes()).getNamedItem(ENTITY_TYPE_ATTR_NAME)) != null && typeAttr.getNodeValue().equals(ENTITY_TYPE_ATTR_TAG_VALUE) && (idAttr = attrs.getNamedItem("id")) != null && idAttr.getNodeValue().equals(tagName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected Node getTagAttributeEntity(Node tagEntity, String attrName) {
        if (tagEntity == null) {
            return null;
        }
        if (tagEntity.hasChildNodes()) {
            NodeList children = tagEntity.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                NamedNodeMap attrs;
                Node idAttr;
                Node child = children.item(i);
                if (child.hasAttributes() && (idAttr = (attrs = child.getAttributes()).getNamedItem("id")) != null && idAttr.getNodeValue().equals(attrName)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    protected Node getTagAttributeTrait(Node tagAttrEntity, String traitName) {
        if (tagAttrEntity == null) {
            return null;
        }
        if (tagAttrEntity.hasChildNodes()) {
            NodeList children = tagAttrEntity.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                NamedNodeMap attrs;
                Node idAttr;
                Node child = children.item(i);
                if (child.getNodeName().equals(TRAIT_NODE_NAME) && child.hasAttributes() && (idAttr = (attrs = child.getAttributes()).getNamedItem("id")) != null && idAttr.getNodeValue().equals(traitName)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    protected String getTraitValue(Node trait) {
        if (trait == null) {
            return null;
        }
        if (trait.hasChildNodes()) {
            NodeList children = trait.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeName().equals(TRAIT_VALUE_NODE_NAME)) {
                    return child.getTextContent();
                }
                ++i;
            }
        }
        return null;
    }

    protected List<String> getTraitListOfValues(Node trait) {
        if (trait == null) {
            return Collections.emptyList();
        }
        if (trait.hasChildNodes()) {
            NodeList children = trait.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeName().equals(TRAIT_VALUE_NODE_NAME) && child.hasChildNodes()) {
                    NodeList items = child.getChildNodes();
                    ArrayList<String> listOfValues = new ArrayList<String>(items.getLength());
                    int j = 0;
                    while (j < items.getLength()) {
                        Node item = items.item(j);
                        if (item.getNodeName().equals(ITEM_NODE_NAME)) {
                            listOfValues.add(item.getTextContent().trim());
                        }
                        ++j;
                    }
                    return listOfValues;
                }
                ++i;
            }
        }
        return Collections.emptyList();
    }

    protected void updateBooleanDefaults() {
        for (EClassifier classifiers : this._ePackage.getEClassifiers()) {
            if (!(classifiers instanceof EClass)) continue;
            EClass eClass = (EClass)classifiers;
            String tagType = eClass.getName();
            String tagName = this.getTagName(tagType);
            Node tagEntity = this.getTagEntity(tagName);
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                Node tagAttrEntity;
                if (!EcorePackage.Literals.EBOOLEAN_OBJECT.equals(feature.getEType()) && !JsptagbasePackage.Literals.BOOLEAN_OBJECT_PLUS_EL.equals(feature.getEType())) continue;
                String attrName = feature.getName();
                if (tagEntity == null || (tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName)) == null) continue;
                Node defaultAttrTrait = this.getTagAttributeTrait(tagAttrEntity, DEFAULT_VALUE);
                String defaultValue = null;
                if (defaultAttrTrait != null) {
                    defaultValue = this.getTraitValue(defaultAttrTrait);
                }
                if (defaultValue == null) continue;
                if (defaultValue.equalsIgnoreCase("true")) {
                    feature.setDefaultValue((Object)"true");
                    continue;
                }
                if (defaultValue.equalsIgnoreCase("false")) {
                    feature.setDefaultValue((Object)"false");
                    continue;
                }
                System.out.println(String.valueOf(tagName) + ":" + attrName + ": Unknown default value for boolean attribute: " + defaultValue);
            }
        }
    }

    protected void updateBooleanToBooleanPlusEL() {
        EDataType booleanPlusELType = JsptagbasePackage.Literals.BOOLEAN_OBJECT_PLUS_EL;
        for (EClassifier classifiers : this._ePackage.getEClassifiers()) {
            if (!(classifiers instanceof EClass)) continue;
            EClass eClass = (EClass)classifiers;
            String tagType = eClass.getName();
            String tagName = this.getTagName(tagType);
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                if (!EcorePackage.Literals.EBOOLEAN_OBJECT.equals(feature.getEType())) continue;
                String attrName = feature.getName();
                feature.setEType((EClassifier)booleanPlusELType);
                System.out.println("Set " + tagName + ':' + attrName + " to " + booleanPlusELType.getName());
            }
        }
    }

    protected void updateTextDefaults() {
        for (EClassifier classifiers : this._ePackage.getEClassifiers()) {
            if (!(classifiers instanceof EClass)) continue;
            EClass eClass = (EClass)classifiers;
            String tagType = eClass.getName();
            String tagName = this.getTagName(tagType);
            Node tagEntity = this.getTagEntity(tagName);
            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                Node valuesAttrTrait;
                Node defaultAttrTrait;
                EClassifier emfType;
                String runtimeType;
                Node tagAttrTrait;
                Node tagAttrEntity;
                String attrName = feature.getName();
                if (tagEntity == null || (tagAttrEntity = this.getTagAttributeEntity(tagEntity, attrName)) == null || (tagAttrTrait = this.getTagAttributeTrait(tagAttrEntity, ATTRIBUTE_VALUE_RUNTIME_TYPE)) == null || (runtimeType = this.getTraitValue(tagAttrTrait)) == null || !XMLTypePackage.Literals.STRING.equals(emfType = TYPE_MAP.get(runtimeType)) && !JsptagbasePackage.Literals.OPTIONAL_INTEGER.equals(emfType) && !JsptagbasePackage.Literals.OPTIONAL_LONG.equals(emfType) && !JsptagbasePackage.Literals.OPTIONAL_DOUBLE.equals(emfType) || (defaultAttrTrait = this.getTagAttributeTrait(tagAttrEntity, DEFAULT_VALUE)) == null || (valuesAttrTrait = this.getTagAttributeTrait(tagAttrEntity, VALID_VALUES)) != null) continue;
                String defaultValue = this.getTraitValue(defaultAttrTrait);
                feature.setDefaultValue((Object)defaultValue);
                System.out.println("Set default value for " + tagName + ":" + attrName + " to " + defaultValue);
            }
        }
    }

    private static final class AttributeData {
        private final EClass _tag;
        private final EStructuralFeature _attribute;

        public AttributeData(EClass tag, EStructuralFeature attribute) {
            Assert.isNotNull((Object)tag);
            Assert.isNotNull((Object)attribute);
            this._tag = tag;
            this._attribute = attribute;
        }

        public EStructuralFeature getAttribute() {
            return this._attribute;
        }

        public String getTagName() {
            return this._tag.getName();
        }

        public String getAttributeName() {
            return this._attribute.getName();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttributeData)) {
                return false;
            }
            AttributeData that = (AttributeData)object;
            return this._tag.equals(that._tag) && this._attribute.equals(that._attribute);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.getTagName().hashCode();
            result = 37 * result + this.getAttributeName().hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append('(');
            builder.append(this.getTagName());
            builder.append(',');
            builder.append(this.getAttributeName());
            builder.append(')');
            return builder.toString();
        }
    }

    private static enum CommandLineError {
        NOT_ENOUGH_ARGUMENTS("Not enough arguments", -1),
        FILE_NOT_FOUND("File not found", -2),
        GENERAL_IO_FAILURE("General I/O Failure", -3),
        DOM_PARSER_ERROR("DOM parser error", -4);

        private final String _message;
        private final int _code;

        private CommandLineError(String message, int code) {
            this._message = message;
            this._code = code;
        }

        public String toString() {
            return this._message;
        }

        public int getCode() {
            return this._code;
        }
    }

    private static class EEnumComparator
    implements Comparator {
        private EEnumComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            EEnum enum0 = (EEnum)arg0;
            EEnum enum1 = (EEnum)arg1;
            return enum0.getName().compareTo(enum1.getName());
        }
    }

    private static final class EnumDataComparator
    implements Comparator {
        private EnumDataComparator() {
        }

        public int compare(Object x, Object y) {
            EnumerationData enumX = (EnumerationData)x;
            EnumerationData enumY = (EnumerationData)y;
            int attrDiff = enumX.getAttributeName().compareTo(enumY.getAttributeName());
            if (attrDiff != 0) {
                return attrDiff;
            }
            return enumX.getWhereUsed().get(0).getTagName().compareTo(enumY.getWhereUsed().get(0).getTagName());
        }
    }

    private static final class EnumerationData {
        private List<AttributeData> _whereUsed = new ArrayList<AttributeData>();
        private final List<String> _enumValues;
        private final String _defaultValue;

        public EnumerationData(AttributeData attributeData, List<String> enumValues, String defaultValue) {
            Assert.isNotNull((Object)attributeData);
            Assert.isNotNull(enumValues);
            Assert.isTrue((enumValues.size() > 0 ? 1 : 0) != 0);
            this._whereUsed.add(attributeData);
            this._enumValues = new ArrayList<String>(enumValues);
            this._defaultValue = defaultValue == null || defaultValue.trim().equals("") ? this._enumValues.get(0) : defaultValue;
        }

        public String getAttributeName() {
            return this._whereUsed.get(0).getAttributeName();
        }

        public List<AttributeData> getWhereUsed() {
            return this._whereUsed;
        }

        public boolean addAttribute(AttributeData attributeData) {
            boolean add;
            boolean bl = add = !this._whereUsed.contains(attributeData);
            if (add) {
                this._whereUsed.add(attributeData);
            }
            return add;
        }

        public List<String> getEnumValues() {
            return this._enumValues;
        }

        public String getDefaultValue() {
            return this._defaultValue;
        }

        public boolean isMatching(EnumerationData enumeration) {
            if (!this.getAttributeName().equals(enumeration.getAttributeName())) {
                return false;
            }
            if (this.getEnumValues().size() != enumeration.getEnumValues().size()) {
                return false;
            }
            int i = 0;
            while (i < this.getEnumValues().size()) {
                if (!this.getEnumValues().get(i).equals(enumeration.getEnumValues().get(i))) {
                    return false;
                }
                ++i;
            }
            return this.getDefaultValue().equals(enumeration.getDefaultValue());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (AttributeData attr : this.getWhereUsed()) {
                builder.append(attr.getTagName());
                builder.append('\n');
            }
            builder.append('\t');
            builder.append(this.getAttributeName());
            builder.append('\n');
            builder.append("\t\tdefault value: ");
            builder.append(this.getDefaultValue());
            builder.append('\n');
            builder.append("\t\tvalues:\n");
            for (String value : this.getEnumValues()) {
                builder.append("\t\t\t");
                builder.append(value);
                builder.append('\n');
            }
            return builder.toString();
        }
    }
}

