/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.util.Iterator;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.CompoundOperationExecutor;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtils;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ADFWebFacetUninstallDelegate
implements IDelegate {
    private static final String ADF_VIEW_PARAM_NAME = "oracle.adf.view.rich.versionString.HIDDEN";
    private static final String TRINIDAD_FILE_MOD_PARAM_NAME = "org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION";
    private static final String TRINIDAD_FILTER_NAME = "trinidad";
    private static final String RESOURCES_SERVLET_NAME = "resources";
    private static final String MAP_PROXY_SERVLET_NAME = "MapProxyServlet";
    private static final String GATEWAY_SERVLET_NAME = "GatewayServlet";
    private static final String BIGRAPH_SERVLET_NAME = "BIGRAPHSERVLET";
    private static final String BIGAUGE_SERVLET_NAME = "BIGAUGESERVLET";
    private static final String ADF_BINDINGS_FILTER_NAME = "adfBindings";
    private static final String SERVLET_ADF_FILTER_NAME = "ServletADFFilter";
    private static final String ADF_CONFIG_LIFECYCLE_CALLBACK = "oracle.adf.mbean.share.config.ADFConfigLifeCycleCallBack";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        String WEB_CONTENT_FOLDER = OperationUtil.getWebContentFolderName((IProject)project);
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)480);
        try {
            FacetUtil.uninstallLibraries((LibraryFacetUninstallConfig)((LibraryFacetUninstallConfig)config), (IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            this.updateWebXml(project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            this.updateFacesConfigFile(project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120));
            CompoundOperation compoundOperation = new CompoundOperation(Strings.compoundOperationTitle);
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(WEB_CONTENT_FOLDER) + "/oracle/templates/threeColumnTemplate.jspx", true));
            compoundOperation.add((IOperation)new DeleteFileOperation(project, String.valueOf(WEB_CONTENT_FOLDER) + "/WEB-INF/trinidad-config.xml", true));
            CompoundOperationExecutor.executeWithPrompt((IProgressMonitor)ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)120), (ICompoundOperation)compoundOperation);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void updateWebXml(IProject project, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
        try {
            IDOMModel model = WebXmlUtils.getWebXmlModelForEdit((IProject)project);
            model.aboutToChangeModel();
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"context-param", (String)"param-name", (String)ADF_VIEW_PARAM_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"context-param", (String)"param-name", (String)TRINIDAD_FILE_MOD_PARAM_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter", (String)"filter-name", (String)TRINIDAD_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter-mapping", (String)"filter-name", (String)TRINIDAD_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter", (String)"filter-name", (String)ADF_BINDINGS_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter-mapping", (String)"filter-name", (String)ADF_BINDINGS_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter", (String)"filter-name", (String)SERVLET_ADF_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"filter-mapping", (String)"filter-name", (String)SERVLET_ADF_FILTER_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet", (String)"servlet-name", (String)RESOURCES_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet-mapping", (String)"servlet-name", (String)RESOURCES_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet", (String)"servlet-name", (String)MAP_PROXY_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet-mapping", (String)"servlet-name", (String)MAP_PROXY_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet", (String)"servlet-name", (String)GATEWAY_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet-mapping", (String)"servlet-name", (String)GATEWAY_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet", (String)"servlet-name", (String)BIGRAPH_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet-mapping", (String)"servlet-name", (String)BIGRAPH_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet", (String)"servlet-name", (String)BIGAUGE_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"servlet-mapping", (String)"servlet-name", (String)BIGAUGE_SERVLET_NAME);
            WebXmlUtils.removeNodes((IDOMModel)model, (String)"listener", (String)"listener-class", (String)ADF_CONFIG_LIFECYCLE_CALLBACK);
            WebXmlUtils.saveWebXmlModel((IDOMModel)model);
            model.changedModel();
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void updateFacesConfigFile(IProject project, IProgressMonitor monitor) throws CoreException {
        FacesConfigArtifactEdit edit = null;
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)"WEB-INF/faces-config.xml");
            if (edit.getFacesConfig() == null) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", "Non-null FacesConfigArtifactEdit expected"));
            }
            Iterator it = edit.getFacesConfig().getApplication().iterator();
            while (it.hasNext()) {
                Iterator kit = ((ApplicationType)it.next()).getDefaultRenderKitId().iterator();
                while (kit.hasNext()) {
                    if (!((DefaultRenderKitIdType)kit.next()).getTextContent().equals("oracle.adf.rich")) continue;
                    kit.remove();
                }
            }
            edit.save(null);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)10);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                assert (edit.isDisposed());
                edit = null;
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static final class Strings
    extends NLS {
        public static String compoundOperationTitle;

        static {
            Strings.initializeMessages((String)ADFWebFacetUninstallDelegate.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

