/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.J2EEConstants;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class ADFFacetUtils {
    public static IPath getContentPath(IProject project) {
        IContainer underlyingFolder;
        IVirtualFolder rootFolder;
        IVirtualComponent component;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = component.getRootFolder()) != null && (underlyingFolder = rootFolder.getUnderlyingFolder()) != null) {
            return underlyingFolder.getFullPath();
        }
        return null;
    }

    public static void createFolderIfNecessary(IPath folderPath, IProgressMonitor monitor) throws CoreException {
        if (!ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath).exists()) {
            ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath).create(true, true, monitor);
        }
    }

    public static void copyFileIfNecessary(URL src, String dest) throws CoreException {
        Path destFile = new Path(dest);
        if (!destFile.toFile().exists()) {
            Path srcPath = new Path(src.getPath());
            try {
                InputStream is = FileLocator.openStream((Bundle)ADFPlugin.getDefault().getBundle(), (IPath)srcPath, (boolean)false);
                FileOutputStream os = new FileOutputStream(dest);
                BufferedInputStream bfin = null;
                FilterOutputStream bfout = null;
                try {
                    int c;
                    bfin = new BufferedInputStream(is, 8192);
                    bfout = new BufferedOutputStream(os, 8192);
                    while ((c = bfin.read()) >= 0) {
                        ((BufferedOutputStream)bfout).write(c);
                    }
                }
                finally {
                    if (bfin != null) {
                        bfin.close();
                    }
                    if (bfout != null) {
                        bfout.close();
                    }
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", "Unable to copy file: " + src + "\n" + e.getMessage()));
            }
        }
    }

    public static Map<String, List<IProject>> findProjectsWithFacets(Collection<? extends IProject> projects, String ... facetIDs) {
        HashMap<String, List<IProject>> map = new HashMap<String, List<IProject>>(facetIDs.length);
        if (projects != null && !projects.isEmpty() && facetIDs.length > 0) {
            HashSet<IProjectFacet> facets = new HashSet<IProjectFacet>(facetIDs.length);
            String[] stringArray = facetIDs;
            int n = facetIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                try {
                    facets.add(ProjectFacetsManager.getProjectFacet((String)string));
                }
                catch (Exception exception) {}
                ++n2;
            }
            if (!facets.isEmpty()) {
                for (IProject iProject : projects) {
                    IFacetedProject facetedProject = null;
                    try {
                        facetedProject = ProjectFacetsManager.create((IProject)iProject);
                    }
                    catch (CoreException coreException) {}
                    if (facetedProject == null) continue;
                    for (IProjectFacetVersion projectFacetVersion : facetedProject.getProjectFacets()) {
                        IProjectFacet facet = projectFacetVersion.getProjectFacet();
                        if (!facets.contains(facet)) continue;
                        ArrayList<IProject> projectsWithFacet = (ArrayList<IProject>)map.get(facet.getId());
                        if (projectsWithFacet == null) {
                            projectsWithFacet = new ArrayList<IProject>();
                            map.put(facet.getId(), projectsWithFacet);
                        }
                        projectsWithFacet.add(iProject);
                    }
                }
            }
        }
        return map;
    }

    public static abstract class AdjustDeploymentAssemblyOperation
    extends AbstractBasicOperation {
        protected static final String WEB_PROJECT_FACET_ID = "jst.web";
        protected static final String EJB_PROJECT_FACET_ID = "jst.ejb";
        protected static final String JPA_PROJECT_FACET_ID = "jpt.jpa";

        public AdjustDeploymentAssemblyOperation() {
            super(Strings.adjustWebDeploymentAssemblyLabel);
        }

        protected abstract void computeWebAndReferencedProjects(Collection<IProject> var1, Collection<IProject> var2, IProgressMonitor var3);

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)10);
            ArrayList<IProject> adfWebProjects = new ArrayList<IProject>();
            ArrayList<IProject> referencedProjects = new ArrayList<IProject>();
            this.computeWebAndReferencedProjects(adfWebProjects, referencedProjects, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)4));
            this.createDeploymentAssemblyReferences(adfWebProjects, referencedProjects, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)6));
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
            return new Status(0, "oracle.eclipse.tools.adf.view", "Successfully adjusted the deployment assembly");
        }

        private void createDeploymentAssemblyReferences(Collection<? extends IProject> webProjects, Collection<? extends IProject> referencedProjects, IProgressMonitor monitor) {
            if (webProjects != null && !webProjects.isEmpty() && referencedProjects != null && !referencedProjects.isEmpty()) {
                ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)(webProjects.size() * referencedProjects.size()));
                for (IProject iProject : webProjects) {
                    IVirtualComponent webComponent = ComponentCore.createComponent((IProject)iProject, (boolean)true);
                    if (webComponent == null) continue;
                    IPath libPath = new Path(J2EEConstants.WEB_INF_LIB_DIR).makeAbsolute();
                    for (IProject iProject2 : referencedProjects) {
                        IVirtualComponent referencedComponent = ComponentCore.createComponent((IProject)iProject2);
                        if (referencedComponent != null) {
                            IVirtualReference reference;
                            IVirtualReference[] references;
                            boolean hasReference = false;
                            IVirtualReference[] iVirtualReferenceArray = references = webComponent.getReferences();
                            int n = references.length;
                            int n2 = 0;
                            while (n2 < n) {
                                reference = iVirtualReferenceArray[n2];
                                if (libPath.equals((Object)reference.getRuntimePath()) && iProject2.equals((Object)reference.getReferencedComponent().getProject())) {
                                    hasReference = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!hasReference) {
                                reference = ComponentCore.createReference((IVirtualComponent)webComponent, (IVirtualComponent)referencedComponent, (IPath)libPath);
                                reference.setRuntimePath(libPath);
                                reference.setArchiveName(VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(reference));
                                reference.create(0, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                                continue;
                            }
                        }
                        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    }
                }
            }
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static final class Strings
    extends NLS {
        public static String adjustWebDeploymentAssemblyLabel;

        static {
            Strings.initializeMessages((String)ADFFacetUtils.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

