/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.AbstractAdfActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfViewActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowCaseOutcomeArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ArtifactBasedAdfcActionNavCaseMatcher {
    public static final String DEFAULT_VIEW_ID = "*";
    private static final Set<String> ARTIFACT_TYPES;
    private final List<ControlFlowCaseOutcomeArtifact> mNavCases = new ArrayList<ControlFlowCaseOutcomeArtifact>();
    private final CollectionContext context;

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("adf-view-activity");
        types.add("adf-task-flow-call");
        ARTIFACT_TYPES = Collections.unmodifiableSet(types);
    }

    public ArtifactBasedAdfcActionNavCaseMatcher(CollectionContext context, IFile file, String viewId) {
        this.sortNavigationCases(file, viewId);
        this.context = context;
    }

    private void sortNavigationCases(IFile file, String from) {
        AbstractAdfActivityArtifact fromActivity = this.getFromActivity(file, from);
        if (fromActivity == null) {
            return;
        }
        String fromActivityId = fromActivity.getName();
        if (fromActivityId == null) {
            return;
        }
        List<ControlFlowRuleArtifact> navigationRules = this.getControlFlowRules(file);
        int countExactMatch = 0;
        for (ControlFlowRuleArtifact navRule : navigationRules) {
            String prefix;
            String ruleFromActivity;
            String string = ruleFromActivity = navRule.getName() == null ? "" : navRule.getName();
            if (fromActivityId.equals(ruleFromActivity)) {
                Collection<? extends ControlFlowCaseOutcomeArtifact> navCases = navRule.getNavigationOutcomes();
                this.mNavCases.addAll(countExactMatch, navCases);
                countExactMatch += navCases.size();
                continue;
            }
            if (ruleFromActivity == null || ruleFromActivity.length() == 0 || ruleFromActivity.equals(DEFAULT_VIEW_ID)) {
                this.mNavCases.addAll(navRule.getNavigationOutcomes());
                continue;
            }
            if (!ruleFromActivity.endsWith(DEFAULT_VIEW_ID) || !fromActivityId.startsWith(prefix = ruleFromActivity.substring(0, ruleFromActivity.length() - DEFAULT_VIEW_ID.length()))) continue;
            this.mNavCases.addAll(countExactMatch, navRule.getNavigationOutcomes());
        }
    }

    private AbstractAdfActivityArtifact getFromActivity(IFile file, String fromId) {
        Set queryArtifactsByTypes = DependencyModelManager.getInstance().getModel().queryArtifactsByTypes(ARTIFACT_TYPES, file.getProject());
        for (IArtifact artifact : queryArtifactsByTypes) {
            String page;
            if (artifact.getType() != "adf-view-activity" || (page = ((AdfViewActivityArtifact)artifact).getPage()) == null) continue;
            Path path = new Path(page);
            IPath filePath = file.getFullPath();
            IPath comparePath = file.getFullPath().removeFirstSegments(filePath.segmentCount() - path.segmentCount());
            comparePath = path.isAbsolute() ? comparePath.makeAbsolute() : comparePath.makeRelative();
            if (!comparePath.equals((Object)path)) continue;
            return (AbstractAdfActivityArtifact)artifact;
        }
        return null;
    }

    private List<ControlFlowRuleArtifact> getControlFlowRules(IFile file) {
        ArrayList<ControlFlowRuleArtifact> artifacts = new ArrayList<ControlFlowRuleArtifact>();
        Set queryArtifactsByTypes = DependencyModelManager.getInstance().getModel().queryArtifactsByTypes(Collections.singleton("adf-control-flow-rule"), file.getProject());
        for (IArtifact artifact : queryArtifactsByTypes) {
            IResource resource;
            boolean shouldInclude = true;
            ResourceLocation location = artifact.getLocation();
            if (location != null && (resource = location.getResource()) != null && resource.equals((Object)file)) {
                shouldInclude = false;
            }
            if (!shouldInclude) continue;
            artifacts.add((ControlFlowRuleArtifact)artifact);
        }
        return artifacts;
    }

    public Map<String, ControlFlowCaseOutcomeArtifact> getPossibleOutcomes() {
        HashMap<String, ControlFlowCaseOutcomeArtifact> map = new HashMap<String, ControlFlowCaseOutcomeArtifact>();
        int count = this.mNavCases.size();
        int i = count - 1;
        while (i >= 0) {
            ControlFlowCaseOutcomeArtifact navCase = this.mNavCases.get(i);
            if (navCase.getName() == null) {
                String fromOutcome;
                String string = fromOutcome = navCase.getOutcome() == null ? null : navCase.getOutcome();
                if (fromOutcome != null && fromOutcome.length() != 0) {
                    map.put(fromOutcome, navCase);
                }
            }
            --i;
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ControlFlowCaseOutcomeArtifact matchAction(CollectionContext context, String action, boolean isMethodBinding, String outcome, ResourceLocation location) {
        ControlFlowCaseOutcomeArtifact match = null;
        int matchSpecifity = 0;
        int i = 0;
        int n = this.mNavCases.size();
        while (i < n) {
            String fromOutcome;
            ControlFlowCaseOutcomeArtifact navCase = this.mNavCases.get(i);
            String fromAction = navCase.getName() == null ? null : navCase.getName();
            String string = fromOutcome = navCase.getOutcome() == null ? null : navCase.getOutcome();
            if (fromAction != null) {
                if (isMethodBinding) {
                    if (action.equals(fromAction)) {
                        if (fromOutcome == null) {
                            if (matchSpecifity < 2) {
                                match = navCase;
                                matchSpecifity = 2;
                            }
                        } else if (outcome.equals(fromOutcome)) {
                            return navCase;
                        }
                    }
                } else if (outcome.equals(fromOutcome)) {
                    return navCase;
                }
            } else if (fromOutcome != null) {
                if (outcome.equals(fromOutcome)) {
                    if (!isMethodBinding) return navCase;
                    if (matchSpecifity < 2) {
                        match = navCase;
                        matchSpecifity = 2;
                    }
                }
            } else if (matchSpecifity == 0) {
                match = navCase;
                matchSpecifity = 1;
            }
            ++i;
        }
        return match;
    }

    public ControlFlowCaseOutcomeArtifact matchOutcome(String action, String outcome, ResourceLocation location) {
        if (outcome == null || outcome.length() == 0) {
            return null;
        }
        return this.matchAction(this.context, action, false, outcome, location);
    }
}

