/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefBindingArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefBindingArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefSearchRegionArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefSearchRegionArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefTaskflowArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefTaskflowArtifactReference;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.adf.view.variables.AdfControllerExternalVariable;
import oracle.eclipse.tools.adf.view.variables.BindingsVariable;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableReferenceIterator;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.AbstractSimpleCollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigBeanArtifactLocator;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifactRef;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.FaceletTagCollector;
import oracle.eclipse.tools.webtier.jsp.collection.JSPTagCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class AdfManagedBeanReferenceCollectionParticipant
extends AbstractSimpleCollectionParticipant
implements ICollectionParticipant {
    private static final String ADF_MANAGED_BEAN_CATEGORY = "adf-managed-bean";
    private static final String ADF_BINDINGS_EL_EXPR_PREFIX = "#{bindings.";
    private static final ICollectionFilter sFILTER;
    private static final String COLLECTOR_ID = "AdfManagedBeanRefernceCollectionParticipant";

    static {
        HashSet types = new HashSet();
        types.addAll(JSPTagCollector.JSP_CONTENT_TYPES);
        types.addAll(FaceletTagCollector.FACELET_CONTENT_TYPES);
        sFILTER = new ContentTypeCollectionFilter(types);
    }

    public void collect(IResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        IResource res = resourceContext.getResource();
        if (res != null && res.getType() == 1 && sFILTER.match((IResourceContext)resourceContext)) {
            IFile file = (IFile)res;
            ResourceArtifact artifact = this.getContext().ensureResourceArtifact((IResource)file);
            this.getContext().resetCollection((IArtifact)artifact, COLLECTOR_ID);
            VariableReferenceIterator iter = VariablesController.getInstance().referenceIterator(file, false);
            while (iter.hasNext()) {
                int index;
                String remainingStr;
                List list;
                AbstractArtifactReference reference;
                Object locator;
                IObjectLocator objectLocator;
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                ValueReference ref = iter.next();
                Variable var = ref.getVariable();
                ResourceLocation location = new ResourceLocation((IResource)file, ref.getLocation());
                if (var instanceof AdfControllerExternalVariable) {
                    FacesConfigBeanArtifactLocator locator2 = new FacesConfigBeanArtifactLocator(file.getProject(), ADF_MANAGED_BEAN_CATEGORY, var.getName());
                    this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)new ManagedBeanArtifactRef((IArtifactLocator)locator2, (IArtifact)artifact, var.getName(), ref.getFieldName(), location, COLLECTOR_ID), false, (byte)0);
                    continue;
                }
                if (!(var instanceof BindingsVariable) || (objectLocator = ADFPlugin.getObjectLocator()) == null) continue;
                IProject earProject = DTRTUtil.getEARProject((IObjectLocator)objectLocator, (IResource)file);
                IFile pageDefinitionFile = null;
                IPageDefinition pageDefinition = null;
                if (earProject != null && (pageDefinition = objectLocator.getPageDefinitionForWebPage(earProject, file)) != null) {
                    pageDefinitionFile = objectLocator.getAccessibleFile((IObject)pageDefinition);
                }
                String origElexpr = location.getRange() != null ? RefactoringUtil.getRangeString((IFile)file, (Range)location.getRange()) : "";
                boolean foundId = false;
                String elexpr = null;
                elexpr = origElexpr;
                if (elexpr.startsWith("\"")) {
                    elexpr = elexpr.substring(1);
                }
                if (elexpr.endsWith("\"")) {
                    elexpr = elexpr.substring(0, elexpr.length() - 1);
                }
                if (pageDefinitionFile != null) {
                    ADFUtil.PageDefIdInfoForEL pageDefIdsInfo = ADFUtil.getIdsFromPagedef(pageDefinitionFile, elexpr);
                    if (pageDefIdsInfo != null) {
                        List<String> bindingIds = pageDefIdsInfo.bindingIds;
                        for (String string : bindingIds) {
                            foundId = true;
                            ADFMPageDefBindingArtifactLocator locator3 = new ADFMPageDefBindingArtifactLocator(string, pageDefinitionFile);
                            ADFMPageDefBindingArtifactReference reference2 = new ADFMPageDefBindingArtifactReference(string, pageDefinitionFile, locator3, (IArtifact)artifact, location, COLLECTOR_ID);
                            this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)reference2, false, (byte)0);
                        }
                    }
                    if (pageDefIdsInfo != null) {
                        List<String> taskFlowIds = pageDefIdsInfo.taskFlowIds;
                        for (String string : taskFlowIds) {
                            String fieldName = ref.getFieldName();
                            if (!fieldName.startsWith(string)) continue;
                            ResourceLocation bindingIdLocation = null;
                            if (location != null) {
                                bindingIdLocation = new ResourceLocation(location.getResource(), location.getRange());
                            }
                            ADFMPageDefTaskflowArtifactLocator locator4 = new ADFMPageDefTaskflowArtifactLocator(string, pageDefinitionFile);
                            ADFMPageDefTaskflowArtifactReference reference3 = new ADFMPageDefTaskflowArtifactReference(string, pageDefinitionFile, locator4, (IArtifact)artifact, bindingIdLocation, COLLECTOR_ID);
                            this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)reference3, false, (byte)0);
                            foundId = true;
                            break;
                        }
                    }
                    if (pageDefIdsInfo != null) {
                        for (String id : pageDefIdsInfo.executableIds) {
                            foundId = true;
                            List executables = pageDefinition.getExecutables();
                            IExecutable executable = null;
                            if (executables != null) {
                                for (IExecutable exec : executables) {
                                    if (!id.equals(exec.getId())) continue;
                                    executable = exec;
                                    break;
                                }
                            }
                            if (executable != null && executable.getTypeDescriptor().getLabel().equals("searchRegion")) {
                                locator = new ADFMPageDefSearchRegionArtifactLocator(id, pageDefinitionFile);
                                reference = new ADFMPageDefSearchRegionArtifactReference(id, pageDefinitionFile, (IArtifactLocator)locator, (IArtifact)artifact, location, COLLECTOR_ID);
                                this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)reference, false, (byte)0);
                                continue;
                            }
                            locator = new ADFMPageDefIteratorIdArtifactLocator(id, pageDefinitionFile);
                            reference = new ADFMPageDefIteratorIdArtifactReference(id, pageDefinitionFile, (IArtifactLocator)locator, (IArtifact)artifact, location, COLLECTOR_ID);
                            this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)reference, false, (byte)0);
                        }
                    }
                }
                if (foundId || elexpr == null || elexpr.indexOf(ADF_BINDINGS_EL_EXPR_PREFIX) == -1 || (list = StringUtil.split((String)(remainingStr = elexpr.substring((index = elexpr.indexOf(ADF_BINDINGS_EL_EXPR_PREFIX)) + ADF_BINDINGS_EL_EXPR_PREFIX.length())), (char)'.')) == null || list.size() <= 0) continue;
                String bindingId = (String)list.get(0);
                ResourceLocation bindingIdLocation = null;
                index = origElexpr.indexOf(bindingId);
                if (location != null) {
                    Range range = location.getRange();
                    Range newRange = new Range(range.getOffset(), (long)(index + bindingId.length()));
                    bindingIdLocation = new ResourceLocation(location.getResource(), newRange);
                }
                locator = new ADFMPageDefBindingArtifactLocator(bindingId, pageDefinitionFile);
                reference = new ADFMPageDefBindingArtifactReference(bindingId, pageDefinitionFile, (IArtifactLocator)locator, (IArtifact)artifact, bindingIdLocation, COLLECTOR_ID);
                this.getContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)reference, false, (byte)0);
            }
        }
    }
}

