/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import oracle.eclipse.tools.adf.controller.TaskFlowProxy;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFControllerArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefBindingArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefBindingArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefSearchRegionArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefSearchRegionArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFTaskFlowActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFTaskFlowCallArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFTaskFlowTemplateReferenceArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfControllerArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfManagedBeanArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfMethodCallActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfParentActionActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfRouterActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfSavePointRestoreActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfTaskflowActivityIDArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfTaskflowActivityIDArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfTaskflowReturnArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfURLViewActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfViewActivityArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowCaseOutcomeArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifact;
import oracle.eclipse.tools.adf.view.dependency.collection.ADFControllerArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.collection.AdfCollectionHelper;
import oracle.eclipse.tools.adf.view.dependency.collection.Messages;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.application.common.services.collection.AbstractXpathCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactOwnershipReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IVirtualArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanMapEntriesArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanProperty;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdfControllerConfigVisitor
extends AbstractXpathCollector {
    private static final String ADF_CONTROLLER_NAMESPACE = "http://xmlns.oracle.com/adf/controller";
    private static final String ADF_CONTROLLER_CONTENT_TYPE_ID = "adf.controller";
    private static final String ADF_TASKFLOW_EL_NAME = "task-flow-definition";
    private static final String CONTROL_FLOW_RULE_EL_NAME = "control-flow-rule";
    private static final String FROM_ACTIVITY_ID_EL_NAME = "from-activity-id";
    private static final String CONTROL_FLOW_CASE_EL_NAME = "control-flow-case";
    private static final String FROM_OUTCOME_EL_NAME = "from-outcome";
    private static final String TO_ACTIVITY_ID_EL_NAME = "to-activity-id";
    private static final String ADF_TASKFLOW_TEMPLATE_EL_NAME = "task-flow-template";
    private static final String VIEW_ELEMENT_NAME = "view";
    private static final String TASK_FLOW_CALL_ELEMENT_NAME = "task-flow-call";
    private static final String TASK_FLOW_RETURN_ELEMENT_NAME = "task-flow-return";
    private static final String METHOD_CALL_ELEMENT_NAME = "method-call";
    private static final String ROUTER_ELEMENT_NAME = "router";
    private static final String SAVE_POINT_RESTORE_ELEMENT_NAME = "save-point-restore";
    private static final String PARENT_ACTION_ELEMENT_NAME = "parent-action";
    private static final String URL_VIEW_ELEMENT_NAME = "url-view";
    private static final String ELEM_NS_PREFIX = "//ns:";
    public static final String ID = "adf.controller";
    private static final String JAVA_STRING_TYPE = "java.lang.String";
    private Map<String, IArtifact> activityToArtifactMap = new HashMap<String, IArtifact>();
    private final ValueReferenceELParser parser = new ValueReferenceELParser();
    private ITaskFlowContext.ITaskFlowProxy taskflowProxy = null;

    protected void collectDocument(IDOMDocument document) {
        NodeList controlFlowRulesNodeList;
        NodeList nodes;
        Assert.isLegal((document != null ? 1 : 0) != 0, (String)"Document must not be null");
        Assert.isNotNull((Object)this.getCollectionContext(), (String)"Collection context is null");
        Assert.isNotNull((Object)this.getResourceContext(), (String)"Resource context is null");
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        IContainer webRoot = this.getWebContentResource();
        IPath filePath = adfcConfigFile.getProjectRelativePath();
        int toRemove = filePath.matchingFirstSegments(webRoot.getProjectRelativePath());
        filePath = filePath.removeFirstSegments(toRemove);
        AdfControllerArtifact adfControllerArtifact = null;
        boolean isTemplate = false;
        NodeList taskFlowNodes = this.getNodes((IDOMNode)document, "//ns:task-flow-definition");
        if ((taskFlowNodes == null || taskFlowNodes.getLength() == 0) && (taskFlowNodes = this.getNodes((IDOMNode)document, "//ns:task-flow-template")) != null && taskFlowNodes.getLength() > 0) {
            isTemplate = true;
        }
        if (taskFlowNodes != null) {
            int i = 0;
            while (i < taskFlowNodes.getLength()) {
                String id;
                IDOMElement taskFlowElem;
                Attr idAttrNode;
                if (taskFlowNodes.item(i) instanceof IDOMElement && (idAttrNode = (taskFlowElem = (IDOMElement)taskFlowNodes.item(i)).getAttributeNode("id")) instanceof IDOMAttr && !(id = ((IDOMAttr)idAttrNode).getValue()).isEmpty()) {
                    ResourceLocation loc = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)((IDOMAttr)idAttrNode));
                    StringBuilder tfQualifiedName = new StringBuilder();
                    tfQualifiedName.append('/');
                    tfQualifiedName.append(filePath.toString());
                    tfQualifiedName.append('#');
                    tfQualifiedName.append(id);
                    adfControllerArtifact = new AdfControllerArtifact((IArtifact)this.getCollectionContext().ensureResourceArtifact((IResource)adfcConfigFile), tfQualifiedName.toString(), loc, loc, "adf.controller", isTemplate);
                    this.getCollectionContext().addArtifact((IArtifact)adfControllerArtifact, "adf.controller");
                }
                ++i;
            }
        }
        if (adfControllerArtifact == null) {
            adfControllerArtifact = new AdfControllerArtifact(adfcConfigFile, "adf.controller", false);
            this.getCollectionContext().addArtifact((IArtifact)adfControllerArtifact, "adf.controller");
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:managed-bean")) != null) {
            int j = 0;
            while (j < nodes.getLength()) {
                this.collectManagedBean(adfControllerArtifact, (IDOMElement)nodes.item(j));
                ++j;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:template-reference")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectTemplateReference(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:view")) != null) {
            int j = 0;
            while (j < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(j));
                ++j;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:task-flow-call")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:task-flow-return")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:method-call")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:router")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:save-point-restore")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:parent-action")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:url-view")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                this.collectActivity(adfControllerArtifact, (IDOMElement)nodes.item(i));
                ++i;
            }
        }
        if ((nodes = this.getNodes((IDOMNode)document, "//ns:default-activity")) != null && nodes.getLength() == 1) {
            this.collectDefaultActivity(adfControllerArtifact, (IDOMElement)nodes.item(0));
        }
        if ((controlFlowRulesNodeList = this.getNodes((IDOMNode)document, "//ns:control-flow-rule")) != null) {
            int j = 0;
            while (j < controlFlowRulesNodeList.getLength()) {
                this.collectControlFlowRuleElement(adfControllerArtifact, (IDOMElement)controlFlowRulesNodeList.item(j));
                ++j;
            }
        }
    }

    private ITaskFlowContext.ITaskFlowProxy getTaskFlowProxy() {
        if (this.taskflowProxy == null) {
            IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
            this.taskflowProxy = new TaskFlowProxy(adfcConfigFile);
        }
        return this.taskflowProxy;
    }

    private void collectDefaultActivity(AdfControllerArtifact adfControllerArtifact, IDOMElement defaultActivityElem) {
        String defaultActivityName = this.getCollectionContext().getNodeText((Node)defaultActivityElem);
        if (defaultActivityName != null) {
            IArtifact activityArtifact = this.activityToArtifactMap.get(defaultActivityName);
            ResourceLocation defaultActivityElemLocation = this.getCollectionContext().getLocationOfNode(this.getResourceContext().getResource(), (IDOMNode)defaultActivityElem);
            ADFTaskFlowActivityArtifact defaultActivityArtifact = new ADFTaskFlowActivityArtifact((IArtifact)adfControllerArtifact, defaultActivityElemLocation, defaultActivityElemLocation, Messages.AdfControllerConfigVisitor_defaultActivity, this.getID());
            this.getCollectionContext().addArtifact((IArtifact)defaultActivityArtifact, this.getID());
            AdfTaskflowActivityIDArtifactLocator locator = new AdfTaskflowActivityIDArtifactLocator(activityArtifact);
            AdfTaskflowActivityIDArtifactReference activityReference = new AdfTaskflowActivityIDArtifactReference(locator, (IArtifact)defaultActivityArtifact, defaultActivityElemLocation, defaultActivityName, this.getID());
            this.getCollectionContext().addReferencedArtifact((IArtifact)defaultActivityArtifact, (IArtifactReference)activityReference, false, (byte)0);
        }
    }

    private void collectActivity(AdfControllerArtifact adfControllerArtifact, IDOMElement activityElem) {
        IFile taskFlowFile = (IFile)this.getResourceContext().getResource();
        String activityId = activityElem.getAttribute("id");
        if (activityId != null && !activityId.isEmpty()) {
            Range idRange;
            ResourceLocation activityElemIdLocation;
            IDOMAttr attr = (IDOMAttr)activityElem.getAttributeNode("id");
            if (attr == null) {
                return;
            }
            ResourceLocation activityElemLocation = this.getCollectionContext().getLocationOfNode((IResource)taskFlowFile, (IDOMNode)activityElem);
            IArtifact activityArtifact = this.createActivityArtifact(adfControllerArtifact, activityElem, activityElemLocation, activityElemIdLocation = new ResourceLocation((IResource)taskFlowFile, idRange = new Range((long)attr.getValueRegionStartOffset(), (long)(activityId.length() + 2))), activityId);
            if (activityArtifact != null) {
                NodeList pages;
                NodeList taskFlowReferenceList;
                this.getCollectionContext().addArtifact(activityArtifact, this.getID());
                this.activityToArtifactMap.put(activityId, activityArtifact);
                if (activityArtifact instanceof ADFTaskFlowCallArtifact && (taskFlowReferenceList = activityElem.getElementsByTagName("task-flow-reference")) != null && taskFlowReferenceList.getLength() > 0) {
                    IDOMElement taskFlowReferenceElem = (IDOMElement)taskFlowReferenceList.item(0);
                    this.collectTaskFlowCallReference(taskFlowReferenceElem, (ADFTaskFlowCallArtifact)activityArtifact);
                }
                if (activityArtifact instanceof AdfViewActivityArtifact && (pages = activityElem.getElementsByTagName("page")) != null && pages.getLength() > 0) {
                    IDOMElement page = (IDOMElement)pages.item(0);
                    this.collectPage(activityId, page, (AdfViewActivityArtifact)activityArtifact);
                }
                IFile pageDefFile = null;
                String activityElemName = activityElem.getLocalName();
                if (activityElemName.equals(METHOD_CALL_ELEMENT_NAME) || activityElemName.equals(ROUTER_ELEMENT_NAME) || activityElemName.equals(TASK_FLOW_CALL_ELEMENT_NAME)) {
                    pageDefFile = ADFUtil.getPagedefFileForTaskflowActivity(this.getTaskFlowProxy(), activityId);
                }
                this.collectELReferencesInElem(activityElem, activityArtifact, pageDefFile);
            }
        }
    }

    private IArtifact createActivityArtifact(AdfControllerArtifact adfControllerArtifact, IDOMElement activityElem, ResourceLocation activityElemLocation, ResourceLocation activityElemIdLocation, String activityId) {
        String activityType = activityElem.getLocalName();
        if (activityType.equals(VIEW_ELEMENT_NAME)) {
            return new AdfViewActivityArtifact(adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(TASK_FLOW_CALL_ELEMENT_NAME)) {
            return new ADFTaskFlowCallArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(TASK_FLOW_RETURN_ELEMENT_NAME)) {
            return new AdfTaskflowReturnArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(METHOD_CALL_ELEMENT_NAME)) {
            return new AdfMethodCallActivityArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(ROUTER_ELEMENT_NAME)) {
            return new AdfRouterActivityArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(SAVE_POINT_RESTORE_ELEMENT_NAME)) {
            return new AdfSavePointRestoreActivityArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(PARENT_ACTION_ELEMENT_NAME)) {
            return new AdfParentActionActivityArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        if (activityType.equals(URL_VIEW_ELEMENT_NAME)) {
            return new AdfURLViewActivityArtifact((IArtifact)adfControllerArtifact, activityElemLocation, activityElemIdLocation, activityId, this.getID());
        }
        return null;
    }

    private void collectTaskFlowCallReference(IDOMElement taskFlowReferenceElem, ADFTaskFlowCallArtifact taskflowCallArtifact) {
        NodeList documentList = taskFlowReferenceElem.getElementsByTagName("document");
        if (documentList != null && documentList.getLength() > 0) {
            NodeList idList;
            IDOMElement documentElement = (IDOMElement)documentList.item(0);
            String taskFlowCallPath = this.getCollectionContext().getNodeText((Node)documentElement);
            IFile file = (IFile)this.getResourceContext().getResource();
            IResource resource = this.resolveWebContentResource(file.getProject(), taskFlowCallPath);
            if (resource != null) {
                ResourceLocation location = new ResourceLocation((IResource)file, new Range((long)documentElement.getStartOffset(), (long)(documentElement.getEndOffset() - documentElement.getStartOffset())));
                this.getCollectionContext().addReferencedResource((IArtifact)taskflowCallArtifact, resource, true, location, (byte)0, this.getID());
            }
            if ((idList = taskFlowReferenceElem.getElementsByTagName("id")) != null && idList.getLength() > 0) {
                IDOMElement idElement = (IDOMElement)idList.item(0);
                String idStr = this.getCollectionContext().getNodeText((Node)idElement);
                String taskflowID = String.valueOf(taskFlowCallPath) + "#" + idStr;
                taskflowID = !taskflowID.startsWith("/") ? "/" + taskflowID : taskflowID;
                ResourceLocation idElemLocation = new ResourceLocation((IResource)file, new Range((long)idElement.getStartOffset(), (long)(idElement.getEndOffset() - idElement.getStartOffset())));
                ADFControllerArtifactLocator locator = new ADFControllerArtifactLocator(taskflowID, file.getProject());
                ADFControllerArtifactReference reference = new ADFControllerArtifactReference(taskflowID, idStr, file.getProject(), locator, (IArtifact)taskflowCallArtifact, idElemLocation, "adf.controller", false, false);
                this.getCollectionContext().addReferencedArtifact((IArtifact)taskflowCallArtifact, (IArtifactReference)reference, true, (byte)0);
            }
        }
    }

    private void collectPage(String id, IDOMElement page, AdfViewActivityArtifact viewActivity) {
        String pagePath = this.getCollectionContext().getNodeText((Node)page);
        viewActivity.setPage(pagePath);
        IFile file = (IFile)this.getResourceContext().getResource();
        IResource resource = this.resolveWebContentResource(file.getProject(), pagePath);
        if (resource != null) {
            ResourceLocation location = new ResourceLocation((IResource)file, new Range((long)page.getStartOffset(), (long)(page.getEndOffset() - page.getStartOffset())));
            this.getCollectionContext().addReferencedResource((IArtifact)viewActivity, resource, true, location, (byte)0, this.getID());
        }
    }

    private void collectTemplateReference(AdfControllerArtifact adfControllerArtifact, IDOMElement templateReferenceElement) {
        NodeList documentList = templateReferenceElement.getElementsByTagName("document");
        if (documentList != null && documentList.getLength() > 0) {
            NodeList idList;
            IDOMElement documentElement = (IDOMElement)documentList.item(0);
            String taskFlowCallPath = this.getCollectionContext().getNodeText((Node)documentElement);
            IFile file = (IFile)this.getResourceContext().getResource();
            IResource resource = this.resolveWebContentResource(file.getProject(), taskFlowCallPath);
            ResourceLocation taskFlowTemplRefLocation = this.getCollectionContext().getLocationOfNode((IResource)file, (IDOMNode)templateReferenceElement);
            ADFTaskFlowTemplateReferenceArtifact taskflowTemplateArtifact = new ADFTaskFlowTemplateReferenceArtifact((IArtifact)adfControllerArtifact, taskFlowTemplRefLocation, taskFlowTemplRefLocation, taskFlowCallPath, this.getID());
            this.getCollectionContext().addArtifact((IArtifact)taskflowTemplateArtifact, this.getID());
            if (resource != null) {
                ResourceLocation location = new ResourceLocation((IResource)file, new Range((long)documentElement.getStartOffset(), (long)(documentElement.getEndOffset() - documentElement.getStartOffset())));
                this.getCollectionContext().addReferencedResource((IArtifact)taskflowTemplateArtifact, resource, true, location, (byte)0, this.getID());
            }
            if ((idList = templateReferenceElement.getElementsByTagName("id")) != null && idList.getLength() > 0) {
                IDOMElement idElement = (IDOMElement)idList.item(0);
                String idStr = this.getCollectionContext().getNodeText((Node)idElement);
                String taskflowID = String.valueOf(taskFlowCallPath) + "#" + idStr;
                ResourceLocation idElemLocation = new ResourceLocation((IResource)file, new Range((long)idElement.getStartOffset(), (long)(idElement.getEndOffset() - idElement.getStartOffset())));
                ADFControllerArtifactLocator locator = new ADFControllerArtifactLocator(taskflowID, file.getProject());
                ADFControllerArtifactReference reference = new ADFControllerArtifactReference(taskflowID, idStr, file.getProject(), locator, (IArtifact)taskflowTemplateArtifact, idElemLocation, "adf.controller", false, true);
                this.getCollectionContext().addReferencedArtifact((IArtifact)taskflowTemplateArtifact, (IArtifactReference)reference, true, (byte)0);
            }
        }
    }

    private IResource resolveWebContentResource(IProject project, String pagePathStr) {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            IContainer designTimeRoot = rootFolder.getUnderlyingFolder();
            IResource resource = designTimeRoot.findMember(pagePathStr);
            return resource != null ? resource : project.getFile(pagePathStr);
        }
        return project.getFile(pagePathStr);
    }

    private void collectManagedBean(AdfControllerArtifact adfControllerArtifact, IDOMElement managedBeanElement) {
        String managedBeanName;
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        NodeList managedBeanNames = managedBeanElement.getElementsByTagName("managed-bean-name");
        if (managedBeanNames.getLength() > 0 && adfcConfigFile != null && (managedBeanName = this.getCollectionContext().getNodeText(managedBeanNames.item(0))) != null) {
            NodeList mapEntriesElements;
            NodeList properties;
            String managedBeanClass;
            ResourceLocation location = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)managedBeanNames.item(0));
            AdfManagedBeanArtifact managedBeanArtifact = new AdfManagedBeanArtifact(managedBeanName, location, (IArtifact)adfControllerArtifact, this.getID());
            this.getCollectionContext().addArtifact((IArtifact)managedBeanArtifact, this.getID());
            NodeList managedBeanClasses = managedBeanElement.getElementsByTagName("managed-bean-class");
            if (managedBeanClasses.getLength() > 0 && managedBeanClasses.item(0) instanceof IDOMElement && (managedBeanClass = this.getCollectionContext().getNodeText(managedBeanClasses.item(0))) != null) {
                this.getCollectionContext().addTypeReference((IArtifact)managedBeanArtifact, adfcConfigFile.getProject(), managedBeanClass, (IResource)adfcConfigFile, (IDOMElement)managedBeanClasses.item(0), false, this.getID());
            }
            if ((properties = this.getNodes((IDOMNode)managedBeanElement, "ns:managed-property")) != null) {
                int i = 0;
                while (i < properties.getLength()) {
                    IDOMElement propertyElement = (IDOMElement)properties.item(i);
                    this.collectManagedBeanProperty(propertyElement, managedBeanArtifact);
                    ++i;
                }
            }
            if ((mapEntriesElements = managedBeanElement.getElementsByTagName("map-entries")) != null && mapEntriesElements.getLength() > 0) {
                int i = 0;
                while (i < mapEntriesElements.getLength()) {
                    IDOMElement mapEntryNode = (IDOMElement)mapEntriesElements.item(i);
                    this.collectManagedBeansMapEntries(mapEntryNode, managedBeanArtifact);
                    ++i;
                }
            }
        }
    }

    private void collectManagedBeansMapEntries(IDOMElement mapEntryNode, AdfManagedBeanArtifact managedBeanArtifact) {
        NodeList mapEntries;
        IStructuredDocumentCollectionContext structuredContext = this.getCollectionContext();
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        NodeList keyClassElement = mapEntryNode.getElementsByTagName("key-class");
        NodeList valueClassElement = mapEntryNode.getElementsByTagName("value-class");
        String keyClassName = keyClassElement == null || keyClassElement.getLength() == 0 ? JAVA_STRING_TYPE : structuredContext.getNodeText(keyClassElement.item(0));
        String valueClassName = valueClassElement == null || valueClassElement.getLength() == 0 ? JAVA_STRING_TYPE : structuredContext.getNodeText(valueClassElement.item(0));
        ResourceLocation entrieslocation = structuredContext.getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)mapEntryNode);
        ManagedBeanMapEntriesArtifact entriesArtifact = new ManagedBeanMapEntriesArtifact(entrieslocation, entrieslocation, (ManagedBeanArtifact)managedBeanArtifact, this.getID());
        structuredContext.addArtifact((IArtifact)entriesArtifact, this.getID());
        if (keyClassElement != null && keyClassElement.getLength() > 0) {
            structuredContext.addTypeReference((IArtifact)entriesArtifact, adfcConfigFile.getProject(), keyClassName, (IResource)adfcConfigFile, (IDOMElement)keyClassElement.item(0), false, this.getID());
        }
        if (valueClassElement != null && valueClassElement.getLength() > 0) {
            structuredContext.addTypeReference((IArtifact)entriesArtifact, adfcConfigFile.getProject(), valueClassName, (IResource)adfcConfigFile, (IDOMElement)valueClassElement.item(0), false, this.getID());
        }
        if ((mapEntries = mapEntryNode.getElementsByTagName("map-entry")) != null && mapEntries.getLength() > 0) {
            int i = 0;
            while (i < mapEntries.getLength()) {
                Node keyElementNode;
                IDOMElement mapEntry = (IDOMElement)mapEntries.item(i);
                NodeList keys = mapEntry.getElementsByTagName("key");
                if (keys != null && keys.getLength() > 0 && (keyElementNode = keys.item(0)) instanceof IDOMElement) {
                    String key = structuredContext.getNodeText(keyElementNode);
                    ResourceLocation location = structuredContext.getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)mapEntry);
                    ResourceLocation boundedLocation = structuredContext.getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)keys.item(0));
                    ManagedBeanProperty property = new ManagedBeanProperty(key, location, boundedLocation, (IVirtualArtifact)entriesArtifact, this.getID());
                    structuredContext.addArtifact((IArtifact)property, this.getID());
                }
                ++i;
            }
        }
    }

    private void collectManagedBeanProperty(IDOMElement propertyElement, AdfManagedBeanArtifact managedBeanArtifact) {
        Node propertyNameNode;
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        NodeList nameElement = this.getNodes((IDOMNode)propertyElement, "ns:property-name");
        NodeList classElement = this.getNodes((IDOMNode)propertyElement, "ns:property-class");
        if (nameElement != null && nameElement.getLength() > 0 && classElement != null && classElement.getLength() > 0 && (propertyNameNode = nameElement.item(0)) instanceof IDOMElement) {
            String propertyName = this.getCollectionContext().getNodeText(propertyNameNode);
            String className = this.getCollectionContext().getNodeText(classElement.item(0));
            if (propertyName != null && className != null) {
                ResourceLocation location = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)propertyElement);
                long offset = ((IDOMElement)propertyNameNode).getStartEndOffset();
                long length = (long)((IDOMElement)propertyNameNode).getEndStartOffset() - offset;
                ResourceLocation boundedLocation = new ResourceLocation((IResource)adfcConfigFile, new Range(offset, length));
                ManagedBeanProperty property = new ManagedBeanProperty(propertyName, location, boundedLocation, (IVirtualArtifact)managedBeanArtifact, this.getID());
                this.getCollectionContext().addArtifact((IArtifact)property, this.getID());
                this.getCollectionContext().addTypeReference((IArtifact)property, adfcConfigFile.getProject(), className, (IResource)adfcConfigFile, (IDOMElement)classElement.item(0), false, this.getID());
            }
        }
    }

    public String getID() {
        return "adf.controller";
    }

    private IContainer getWebContentResource() {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getCollectionContext().getProject());
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder();
        }
        return null;
    }

    protected NamespaceContext getNamespaceContext() {
        return new MapNamespaceContext("ns", ADF_CONTROLLER_NAMESPACE);
    }

    protected Set<String> getDocumentContentTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>(1, 1.0f);
        types.add("adf.controller");
        return types;
    }

    private void collectControlFlowRuleElement(AdfControllerArtifact adfControllerArtifact, IDOMElement controlFlowRuleElement) {
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        NodeList fromActivityElements = controlFlowRuleElement.getElementsByTagName(FROM_ACTIVITY_ID_EL_NAME);
        IDOMElement fromActivityElem = null;
        String fromActivityID = null;
        if (fromActivityElements.getLength() > 0 && fromActivityElements.item(0) instanceof IDOMElement) {
            fromActivityElem = (IDOMElement)fromActivityElements.item(0);
            fromActivityID = this.getCollectionContext().getNodeText((Node)fromActivityElem);
        }
        ResourceLocation controlFlowRuleLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)controlFlowRuleElement);
        ControlFlowRuleArtifact controlFlowRuleArtifact = null;
        if (fromActivityID == null || fromActivityID.length() == 0) {
            controlFlowRuleArtifact = new ControlFlowRuleArtifact("*", controlFlowRuleLocation, controlFlowRuleLocation, adfControllerArtifact, this.getID());
        } else if (fromActivityElem != null) {
            ResourceLocation fromActivityElemLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)fromActivityElem);
            controlFlowRuleArtifact = new ControlFlowRuleArtifact(fromActivityID, controlFlowRuleLocation, fromActivityElemLocation, adfControllerArtifact, this.getID());
            IArtifact activityArtifact = this.activityToArtifactMap.get(fromActivityID);
            AdfTaskflowActivityIDArtifactLocator locator = new AdfTaskflowActivityIDArtifactLocator(activityArtifact);
            AdfTaskflowActivityIDArtifactReference activityReference = new AdfTaskflowActivityIDArtifactReference(locator, (IArtifact)controlFlowRuleArtifact, fromActivityElemLocation, fromActivityID, this.getID());
            this.getCollectionContext().addReferencedArtifact((IArtifact)controlFlowRuleArtifact, (IArtifactReference)activityReference, false, (byte)0);
        }
        this.getCollectionContext().addArtifact((IArtifact)controlFlowRuleArtifact, this.getID());
        NodeList controlFlowCaseNodeList = controlFlowRuleElement.getElementsByTagName(CONTROL_FLOW_CASE_EL_NAME);
        int i = 0;
        while (i < controlFlowCaseNodeList.getLength()) {
            this.collectControlFlowCase(controlFlowRuleArtifact, fromActivityElem, (IDOMElement)controlFlowCaseNodeList.item(i));
            ++i;
        }
    }

    private void collectControlFlowCase(ControlFlowRuleArtifact controlFlowRuleArtifact, IDOMElement fromActivityElem, IDOMElement controlFlowCaseElement) {
        NodeList toActivityIDs;
        ControlFlowCaseOutcomeArtifact outcomeArtifact;
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        NodeList fromOutcomeNodes = controlFlowCaseElement.getElementsByTagName(FROM_OUTCOME_EL_NAME);
        IDOMElement fromOutcomeElement = null;
        String outcome = null;
        if (fromOutcomeNodes.getLength() > 0 && fromOutcomeNodes.item(0) instanceof IDOMElement) {
            fromOutcomeElement = (IDOMElement)fromOutcomeNodes.item(0);
            outcome = this.getCollectionContext().getNodeText((Node)fromOutcomeElement);
        }
        if ((outcomeArtifact = controlFlowRuleArtifact.getNavigationOutcome(outcome)) == null && outcome != null) {
            ResourceLocation controlFlowCaseLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)controlFlowCaseElement);
            ResourceLocation fromOutcomeLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)fromOutcomeElement);
            outcomeArtifact = new ControlFlowCaseOutcomeArtifact(outcome, controlFlowRuleArtifact, fromOutcomeLocation, controlFlowCaseLocation, this.getID());
            controlFlowRuleArtifact.addNavigationCase(outcomeArtifact);
            this.getCollectionContext().addArtifact((IArtifact)outcomeArtifact, this.getID());
        }
        if ((toActivityIDs = controlFlowCaseElement.getElementsByTagName(TO_ACTIVITY_ID_EL_NAME)).getLength() > 0 && toActivityIDs.item(0) instanceof IDOMElement) {
            IDOMElement toActivityIDElement = (IDOMElement)toActivityIDs.item(0);
            ResourceLocation toActivityLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)toActivityIDElement);
            ResourceLocation controlFlowCaseLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)controlFlowCaseElement);
            String activityName = this.getCollectionContext().getNodeText((Node)toActivityIDElement);
            IArtifact toActivityArtifact = this.activityToArtifactMap.get(activityName);
            AbstractVirtualArtifact artifact = outcomeArtifact != null ? outcomeArtifact : controlFlowRuleArtifact;
            AdfTaskflowActivityIDArtifactReference activityReference = new AdfTaskflowActivityIDArtifactReference(ArtifactOwnershipReference.getLocator((IArtifact)toActivityArtifact), (IArtifact)artifact, toActivityLocation, activityName, this.getID());
            this.getCollectionContext().addReferencedArtifact((IArtifact)artifact, (IArtifactReference)activityReference, false, (byte)0);
            ADFTaskFlowActivityArtifact taskFlowActivityArtifact = new ADFTaskFlowActivityArtifact((IArtifact)(outcomeArtifact != null ? outcomeArtifact : controlFlowRuleArtifact), toActivityLocation, controlFlowCaseLocation, activityName, this.getID());
            this.getCollectionContext().addArtifact((IArtifact)taskFlowActivityArtifact, this.getID());
        }
    }

    private void collectELReferencesInElem(IDOMElement parent, IArtifact artifact, IFile pageDefFile) {
        NodeList childNodeList = parent.getChildNodes();
        IFile adfcConfigFile = (IFile)this.getResourceContext().getResource();
        if (childNodeList != null) {
            int i = 0;
            int len = childNodeList.getLength();
            while (i < len) {
                Node child = childNodeList.item(i);
                if (child instanceof IDOMElement) {
                    IDOMElement childElem = (IDOMElement)child;
                    String textContent = childElem.getTextContent();
                    if (textContent.length() > 0 && this.isELExpression(textContent)) {
                        ResourceLocation elemLocation = this.getCollectionContext().getLocationOfNode((IResource)adfcConfigFile, (IDOMNode)childElem);
                        String elexpr = textContent;
                        if (elexpr.startsWith("\"")) {
                            elexpr = elexpr.substring(1);
                        }
                        if (elexpr.endsWith("\"")) {
                            elexpr = elexpr.substring(0, elexpr.length() - 1);
                        }
                        int startEndOffset = childElem.getStartEndOffset();
                        String bindingsElExprPrefix = "#{bindings.";
                        if (elexpr.indexOf(bindingsElExprPrefix) != -1) {
                            int index;
                            String remainingStr;
                            List parts;
                            ADFUtil.PageDefIdInfoForEL pageDefIdsInfo = ADFUtil.getIdsFromPagedef(pageDefFile, elexpr);
                            boolean foundId = false;
                            if (pageDefIdsInfo != null) {
                                for (String bindingId : pageDefIdsInfo.bindingIds) {
                                    int index2 = textContent.indexOf(bindingId);
                                    ResourceLocation bindingIdLocation = null;
                                    if (index2 != -1 && elemLocation != null) {
                                        long newOffset = startEndOffset + index2;
                                        Range newRange = new Range(newOffset, (long)bindingId.length());
                                        bindingIdLocation = new ResourceLocation(elemLocation.getResource(), newRange);
                                    }
                                    ADFMPageDefBindingArtifactLocator artifactLocator = new ADFMPageDefBindingArtifactLocator(bindingId, pageDefFile);
                                    ADFMPageDefBindingArtifactReference reference = new ADFMPageDefBindingArtifactReference(bindingId, pageDefFile, artifactLocator, artifact, bindingIdLocation, this.getID());
                                    this.getCollectionContext().addReferencedArtifact(artifact, (IArtifactReference)reference, false, (byte)0);
                                    foundId = true;
                                }
                                IObjectLocator locator = ADFPlugin.getObjectLocator();
                                if (locator == null) {
                                    return;
                                }
                                IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)pageDefFile);
                                for (String executableId : pageDefIdsInfo.executableIds) {
                                    AbstractArtifactReference reference;
                                    Object artifactLocator;
                                    List executables;
                                    IPageDefinition pageDefinition;
                                    int index3 = textContent.indexOf(executableId);
                                    ResourceLocation executableIdLocation = null;
                                    if (index3 != -1 && elemLocation != null) {
                                        long newOffset = startEndOffset + index3;
                                        Range newRange = new Range(newOffset, (long)executableId.length());
                                        executableIdLocation = new ResourceLocation(elemLocation.getResource(), newRange);
                                    }
                                    IExecutable executable = null;
                                    if (earProject != null && (pageDefinition = locator.getPageDefinition(earProject, pageDefFile)) != null && (executables = pageDefinition.getExecutables()) != null) {
                                        for (IExecutable exec : executables) {
                                            if (!executableId.equals(exec.getId())) continue;
                                            executable = exec;
                                            break;
                                        }
                                    }
                                    if (executable != null && executable.getTypeDescriptor().getLabel().equals("searchRegion")) {
                                        artifactLocator = new ADFMPageDefSearchRegionArtifactLocator(executableId, pageDefFile);
                                        reference = new ADFMPageDefSearchRegionArtifactReference(executableId, pageDefFile, (IArtifactLocator)artifactLocator, artifact, executableIdLocation, this.getID());
                                        this.getCollectionContext().addReferencedArtifact(artifact, (IArtifactReference)reference, false, (byte)0);
                                    } else {
                                        artifactLocator = new ADFMPageDefIteratorIdArtifactLocator(executableId, pageDefFile);
                                        reference = new ADFMPageDefIteratorIdArtifactReference(executableId, pageDefFile, (IArtifactLocator)artifactLocator, artifact, executableIdLocation, this.getID());
                                        this.getCollectionContext().addReferencedArtifact(artifact, (IArtifactReference)reference, false, (byte)0);
                                    }
                                    foundId = true;
                                }
                            }
                            if (!foundId && (parts = StringUtil.split((String)(remainingStr = elexpr.substring((index = elexpr.indexOf(bindingsElExprPrefix)) + bindingsElExprPrefix.length())), (char)'.')) != null && parts.size() > 0) {
                                String bindingId = (String)parts.get(0);
                                ResourceLocation bindingIdLocation = null;
                                index = textContent.indexOf(bindingId);
                                if (index != -1 && elemLocation != null) {
                                    long newOffset = startEndOffset + index;
                                    Range newRange = new Range(newOffset, (long)bindingId.length());
                                    bindingIdLocation = new ResourceLocation(elemLocation.getResource(), newRange);
                                }
                                ADFMPageDefBindingArtifactLocator locator = new ADFMPageDefBindingArtifactLocator(bindingId, pageDefFile);
                                ADFMPageDefBindingArtifactReference reference = new ADFMPageDefBindingArtifactReference(bindingId, pageDefFile, locator, artifact, bindingIdLocation, this.getID());
                                this.getCollectionContext().addReferencedArtifact(artifact, (IArtifactReference)reference, false, (byte)0);
                            }
                        } else {
                            AdfCollectionHelper.collectReferenceToManagedBeanVariableAndType(artifact, adfcConfigFile, this.getCollectionContext(), "adf.controller", (IDOMNode)childElem, elexpr);
                        }
                    }
                    this.collectELReferencesInElem(childElem, artifact, pageDefFile);
                }
                ++i;
            }
        }
    }

    private boolean isELExpression(String value) {
        ELExpression expression = this.parser.getELExpression(value);
        if (expression != null) {
            String elText = expression.getElText();
            return elText != null && !"".equals(elText);
        }
        return false;
    }
}

