/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractTagCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.collection.FacesTagCollector;
import oracle.eclipse.tools.xml.model.emfbinding.dom.FeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class ADFRichFacesTagCollector
extends FacesTagCollector {
    private static final Set<SubTypes> ALL_INTERESTING_TYPES;

    static {
        LinkedHashSet<SubTypes> types = new LinkedHashSet<SubTypes>(2, 1.0f);
        types.add(SubTypes.ADF_ACTION_SUBTYPE);
        types.add(SubTypes.ADF_URI_SUBTYPE);
        ALL_INTERESTING_TYPES = types;
    }

    public ADFRichFacesTagCollector(INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IStructuredDocumentCollectionContext collectionContext, AbstractTagCollector.AbstractTagContextUriResolver contextUriResolver, StructuredDocumentResourceLocationFactory locationFactory, IFile baseFile, String collectorID) {
        super(namespaceContext, mdContext, collectionContext, contextUriResolver, locationFactory, baseFile, collectorID);
    }

    public void collectArtifacts(IDOMElement element, IFile targetFile, IProgressMonitor monitor) throws ArtifactException {
        ResourceArtifact fileArtifact = this.getCollectionContext().ensureResourceArtifact((IResource)targetFile);
        List featuresWithSubtype = this.getTagMetadata().findFeaturesWithSubtype((Node)element, ALL_INTERESTING_TYPES);
        for (IFeatureData featureData : featuresWithSubtype) {
            this.collectAttributes(targetFile, element, featureData, fileArtifact);
            this.collectUri(targetFile, element, (IFeatureData<Object>)featureData, (IArtifact)fileArtifact);
        }
    }

    protected boolean isAction(SubTypes subType) {
        return SubTypes.ADF_ACTION_SUBTYPE.equals((Object)subType) || super.isAction(subType);
    }

    private final void collectUri(IFile referringResource, IDOMElement docElem, IFeatureData<Object> tagAttr, IArtifact artifact) {
        for (FeatureData.ValueHolder valueHolder : tagAttr.getValues()) {
            SubTypes subType;
            Node valueSourceNode;
            Object value = valueHolder.getValue();
            if (!(value instanceof String) || !((valueSourceNode = valueHolder.getNode()) instanceof IDOMNode) || !SubTypes.ADF_URI_SUBTYPE.equals((Object)(subType = TleiAccess.INSTANCE.getSubtype(this.getMetadataContext(), (IStructuredModel)((IDOMNode)valueSourceNode).getModel(), tagAttr.getFeature())))) continue;
            this.collectReferencedResources(referringResource, docElem, (IDOMNode)valueSourceNode, (String)value, artifact);
        }
    }

    private void collectReferencedResources(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri, IArtifact referantArtifact) {
        ResourceLocation location = this.createLocation(referringNode, this.getLocationFactory());
        if (location == null) {
            return;
        }
        IPath resolvedPath = this.getTagContextUriResolver().resolve(referringResource, owningElement, referringNode, originalUri);
        if (resolvedPath.segmentCount() > 1) {
            IFile referencedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedPath);
            this.getCollectionContext().addReferencedResource(referantArtifact, (IResource)referencedFile, true, location, (byte)0, this.getID());
        }
    }
}

