/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMApplicationArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFModelConfigurationArtifact;
import oracle.eclipse.tools.adf.view.dependency.collection.ADFMApplicationArtifactLocator;
import oracle.eclipse.tools.application.common.services.collection.AbstractXpathCollector;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class ADFModelConfigurationCollector
extends AbstractXpathCollector {
    private static final String ADF_MODEL_NAMESPACE = "http://xmlns.oracle.com/adfm/metainf";
    public static final String ID = "adfm.model";

    protected boolean collectDerivedResources() {
        return false;
    }

    protected void collectDocument(IDOMDocument document) {
        NodeList dataControlNodes;
        Assert.isLegal((document != null ? 1 : 0) != 0, (String)"Document must not be null");
        Assert.isNotNull((Object)this.getCollectionContext(), (String)"Collection context is null");
        Assert.isNotNull((Object)this.getResourceContext(), (String)"Resource context is null");
        IFile adfmModelFile = (IFile)this.getResourceContext().getResource();
        ResourceLocation loc = new ResourceLocation((IResource)adfmModelFile, null);
        ADFModelConfigurationArtifact modelArtifact = new ADFModelConfigurationArtifact((IArtifact)this.getCollectionContext().ensureResourceArtifact((IResource)adfmModelFile), loc, loc, ID);
        this.getCollectionContext().addArtifact((IArtifact)modelArtifact, ID);
        NodeList dataBindingNodes = this.getNodes((IDOMNode)document, "//ns:DataBindingRegistry");
        if (dataBindingNodes != null) {
            IProject project = this.getCollectionContext().getProject();
            int i = 0;
            while (i < dataBindingNodes.getLength()) {
                IDOMElement dataBindingElem;
                Attr pathAttrNode;
                if (dataBindingNodes.item(i) instanceof IDOMElement && (pathAttrNode = (dataBindingElem = (IDOMElement)dataBindingNodes.item(i)).getAttributeNode("path")) instanceof IDOMAttr) {
                    ResourceLocation referenceLocation = this.getCollectionContext().getLocationOfNode((IResource)adfmModelFile, (IDOMNode)((IDOMAttr)pathAttrNode));
                    String pathName = ((IDOMAttr)pathAttrNode).getValue();
                    if (!pathName.isEmpty() && pathName.charAt(0) != '/') {
                        pathName = String.valueOf('/') + pathName;
                    }
                    ADFMApplicationArtifactLocator locator = new ADFMApplicationArtifactLocator(pathName, project);
                    ADFMApplicationArtifactReference ref = new ADFMApplicationArtifactReference(pathName, project, locator, (IArtifact)modelArtifact, referenceLocation, ID);
                    this.getCollectionContext().addReferencedArtifact((IArtifact)modelArtifact, (IArtifactReference)ref, true, (byte)0);
                }
                ++i;
            }
        }
        if ((dataControlNodes = this.getNodes((IDOMNode)document, "//ns:DataControlRegistry")) != null) {
            IProject project = this.getCollectionContext().getProject();
            int i = 0;
            while (i < dataControlNodes.getLength()) {
                IDOMElement dataControlElem;
                Attr pathAttrNode;
                if (dataControlNodes.item(i) instanceof IDOMElement && (pathAttrNode = (dataControlElem = (IDOMElement)dataControlNodes.item(i)).getAttributeNode("path")) instanceof IDOMAttr) {
                    ResourceLocation referenceLocation = this.getCollectionContext().getLocationOfNode((IResource)adfmModelFile, (IDOMNode)((IDOMAttr)pathAttrNode));
                    String pathName = ((IDOMAttr)pathAttrNode).getValue();
                    ADFMDataControlArtifactLocator locator = new ADFMDataControlArtifactLocator(pathName, project);
                    ADFMDataControlArtifactReference ref = new ADFMDataControlArtifactReference(pathName, project, locator, (IArtifact)modelArtifact, referenceLocation, ID);
                    this.getCollectionContext().addReferencedArtifact((IArtifact)modelArtifact, (IArtifactReference)ref, true, (byte)0);
                }
                ++i;
            }
        }
    }

    public String getID() {
        return ID;
    }

    protected NamespaceContext getNamespaceContext() {
        return new MapNamespaceContext("ns", ADF_MODEL_NAMESPACE);
    }

    protected Set<String> getDocumentContentTypes() {
        return Collections.singleton(DTRTContentType.ADF_REGISTRY.getId());
    }
}

