/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ADFMPageDefinitionArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String pathName;
    private final IProject project;
    private volatile int hashCode = 0;

    public ADFMPageDefinitionArtifactLocator(String pathName, IProject project) {
        this.pathName = pathName;
        this.project = project;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        StringBuilder path = new StringBuilder("adfmsrc/");
        path.append(this.pathName.replace('.', '/'));
        path.append(".xml");
        IResource pdFile = this.project.findMember(path.toString());
        if (pdFile != null) {
            ResourceArtifact ra = model.ensureResourceArtifact(pdFile);
            return model.queryArtifactsByOwnerNameAndType((IArtifact)ra, this.pathName, "adf-pagedef");
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ADFMPageDefinitionArtifactLocator) {
            ADFMPageDefinitionArtifactLocator otherLocator = (ADFMPageDefinitionArtifactLocator)obj;
            if (this.project == null && otherLocator.project == null && this.pathName == null && otherLocator.pathName == null) {
                return true;
            }
            return otherLocator.project != null && otherLocator.project.equals((Object)this.project) && otherLocator.pathName != null && otherLocator.pathName.equals(this.pathName);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.project);
            hcu.hash((Object)this.pathName);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.pathName);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "pathName", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }
}

