/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDCCreatableTypeArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDCEJBDefinitionArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifact;
import oracle.eclipse.tools.application.common.services.collection.AbstractXpathCollector;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFMDataControlFileCollector
extends AbstractXpathCollector {
    private static final String ADF_DATA_CONTROL_NAMESPACE = "http://xmlns.oracle.com/adfm/configuration";
    public static final String ID = "adfm.datacontrol";

    protected boolean collectDerivedResources() {
        return false;
    }

    protected void collectDocument(IDOMDocument document) {
        Assert.isLegal((document != null ? 1 : 0) != 0, (String)"Document must not be null");
        Assert.isNotNull((Object)this.getCollectionContext(), (String)"Collection context is null");
        Assert.isNotNull((Object)this.getResourceContext(), (String)"Resource context is null");
        IFile adfmDataControlFile = (IFile)this.getResourceContext().getResource();
        ResourceLocation loc = new ResourceLocation((IResource)adfmDataControlFile, null);
        String pathName = adfmDataControlFile.getProjectRelativePath().removeFirstSegments(1).toString();
        ADFMDataControlArtifact dataControlArtifact = new ADFMDataControlArtifact(pathName, (IArtifact)this.getCollectionContext().ensureResourceArtifact((IResource)adfmDataControlFile), loc, loc, ID);
        this.getCollectionContext().addArtifact((IArtifact)dataControlArtifact, ID);
        NodeList dataControlNodes = this.getNodes((IDOMNode)document, "//nsdc:AdapterDataControl");
        if (dataControlNodes != null) {
            int i = 0;
            int length = dataControlNodes.getLength();
            while (i < length) {
                IDOMElement adapterDCElement = (IDOMElement)dataControlNodes.item(i);
                IDOMAttr idAttrNode = (IDOMAttr)adapterDCElement.getAttributeNode("id");
                String parentPath = ADFMDataControlFileCollector.getPkgResourceParentPath(adfmDataControlFile.getParent());
                String id = idAttrNode.getValue();
                if (id != null && !id.equals("")) {
                    ResourceLocation idLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)idAttrNode);
                    ADFMAdapterDataControlArtifact adapterDataControlArtifact = new ADFMAdapterDataControlArtifact(String.valueOf(parentPath) + "." + id, (IArtifact)dataControlArtifact, idLoc, idLoc, ID);
                    this.getCollectionContext().addArtifact((IArtifact)adapterDataControlArtifact, ID);
                    this.collectReferencesToJavaTypes(document, adapterDCElement, adapterDataControlArtifact);
                }
                ++i;
            }
        }
    }

    public String getID() {
        return ID;
    }

    protected NamespaceContext getNamespaceContext() {
        MapNamespaceContext namespaceContext = new MapNamespaceContext("ns", ADF_DATA_CONTROL_NAMESPACE);
        namespaceContext.put("nsdc", "http://xmlns.oracle.com/adfm/datacontrol");
        return namespaceContext;
    }

    protected Set<String> getDocumentContentTypes() {
        return Collections.singleton(DTRTContentType.CONFIGURATION.getId());
    }

    private void collectReferencesToJavaTypes(IDOMDocument document, IDOMElement adapterDCElement, ADFMAdapterDataControlArtifact adapterDataControlArtifact) {
        NodeList creatableTypeNodes;
        IDOMAttr beanClassAttr;
        IFile adfmDataControlFile = (IFile)this.getResourceContext().getResource();
        IDOMAttr definitionAttr = (IDOMAttr)adapterDCElement.getAttributeNode("Definition");
        if (definitionAttr != null) {
            String defnName = definitionAttr.getValue();
            ResourceLocation defnLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)definitionAttr);
            this.getCollectionContext().addTypeReference((IArtifact)adapterDataControlArtifact, adfmDataControlFile.getProject(), defnName, defnLoc, false, ID);
        }
        if ((beanClassAttr = (IDOMAttr)adapterDCElement.getAttributeNode("BeanClass")) != null) {
            String beanClassName = beanClassAttr.getValue();
            ResourceLocation beanClassLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)beanClassAttr);
            this.getCollectionContext().addTypeReference((IArtifact)adapterDataControlArtifact, adfmDataControlFile.getProject(), beanClassName, beanClassLoc, false, ID);
        }
        if ((creatableTypeNodes = this.getNodes((IDOMNode)document, "//nsdc:CreatableTypes")) != null && creatableTypeNodes.getLength() > 0) {
            IDOMElement sourceElement;
            NodeList ejbdefinitionNodes;
            NodeList sourceNodes;
            IDOMElement creatableTypeElement = (IDOMElement)creatableTypeNodes.item(0);
            ResourceLocation creatableTypeLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)creatableTypeElement);
            ADFMDCCreatableTypeArtifact creatableTypeArtifact = new ADFMDCCreatableTypeArtifact("adf-datacontrol-creatabletype", (IArtifact)adapterDataControlArtifact, creatableTypeLoc, creatableTypeLoc, ID);
            this.getCollectionContext().addArtifact((IArtifact)creatableTypeArtifact, ID);
            NodeList typeInfoNodes = this.getNodes((IDOMNode)document, "//nsdc:TypeInfo");
            if (typeInfoNodes != null) {
                int i = 0;
                int length = typeInfoNodes.getLength();
                while (i < length) {
                    IDOMElement typeInfoElement = (IDOMElement)typeInfoNodes.item(i);
                    IDOMAttr fullNameAttr = (IDOMAttr)typeInfoElement.getAttributeNode("FullName");
                    String typeClass = fullNameAttr.getValue();
                    if (typeClass != null) {
                        ResourceLocation beanClassLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)fullNameAttr);
                        this.getCollectionContext().addTypeReference((IArtifact)creatableTypeArtifact, adfmDataControlFile.getProject(), typeClass, beanClassLoc, false, ID);
                    }
                    ++i;
                }
            }
            if ((sourceNodes = this.getNodes((IDOMNode)document, "//nsdc:Source")) != null && sourceNodes.getLength() > 0 && (ejbdefinitionNodes = (sourceElement = (IDOMElement)sourceNodes.item(0)).getChildNodes()) != null) {
                int i = 0;
                int length = ejbdefinitionNodes.getLength();
                while (i < length) {
                    IDOMElement ejbDefnNode;
                    Node child = ejbdefinitionNodes.item(i);
                    if (child instanceof IDOMElement && (ejbDefnNode = (IDOMElement)child) != null && ejbDefnNode.getLocalName().equals("ejb-definition")) {
                        IDOMAttr ejbNameAttr = (IDOMAttr)ejbDefnNode.getAttributeNode("ejb-name");
                        ResourceLocation ejbNameLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)ejbNameAttr);
                        String ejbName = ejbNameAttr.getValue();
                        ADFMDCEJBDefinitionArtifact ejbDefnArtifact = new ADFMDCEJBDefinitionArtifact(ejbName, (IArtifact)adapterDataControlArtifact, ejbNameLoc, ejbNameLoc, ID);
                        this.getCollectionContext().addArtifact((IArtifact)ejbDefnArtifact, ID);
                        IDOMAttr ejbIntfAttr = (IDOMAttr)ejbDefnNode.getAttributeNode("ejb-business-interface");
                        if (ejbIntfAttr != null) {
                            String ejbIntfClass = ejbIntfAttr.getValue();
                            ResourceLocation ejbIntfLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmDataControlFile, (IDOMNode)ejbIntfAttr);
                            this.getCollectionContext().addTypeReference((IArtifact)ejbDefnArtifact, adfmDataControlFile.getProject(), ejbIntfClass, ejbIntfLoc, false, ID);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    static String getPkgResourceParentPath(IContainer container) {
        IPath path = container.getProjectRelativePath();
        IProject project = container.getProject();
        IFolder folder = project.getFolder(path.segment(0));
        IJavaElement javaElem = JavaCore.create((IFolder)folder);
        if (!(javaElem instanceof IPackageFragmentRoot)) {
            return null;
        }
        path = path.removeFirstSegments(1);
        return path.toString().replace('/', '.');
    }
}

