/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFControllerArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMApplicationArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlUsageIdArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefinitionArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfTaskflowPageDefActivityIDArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfTaskflowPagedefActivityIDArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.collection.ADFControllerArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.collection.ADFMPageDefinitionArtifactLocator;
import oracle.eclipse.tools.application.common.services.collection.AbstractXpathCollector;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFMApplicationCollector
extends AbstractXpathCollector {
    private static final String ADF_APPLICATION_NAMESPACE = "http://xmlns.oracle.com/adfm/application";
    public static final String ID = "adfm.application";

    protected boolean collectDerivedResources() {
        return false;
    }

    protected void collectDocument(IDOMDocument document) {
        NodeList dcNodeList;
        int i;
        Assert.isLegal((document != null ? 1 : 0) != 0, (String)"Document must not be null");
        Assert.isNotNull((Object)this.getCollectionContext(), (String)"Collection context is null");
        Assert.isNotNull((Object)this.getResourceContext(), (String)"Resource context is null");
        this.getResourceContext().resetCollection(ID);
        NodeList pageDefNodes = this.getNodes((IDOMNode)document, "//ns:pageDefinitionUsages/ns:page");
        HashMap<String, IDOMElement> pageDefinitionUsageMap = new HashMap<String, IDOMElement>(pageDefNodes.getLength(), 1.0f);
        if (pageDefNodes != null) {
            int i2 = 0;
            while (i2 < pageDefNodes.getLength()) {
                String id;
                Node node = pageDefNodes.item(i2);
                if (node instanceof IDOMElement && (id = ((IDOMElement)node).getAttribute("id")) != null && !id.isEmpty()) {
                    pageDefinitionUsageMap.put(id, (IDOMElement)node);
                }
                ++i2;
            }
        }
        IFile adfmApplicationFile = (IFile)this.getResourceContext().getResource();
        ResourceLocation loc = new ResourceLocation((IResource)adfmApplicationFile, null);
        String pathName = adfmApplicationFile.getProjectRelativePath().removeFirstSegments(1).toString();
        if (pathName.charAt(0) != '/') {
            pathName = String.valueOf('/') + pathName;
        }
        ADFMApplicationArtifact appArtifact = new ADFMApplicationArtifact(pathName, (IArtifact)this.getCollectionContext().ensureResourceArtifact((IResource)adfmApplicationFile), loc, loc, ID);
        this.getCollectionContext().addArtifact((IArtifact)appArtifact, ID);
        NodeList pageMapNodes = this.getNodes((IDOMNode)document, "//ns:pageMap/ns:page");
        if (pageMapNodes != null) {
            IContainer webContentRoot = this.getWebContentResource();
            i = 0;
            while (i < pageMapNodes.getLength()) {
                IDOMElement pageElem;
                if (pageMapNodes.item(i) instanceof IDOMElement && (pageElem = (IDOMElement)pageMapNodes.item(i)) != null) {
                    String id = pageElem.getAttribute("usageId");
                    IDOMElement pageDefElem = (IDOMElement)pageDefinitionUsageMap.get(id);
                    this.collectPage(webContentRoot.getProjectRelativePath(), appArtifact, pageElem, pageDefElem);
                }
                ++i;
            }
        }
        if ((dcNodeList = this.getNodes((IDOMNode)document, "//ns:dataControlUsages/ns:dc")) != null) {
            i = 0;
            int len = dcNodeList.getLength();
            while (i < len) {
                IDOMElement dcNode = (IDOMElement)dcNodeList.item(i);
                if (dcNode != null) {
                    String id = dcNode.getAttribute("id");
                    IDOMAttr idAttr = (IDOMAttr)dcNode.getAttributeNode("id");
                    loc = this.getCollectionContext().getLocationOfNode((IResource)adfmApplicationFile, (IDOMNode)idAttr);
                    ADFMDataControlUsageIdArtifact dataControlUsageIdArtifact = new ADFMDataControlUsageIdArtifact(id, (IArtifact)appArtifact, loc, loc, ID);
                    this.getCollectionContext().addArtifact((IArtifact)dataControlUsageIdArtifact, ID);
                    IDOMAttr pathAttr = (IDOMAttr)dcNode.getAttributeNode("path");
                    ResourceLocation refLoc = this.getCollectionContext().getLocationOfNode((IResource)adfmApplicationFile, (IDOMNode)pathAttr);
                    String path = dcNode.getAttribute("path");
                    ADFMAdapterDataControlArtifactLocator locator = new ADFMAdapterDataControlArtifactLocator(path, adfmApplicationFile.getProject());
                    ADFMAdapterDataControlArtifactReference reference = new ADFMAdapterDataControlArtifactReference(path, adfmApplicationFile.getProject(), locator, (IArtifact)dataControlUsageIdArtifact, refLoc, ID);
                    this.getCollectionContext().addReferencedArtifact((IArtifact)dataControlUsageIdArtifact, (IArtifactReference)reference, true, (byte)0);
                }
                ++i;
            }
        }
    }

    private IContainer getWebContentResource() {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getCollectionContext().getProject());
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder();
        }
        return null;
    }

    private IResource getWebResource(IPath webContentPath, IDOMAttr pathAttribute) {
        IPath pagePath = webContentPath.append(pathAttribute.getValue());
        IResource resource = this.getCollectionContext().getProject().findMember(pagePath);
        return resource != null ? resource : this.getCollectionContext().getProject().getFile(pagePath);
    }

    private void collectPage(IPath webContentPath, ADFMApplicationArtifact adfmAppArtifact, IDOMElement pageElem, IDOMElement pageDefElem) {
        IFile adfFile = (IFile)this.getResourceContext().getResource();
        if (pageElem != null) {
            Attr pageDefPathAttr;
            Attr pagePathAttr = pageElem.getAttributeNode("path");
            IFile pageFile = null;
            if (pagePathAttr instanceof IDOMAttr) {
                String pagePath = ((IDOMAttr)pagePathAttr).getValue();
                if (pagePath != null && pagePath.indexOf("#") != -1) {
                    this.addReferenceToTaskflow((IDOMAttr)pagePathAttr, (IArtifact)adfmAppArtifact);
                } else {
                    IResource pageRes = this.getWebResource(webContentPath, (IDOMAttr)pagePathAttr);
                    if (pageRes instanceof IFile) {
                        pageFile = (IFile)pageRes;
                        ResourceLocation pagePathAttrLoc = this.getCollectionContext().getLocationOfNode((IResource)adfFile, (IDOMNode)pagePathAttr);
                        this.getCollectionContext().addReferencedResource((IArtifact)adfmAppArtifact, (IResource)pageFile, true, pagePathAttrLoc, (byte)0, ID);
                    }
                }
            }
            if (pageDefElem != null && (pageDefPathAttr = pageDefElem.getAttributeNode("path")) instanceof IDOMAttr) {
                ResourceLocation pageDefPathAttrLoc = this.getCollectionContext().getLocationOfNode((IResource)adfFile, (IDOMNode)pageDefPathAttr);
                String pathName = ((IDOMAttr)pageDefPathAttr).getValue();
                IProject project = this.getCollectionContext().getProject();
                ADFMPageDefinitionArtifactLocator loc = new ADFMPageDefinitionArtifactLocator(pathName, project);
                ADFMPageDefinitionArtifactReference reference = new ADFMPageDefinitionArtifactReference(pathName, project, loc, (IArtifact)adfmAppArtifact, pageDefPathAttrLoc, pageFile, ID);
                this.getCollectionContext().addReferencedArtifact((IArtifact)adfmAppArtifact, (IArtifactReference)reference, true, (byte)0);
            }
        }
    }

    public String getID() {
        return ID;
    }

    protected NamespaceContext getNamespaceContext() {
        return new MapNamespaceContext("ns", ADF_APPLICATION_NAMESPACE);
    }

    protected Set<String> getDocumentContentTypes() {
        return Collections.singleton(DTRTContentType.APPLICATION.getId());
    }

    private void addReferenceToTaskflow(IDOMAttr pagePathAttr, IArtifact adfmAppArtifact) {
        ResourceLocation taskflowIdLocation;
        String taskFlowIdPath = pagePathAttr.getValue();
        IProject project = this.getCollectionContext().getProject();
        IFile adfmApplicationFile = (IFile)this.getResourceContext().getResource();
        ResourceLocation activityIdLocation = taskflowIdLocation = this.getCollectionContext().getLocationOfNode((IResource)adfmApplicationFile, (IDOMNode)pagePathAttr);
        boolean isUnboundedTaskflow = taskFlowIdPath.startsWith("PageFlow#");
        int indexOfActivity = isUnboundedTaskflow ? taskFlowIdPath.indexOf("#") : taskFlowIdPath.lastIndexOf("@");
        String taskFlowId = taskFlowIdPath;
        String activityId = null;
        if (!isUnboundedTaskflow) {
            if (indexOfActivity != -1 && taskFlowIdPath.length() > indexOfActivity + 1) {
                activityId = taskFlowIdPath.substring(indexOfActivity + 1);
                taskFlowId = taskFlowId.substring(0, indexOfActivity);
                int remainingLen = activityId.length();
                Range range = taskflowIdLocation.getRange();
                taskflowIdLocation = new ResourceLocation(taskflowIdLocation.getResource(), new Range(range.getOffset(), range.getLength() - (long)remainingLen - 2L));
                activityIdLocation = new ResourceLocation(taskflowIdLocation.getResource(), new Range(range.getEndOffset() - (long)activityId.length() - 1L, (long)activityId.length()));
            }
            ADFControllerArtifactLocator locator = new ADFControllerArtifactLocator(taskFlowId, project);
            ADFControllerArtifactReference reference = new ADFControllerArtifactReference(taskFlowId, "", project, locator, adfmAppArtifact, taskflowIdLocation, ID, true, false);
            this.getCollectionContext().addReferencedArtifact(adfmAppArtifact, (IArtifactReference)reference, true, (byte)0);
        } else if (indexOfActivity != -1 && taskFlowIdPath.length() > indexOfActivity + 1) {
            activityId = taskFlowIdPath.substring(indexOfActivity + 1);
            Range range = taskflowIdLocation.getRange();
            activityIdLocation = new ResourceLocation(taskflowIdLocation.getResource(), new Range(range.getEndOffset() - (long)activityId.length() - 1L, (long)activityId.length()));
        }
        AdfTaskflowPagedefActivityIDArtifactLocator activityLocator = new AdfTaskflowPagedefActivityIDArtifactLocator(taskFlowIdPath, project);
        AdfTaskflowPageDefActivityIDArtifactReference activityReference = new AdfTaskflowPageDefActivityIDArtifactReference(taskFlowIdPath, project, activityLocator, adfmAppArtifact, activityIdLocation, ID);
        this.getCollectionContext().addReferencedArtifact(adfmAppArtifact, (IArtifactReference)activityReference, true, (byte)0);
    }
}

