/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ControlFlowRuleArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ControlFlowCaseArtifactLocator
implements IArtifactLocator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String fromActivityId;
    private final String navCaseName;
    private final IFile referencingFile;
    private volatile transient int hashCode = 0;

    public ControlFlowCaseArtifactLocator(String fromActivityId, String navCaseName, IFile referencingFile) {
        this(fromActivityId, navCaseName, referencingFile, null);
    }

    public ControlFlowCaseArtifactLocator(String fromActivityId, String navCaseName, IFile referencingFile, IFile sourceFile) {
        this.navCaseName = navCaseName;
        this.referencingFile = referencingFile;
        this.fromActivityId = fromActivityId;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        Set navRuleArtifacts = model.queryArtifactsByTypes(Collections.singleton("adf-control-flow-rule"), this.referencingFile.getProject());
        ControlFlowRuleArtifact owner = null;
        for (IArtifact na : navRuleArtifacts) {
            if (!na.getName().equals(this.fromActivityId)) continue;
            owner = (ControlFlowRuleArtifact)na;
        }
        if (owner != null) {
            return owner.getNavigationOutcome(this.navCaseName);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof ControlFlowCaseArtifactLocator) {
            ControlFlowCaseArtifactLocator otherNCAL = (ControlFlowCaseArtifactLocator)other;
            if (otherNCAL.referencingFile.equals((Object)this.referencingFile)) {
                return this.navCaseName == null ? otherNCAL.navCaseName == null : this.navCaseName.equals(otherNCAL.navCaseName);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash((Object)this.navCaseName);
            hcu.hash((Object)this.referencingFile);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.navCaseName);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.referencingFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "navCaseName", String.class);
        su.readFinalFileFromStream((Object)this, "referencingFile");
    }
}

