/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFPageDefinitionArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ADFMPageDefinitionArtifactReference
extends AbstractArtifactReference {
    private static final long serialVersionUID = 1L;
    private volatile transient int hashCode = 0;
    private final String name;
    private final IProject project;
    private final IFile pageFile;

    public ADFMPageDefinitionArtifactReference(String pathName, IProject project, IArtifactLocator targetArtifactLocator, IArtifact source, ResourceLocation location, IFile pageFile, String collectorID) {
        super(targetArtifactLocator, source);
        this.name = pathName;
        this.project = project;
        this.pageFile = pageFile;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "adfm-pagedef";
    }

    public boolean isMissing() {
        return this.getLocator().locateArtifact() == null;
    }

    public IFile getPageFile() {
        return this.pageFile;
    }

    protected IArtifact createMissingArtifact() {
        StringBuilder path = new StringBuilder("adfmsrc/");
        path.append(this.name.replace('.', '/'));
        path.append(".xml");
        IResource resource = this.project.findMember(path.toString());
        if (resource == null) {
            resource = this.project;
        }
        ResourceArtifact owner = DependencyModelManager.getInstance().getModel().ensureResourceArtifact(resource);
        return new MissingADFMPageDefinitionArtifact(this.name, (IArtifact)owner, new ResourceLocation(resource, null));
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMPageDefinitionArtifactReference) {
            boolean nameIsEqual;
            ADFMPageDefinitionArtifactReference otherRef = (ADFMPageDefinitionArtifactReference)((Object)object);
            if (this.name != null) {
                nameIsEqual = this.name.equals(otherRef.name);
            } else {
                boolean bl = nameIsEqual = otherRef.name == null;
            }
            if (nameIsEqual) {
                boolean fileIsEqual;
                if (this.pageFile != null) {
                    fileIsEqual = this.pageFile.equals((Object)otherRef.pageFile);
                } else {
                    boolean bl = fileIsEqual = otherRef.pageFile == null;
                }
                return super.equals(object) && fileIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.name);
            hcu.hash((Object)this.pageFile);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
        su.writeResource((IResource)this.pageFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "name", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
        su.readFinalResourceFromStream((Object)this, "pageFile");
    }

    private class MissingADFMPageDefinitionArtifact
    extends ADFPageDefinitionArtifact {
        private static final long serialVersionUID = 1L;

        public MissingADFMPageDefinitionArtifact(String name, IArtifact owner, ResourceLocation location) {
            super(name, owner, location, location, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

