/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMPageDefIteratorIdArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class ADFMPageDefIteratorIdArtifactReference
extends AbstractArtifactReference {
    private static final long serialVersionUID = 1L;
    private volatile transient int hashCode = 0;
    private final String iteratorId;
    private final IFile pageDefFile;

    public ADFMPageDefIteratorIdArtifactReference(String iteratorId, IFile pagedefFile, IArtifactLocator targetArtifactLocator, IArtifact owner, ResourceLocation location, String collectorID) {
        super(targetArtifactLocator, owner);
        this.iteratorId = iteratorId;
        this.pageDefFile = pagedefFile;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    public String getName() {
        return this.iteratorId;
    }

    public String getType() {
        return "adfm-pagedef-iterator-id";
    }

    public boolean isMissing() {
        return this.getLocator().locateArtifact() == null;
    }

    protected IArtifact createMissingArtifact() {
        IFile resource = this.pageDefFile;
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        ResourceArtifact owner = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)resource);
        return new MissingADFMPageDefIteratorIdArtifact(this.iteratorId, (IArtifact)owner, new ResourceLocation((IResource)resource, null));
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMPageDefIteratorIdArtifactReference) {
            boolean bindingIdIsEqual;
            ADFMPageDefIteratorIdArtifactReference otherRef = (ADFMPageDefIteratorIdArtifactReference)((Object)object);
            if (this.iteratorId != null) {
                bindingIdIsEqual = this.iteratorId.equals(otherRef.iteratorId);
            } else {
                boolean bl = bindingIdIsEqual = otherRef.iteratorId == null;
            }
            if (bindingIdIsEqual) {
                boolean fileIsEqual;
                if (this.pageDefFile != null) {
                    fileIsEqual = this.pageDefFile.equals((Object)otherRef.pageDefFile);
                } else {
                    boolean bl = fileIsEqual = otherRef.pageDefFile == null;
                }
                return super.equals(object) && fileIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.iteratorId);
            hcu.hash((Object)this.pageDefFile);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.iteratorId);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.pageDefFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "iteratorId", String.class);
        su.readFinalResourceFromStream((Object)this, "pageDefFile");
    }

    private class MissingADFMPageDefIteratorIdArtifact
    extends ADFMPageDefIteratorIdArtifact {
        private static final long serialVersionUID = 1L;

        public MissingADFMPageDefIteratorIdArtifact(String iteratorId, IArtifact owner, ResourceLocation location) {
            super(iteratorId, owner, location, location, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

