/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ADFMPageDefBindingArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String bindingId;
    private final IFile pageDefFile;
    private volatile int hashCode = 0;

    public ADFMPageDefBindingArtifactLocator(String bindingId, IFile pageDefFile) {
        this.bindingId = bindingId;
        this.pageDefFile = pageDefFile;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        if (this.pageDefFile != null) {
            ResourceArtifact ra;
            IArtifact pageDefnArtifact;
            IPath path = this.pageDefFile.getProjectRelativePath().removeFirstSegments(1).removeFileExtension();
            String pathName = path.toString().replace('/', '.');
            if (this.pageDefFile != null && this.pageDefFile.exists() && (pageDefnArtifact = model.queryArtifactsByOwnerNameAndType((IArtifact)(ra = model.ensureResourceArtifact((IResource)this.pageDefFile)), pathName, "adf-pagedef")) != null) {
                return model.queryArtifactsByOwnerNameAndType(pageDefnArtifact, this.bindingId, "adf-pagedef-binding-child");
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ADFMPageDefBindingArtifactLocator) {
            ADFMPageDefBindingArtifactLocator otherLocator = (ADFMPageDefBindingArtifactLocator)obj;
            if (this.pageDefFile == null && otherLocator.pageDefFile == null && this.bindingId == null && otherLocator.bindingId == null) {
                return true;
            }
            return otherLocator.pageDefFile != null && otherLocator.pageDefFile.equals((Object)this.pageDefFile) && otherLocator.bindingId != null && otherLocator.bindingId.equals(this.bindingId);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.pageDefFile);
            hcu.hash((Object)this.bindingId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.bindingId);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.pageDefFile);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "bindingId", String.class);
        su.readFinalResourceFromStream((Object)this, "pageDefFile");
    }
}

