/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMApplicationArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlUsageIdArtifact;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ADFMDataControlUsageIdArtifactReference
extends AbstractArtifactReference {
    private static final long serialVersionUID = 1L;
    private volatile transient int hashCode = 0;
    private final String usageId;
    private final IProject project;

    public ADFMDataControlUsageIdArtifactReference(String id, IProject project, IArtifactLocator targetArtifactLocator, IArtifact source, ResourceLocation location, String collectorID) {
        super(targetArtifactLocator, source);
        this.usageId = id;
        this.project = project;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    public String getName() {
        return this.usageId;
    }

    public String getType() {
        return "adfm-datacontrol-usageid";
    }

    public boolean isMissing() {
        return this.getLocator().locateArtifact() == null;
    }

    protected IArtifact createMissingArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        IProject resource = this.project;
        Set<IFile> cpxFiles = ADFUtil.getApplicationFilesForProject(this.project);
        block0: for (IFile cpxFile : cpxFiles) {
            ResourceArtifact ra = model.ensureResourceArtifact((IResource)cpxFile);
            Set childArtifacts = model.queryArtifactsByOwner((IArtifact)ra);
            if (childArtifacts == null) continue;
            for (IArtifact childArtifact : childArtifacts) {
                if (!(childArtifact instanceof ADFMApplicationArtifact)) continue;
                resource = cpxFile;
                continue block0;
            }
        }
        ResourceArtifact owner = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)resource);
        return new MissingDataControlUsageIdArtifact((IArtifact)owner, new ResourceLocation((IResource)resource, null));
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMDataControlUsageIdArtifactReference) {
            boolean nameIsEqual;
            ADFMDataControlUsageIdArtifactReference otherRef = (ADFMDataControlUsageIdArtifactReference)((Object)object);
            if (this.usageId != null) {
                nameIsEqual = this.usageId.equals(otherRef.usageId);
            } else {
                boolean bl = nameIsEqual = otherRef.usageId == null;
            }
            return super.equals(object) && nameIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.usageId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.usageId);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "usageId", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }

    private class MissingDataControlUsageIdArtifact
    extends ADFMDataControlUsageIdArtifact {
        private static final long serialVersionUID = 1L;

        public MissingDataControlUsageIdArtifact(IArtifact owner, ResourceLocation location) {
            super(ADFMDataControlUsageIdArtifactReference.this.usageId, owner, location, location, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

