/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMApplicationArtifact;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ADFMDataControlUsageIdArtifactLocator
implements IArtifactLocator {
    private static final long serialVersionUID = 1L;
    private final String usageId;
    private final IProject project;
    private volatile int hashCode = 0;

    public ADFMDataControlUsageIdArtifactLocator(String id, IProject project) {
        this.usageId = id;
        this.project = project;
    }

    public IArtifact locateArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        Set<IFile> cpxFiles = ADFUtil.getApplicationFilesForProject(this.project);
        for (IFile cpxFile : cpxFiles) {
            ResourceArtifact ra = model.ensureResourceArtifact((IResource)cpxFile);
            Set childArtifacts = model.queryArtifactsByOwner((IArtifact)ra);
            if (childArtifacts == null) continue;
            for (IArtifact childArtifact : childArtifacts) {
                IArtifact artifact;
                if (!(childArtifact instanceof ADFMApplicationArtifact) || (artifact = model.queryArtifactsByOwnerNameAndType(childArtifact, this.usageId, "adf-datacontrol-usageid")) == null) continue;
                return artifact;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMDataControlUsageIdArtifactLocator) {
            boolean projectIsEqual;
            ADFMDataControlUsageIdArtifactLocator otherLocator = (ADFMDataControlUsageIdArtifactLocator)object;
            if (this.project != null) {
                projectIsEqual = this.project.equals((Object)otherLocator.project);
            } else {
                boolean bl = projectIsEqual = otherLocator.project == null;
            }
            if (projectIsEqual) {
                boolean tfIsEqual = this.usageId != null ? this.usageId.equals(otherLocator.usageId) : otherLocator.usageId == null;
                return tfIsEqual;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.project);
            hcu.hash((Object)this.usageId);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.usageId);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "usageId", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }
}

