/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.dependency.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifactLocator;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ADFMAdapterDataControlArtifactReference
extends AbstractArtifactReference {
    private static final long serialVersionUID = 1L;
    private volatile transient int hashCode = 0;
    private final String name;
    private final IProject project;

    public ADFMAdapterDataControlArtifactReference(String pathName, IProject project, IArtifactLocator targetArtifactLocator, IArtifact source, ResourceLocation location, String collectorID) {
        super(targetArtifactLocator, source);
        this.name = pathName;
        this.project = project;
        this.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, collectorID));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "adfm-datacontrol-adapter";
    }

    public boolean isMissing() {
        return this.getLocator().locateArtifact() == null;
    }

    protected IArtifact createMissingArtifact() {
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        IProject matchingDCXFile = null;
        Set<IFile> dcxFiles = ADFMAdapterDataControlArtifactLocator.getMatchingDCXFiles(this.name, this.project);
        block0: for (IFile dcxFile : dcxFiles) {
            ResourceArtifact ra = model.ensureResourceArtifact((IResource)dcxFile);
            Set childArtifacts = model.queryArtifactsByOwner((IArtifact)ra);
            if (childArtifacts == null) continue;
            for (IArtifact artifact : childArtifacts) {
                if (!(artifact instanceof ADFMDataControlArtifact)) continue;
                matchingDCXFile = dcxFile;
                continue block0;
            }
        }
        IProject resource = null;
        if (matchingDCXFile != null) {
            resource = matchingDCXFile;
        }
        if (resource == null) {
            resource = this.project;
        }
        ResourceArtifact owner = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)resource);
        return new MissingAdapterDataControlArtifact((IArtifact)owner, new ResourceLocation((IResource)resource, null));
    }

    public boolean equals(Object object) {
        if (object instanceof ADFMAdapterDataControlArtifactReference) {
            boolean nameIsEqual;
            ADFMAdapterDataControlArtifactReference otherRef = (ADFMAdapterDataControlArtifactReference)((Object)object);
            if (this.name != null) {
                nameIsEqual = this.name.equals(otherRef.name);
            } else {
                boolean bl = nameIsEqual = otherRef.name == null;
            }
            return super.equals(object) && nameIsEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash(super.hashCode());
            hcu.hash((Object)this.name);
            this.hashCode = hcu.getHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.project);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "name", String.class);
        su.readFinalProjectFromStream((Object)this, "project");
    }

    private class MissingAdapterDataControlArtifact
    extends ADFMAdapterDataControlArtifact {
        private static final long serialVersionUID = 1L;

        public MissingAdapterDataControlArtifact(IArtifact owner, ResourceLocation location) {
            super(ADFMAdapterDataControlArtifactReference.this.name, owner, location, location, "MISSING");
        }

        @Override
        public boolean isMissing() {
            return true;
        }
    }
}

