/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.view.configuration.WeblogicApplicationExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.validator.AbstractAdfValidationDelegate;
import oracle.eclipse.tools.application.common.services.document.validator.CompositeValidate;
import oracle.eclipse.tools.application.common.services.document.validator.Validate;
import oracle.eclipse.tools.application.common.services.document.validator.ValidateDependentBlock;
import oracle.eclipse.tools.application.common.services.document.validator.ValidateRequiredBlock;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogue;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import oracle.eclipse.tools.common.services.confvalidation.ProblemCatalogueInstance;
import oracle.eclipse.tools.common.services.confvalidation.ValidationContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;

public class WeblogicApplicationValidationDelegate
extends AbstractAdfValidationDelegate {
    private static final List<Validate> VALIDATORS;

    static {
        List<Validate> validates = Collections.EMPTY_LIST;
        if (Platform.getExtensionRegistry() != null) {
            validates = WeblogicApplicationValidationDelegate.createValidates(ProblemCatalogueInstance.getInstance());
        }
        VALIDATORS = Collections.unmodifiableList(validates);
    }

    protected static List<Validate> createValidates(ProblemCatalogue catalogue) {
        WeblogicApplicationExpressionBuilderFactory factory = new WeblogicApplicationExpressionBuilderFactory();
        ArrayList<Validate> validates = new ArrayList<Validate>();
        validates.add((Validate)new ValidateRequiredBlock(factory.createADFDomainLibRefPresent(), WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingEarDomainSharedLibrary")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createADFApplicationLifecycleListenerPresent(), WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingAdfAppicationLifecycleListener")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createWLLifecycleListenerPresent(), WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingWlLifecycleListener")));
        validates.add((Validate)new ValidateRequiredBlock(factory.createXMLParserFactoryPresent(), WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingXmlParserFactory")));
        validates.add((Validate)new ValidateDependentBlock(factory.createXMLParserFactoryPresent(), factory.createJXSaxParserFactoryPresent(), "", WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingSaxParserFactory")));
        validates.add((Validate)new ValidateDependentBlock(factory.createXMLParserFactoryPresent(), factory.createJXDocumentBuilderFactoryPresent(), "", WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingDocumentBuilderFactory")));
        validates.add((Validate)new ValidateDependentBlock(factory.createXMLParserFactoryPresent(), factory.createJXTransformerFactoryPresent(), "", WeblogicApplicationValidationDelegate.getIndex(catalogue, "missingTransformerParserFactory")));
        return validates;
    }

    private static ProblemCatalogueIndex getIndex(ProblemCatalogue catalogue, String id) {
        return catalogue.getIndex("adfWeblogicApplicationXml", id);
    }

    public WeblogicApplicationValidationDelegate() {
        super(new CompositeValidate(VALIDATORS));
    }

    public WeblogicApplicationValidationDelegate(CompositeValidate validator, AbstractVirtualComponentQuery vcQuery, StructuredModelXMLDocumentProvider xmlDocumentProvider) {
        super(validator, vcQuery, xmlDocumentProvider);
    }

    public boolean isEnabled(ValidationContext context) {
        IResource resource = context.getResource();
        if (resource.getType() == 1 && context.isMinimumFacetInstalled("oracle.adf.ear", "11.1.1")) {
            IFile file = (IFile)resource;
            return this.isWeblogicConfigFile(file);
        }
        return false;
    }

    private boolean isWeblogicConfigFile(IFile file) {
        return this.isInEarRoot(file, (IPath)new Path("META-INF/weblogic-application.xml"));
    }
}

