/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration.validator;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.document.validator.CompositeValidate;
import oracle.eclipse.tools.common.services.catalogue.message.CataloguedMessage;
import oracle.eclipse.tools.common.services.confvalidation.AbstractConfigValidationDelegate;
import oracle.eclipse.tools.common.services.confvalidation.ValidationContext;
import oracle.eclipse.tools.webtier.javawebapp.resource.WebRootUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.w3c.dom.Document;

public abstract class AbstractAdfValidationDelegate
extends AbstractConfigValidationDelegate {
    private final CompositeValidate _validator;
    private final AbstractVirtualComponentQuery _vcQuery;
    private final StructuredModelXMLDocumentProvider _xmlDocumentProvider;

    protected AbstractAdfValidationDelegate(CompositeValidate validator) {
        this(validator, (AbstractVirtualComponentQuery)new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery(), new StructuredModelXMLDocumentProvider(StructuredModelXMLDocumentProvider.ModelRequestType.SHARED_READ));
    }

    protected AbstractAdfValidationDelegate(CompositeValidate validator, AbstractVirtualComponentQuery vcQuery, StructuredModelXMLDocumentProvider xmlDocumentProvider) {
        this._validator = validator;
        this._vcQuery = vcQuery;
        this._xmlDocumentProvider = xmlDocumentProvider;
    }

    public List<CataloguedMessage> validate(ValidationContext context) throws ValidationException {
        ArrayList<CataloguedMessage> messages = new ArrayList<CataloguedMessage>();
        IResource resource = context.getResource();
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            try {
                Document doc = this._xmlDocumentProvider.getXMLDocument(file);
                this._validator.validate(file, doc, messages);
            }
            finally {
                this._xmlDocumentProvider.release();
            }
        }
        return messages;
    }

    protected boolean isInWebRoot(IFile file, IPath pathUnderRoot) {
        String runtimePath = WebRootUtil.getRuntimePath((IFile)file);
        if (runtimePath != null && !runtimePath.isEmpty()) {
            Path path = new Path(runtimePath);
            path = pathUnderRoot.isAbsolute() ? path.makeAbsolute() : path.makeRelative();
            return path.equals((Object)pathUnderRoot);
        }
        return false;
    }

    protected boolean isInEarRoot(IFile file, IPath pathUnderRoot) {
        IVirtualFolder rootFolder = this._vcQuery.getWebContentFolder(file.getProject());
        IContainer rootEarFolder = rootFolder.getUnderlyingFolder();
        IFile fileUnderRoot = rootEarFolder.getFile(pathUnderRoot);
        return fileUnderRoot.exists() && fileUnderRoot.getType() == file.getType() && fileUnderRoot.equals((Object)file);
    }
}

