/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.configuration.IConfigurationStrategy;
import oracle.eclipse.tools.adf.view.configuration.WeblogicExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.template.VelocityTemplateContext;
import oracle.eclipse.tools.adf.view.configuration.template.WeblogicTemplateBean;
import oracle.eclipse.tools.application.common.services.document.MergePositionLocator;
import oracle.eclipse.tools.application.common.services.document.XMerge;
import oracle.eclipse.tools.application.common.services.document.configuration.AbstractConfiguration;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariable;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariableResolver;
import oracle.eclipse.tools.application.common.services.document.variable.XPathPrefixVariableResolver;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class WeblogicConfiguration
extends AbstractConfiguration<WeblogicConfigType>
implements IConfigurationStrategy {
    public static final String TEMPLATE_ID = "oracle.eclipse.tools.adf.view.template.weblogic";
    private static String PREFIX_VARIABLE = "prefix";
    private final WeblogicExpressionBuilderFactory exprFactory = new WeblogicExpressionBuilderFactory();

    public void performUpdate(WeblogicConfigType configType, XMerge merge) {
        try {
            TemplateContextType contextType = new TemplateContextType(configType.getId());
            contextType.addResolver((TemplateVariableResolver)new XPathExpressionVariableResolver());
            contextType.addResolver((TemplateVariableResolver)new XPathPrefixVariableResolver(PREFIX_VARIABLE));
            VelocityTemplateContext context = new VelocityTemplateContext(contextType, merge.getTargetDocument());
            String templateBuffer = context.evaluate(this.createTemplateVariables(configType), TEMPLATE_ID, this.createTemplateBean(context));
            if (context.isValid()) {
                merge.merge(templateBuffer, this.createMergePositionLocator(configType));
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)ADFPlugin.getDefault(), (Throwable)e);
        }
    }

    public List<TemplateVariable> createTemplateVariables(WeblogicConfigType type) {
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        switch (type) {
            case ADF_DOMAIN_WEBAPP_LIB_REF: {
                XPathExpressionVariable xVariable = this.createDefaultValidationVariable(this.exprFactory.createADFDomainWebAppLibRefPresent());
                variables.add((TemplateVariable)xVariable);
                xVariable = new XPathExpressionVariable(PREFIX_VARIABLE, PREFIX_VARIABLE, "", null);
                xVariable.addQualifiedXPathExpression(this.exprFactory.createWeblogicRoot());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
        }
        return variables;
    }

    public MergePositionLocator createMergePositionLocator(WeblogicConfigType type) {
        MergePositionLocator locator = new MergePositionLocator();
        switch (type) {
            case ADF_DOMAIN_WEBAPP_LIB_REF: {
                locator.setDefaultParentExpression(this.exprFactory.createWeblogicRoot());
                locator.setOrderSiblingExpression(this.exprFactory.createLibraryRefMerge());
                return locator;
            }
        }
        locator.setDefaultParentExpression(this.exprFactory.createWeblogicRoot());
        return locator;
    }

    @Override
    public ITemplateBean createTemplateBean(VelocityTemplateContext context) {
        return new WeblogicTemplateBean(context);
    }

    public static enum WeblogicConfigType {
        ADF_DOMAIN_WEBAPP_LIB_REF("adfDomainWebappLibraryRef");

        private final String _id;

        private WeblogicConfigType(String id) {
            this._id = id;
        }

        public static WeblogicConfigType getVariableType(String id) {
            WeblogicConfigType[] weblogicConfigTypeArray = WeblogicConfigType.values();
            int n = weblogicConfigTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                WeblogicConfigType type = weblogicConfigTypeArray[n2];
                if (type.getId().equals(id)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getId() {
            return this._id;
        }
    }
}

