/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.configuration;

import com.bea.wlw.template.ITemplateBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.configuration.IConfigurationStrategy;
import oracle.eclipse.tools.adf.view.configuration.WebXmlExpressionBuilderFactory;
import oracle.eclipse.tools.adf.view.configuration.template.VelocityTemplateContext;
import oracle.eclipse.tools.adf.view.configuration.template.WebXmlTemplateBean;
import oracle.eclipse.tools.application.common.services.document.ExpressionBuilder;
import oracle.eclipse.tools.application.common.services.document.MergePositionLocator;
import oracle.eclipse.tools.application.common.services.document.XMerge;
import oracle.eclipse.tools.application.common.services.document.XPathRegionResolver;
import oracle.eclipse.tools.application.common.services.document.configuration.AbstractConfiguration;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariable;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariableResolver;
import oracle.eclipse.tools.application.common.services.document.variable.XPathPrefixVariableResolver;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class WebXMLConfiguration
extends AbstractConfiguration<WebXMLConfigType>
implements IConfigurationStrategy {
    public static final String TEMPLATE_ID = "oracle.eclipse.tools.adf.view.template.web";
    private static String FILTER_NAME_VARIABLE = "filter-name";
    private static String SERVLET_NAME_VARIABLE = "servlet-name";
    private static String PREFIX_VARIABLE = "prefix";
    public static String EJB_NAME_VARIABLE = "ejb-name";
    public static String EJB_TYPE_VARIABLE = "ejb-type";
    public static String EJB_BUSINESS_INTERFACE_VARIABLE = "ejb-business-interface";
    private final WebXmlExpressionBuilderFactory exprFactory = new WebXmlExpressionBuilderFactory();

    public void performUpdate(WebXMLConfigType configType, XMerge merge) {
        try {
            TemplateContextType contextType = new TemplateContextType(configType.getId());
            contextType.addResolver((TemplateVariableResolver)new XPathExpressionVariableResolver());
            contextType.addResolver((TemplateVariableResolver)new XPathPrefixVariableResolver(PREFIX_VARIABLE));
            VelocityTemplateContext context = new VelocityTemplateContext(contextType, merge.getTargetDocument());
            String templateBuffer = context.evaluate(this.createTemplateVariables(configType), TEMPLATE_ID, this.createTemplateBean(context));
            if (context.isValid()) {
                merge.merge(templateBuffer, this.createMergePositionLocator(configType));
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)ADFPlugin.getDefault(), (Throwable)e);
        }
    }

    public static List<WebXMLConfigType> determineDependentBlocks(WebXMLConfigType configType) {
        ArrayList<WebXMLConfigType> dependentTypes = new ArrayList<WebXMLConfigType>();
        switch (configType) {
            case RESOURCES_SERVLET: {
                dependentTypes.add(WebXMLConfigType.RESOURCES_ADF_SERVLET_MAPPING);
                dependentTypes.add(WebXMLConfigType.RESOURCES_AFR_SERVLET_MAPPING);
                dependentTypes.add(WebXMLConfigType.RESOURCES_BI_SERVLET_MAPPING);
                return dependentTypes;
            }
            case TRINIDAD_FILTER: {
                dependentTypes.add(WebXMLConfigType.TRINIDAD_FILTER_MAPPING);
                return dependentTypes;
            }
            case FACES_SERVLET: {
                dependentTypes.add(WebXMLConfigType.FACES_SERVLET_MAPPING);
                return dependentTypes;
            }
            case ADF_SERVLET_FILTER: {
                dependentTypes.add(WebXMLConfigType.ADF_SERVLET_FILTER_MAPPING);
                return dependentTypes;
            }
            case ADF_BINDING_FILTER: {
                dependentTypes.add(WebXMLConfigType.ADF_BINDING_FILTER_MAPPING);
                return dependentTypes;
            }
            case JPS_FILTER: {
                dependentTypes.add(WebXMLConfigType.JPS_FILTER_MAPPING);
                return dependentTypes;
            }
            case BIGAUGE_SERVLET: {
                dependentTypes.add(WebXMLConfigType.BIGAUGE_SERVLET_MAPPING);
                return dependentTypes;
            }
            case BIGRAPH_SERVLET: {
                dependentTypes.add(WebXMLConfigType.BIGRAPH_SERVLET_MAPPING);
                return dependentTypes;
            }
            case MAP_PROXY_SERVLET: {
                dependentTypes.add(WebXMLConfigType.MAP_PROXY_SERVLET_MAPPING);
                return dependentTypes;
            }
            case GATEWAY_SERVLET: {
                dependentTypes.add(WebXMLConfigType.GATEWAY_SERVLET_MAPPING);
                return dependentTypes;
            }
        }
        return dependentTypes;
    }

    public List<TemplateVariable> createTemplateVariables(WebXMLConfigType type) {
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        XPathExpressionVariable xVariable = new XPathExpressionVariable(PREFIX_VARIABLE, PREFIX_VARIABLE, "", null);
        xVariable.addQualifiedXPathExpression(this.exprFactory.createWebAppRoot());
        variables.add((TemplateVariable)xVariable);
        switch (type) {
            case ADF_GLASSFISH_APPCONFIG_LIFECYCLECALLBACK_LISTENER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createAdfGlassfishAppLifecycleCallbackListenerPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createAdfConfigLifecycleCallbackListenerPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case ADF_CONNECTION_LIFECYCLE_CALLBACK_LISTENER: {
                return variables;
            }
            case ADF_SERVLET_FILTER_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createFilterMappingOneArg());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(FILTER_NAME_VARIABLE, "ServletADFFilter", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createADFServletFilterPresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                xVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "Faces Servlet", null);
                xVariable.addQualifiedXPathExpression(this.exprFactory.createFacesServletNamePresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case ADF_BINDING_FILTER_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createFilterMappingOneArg());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(FILTER_NAME_VARIABLE, "adfBindings", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createADFBindingsFilterPresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                xVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "Faces Servlet", null);
                xVariable.addQualifiedXPathExpression(this.exprFactory.createFacesServletNamePresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case BIGAUGE_SERVLET: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createBIGaugeServletPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case BIGAUGE_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createBIGaugeServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "BIGAUGESERVLET", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createBIGaugeServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case BIGRAPH_SERVLET: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createBIGraphServletPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case BIGRAPH_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createBIGraphServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "BIGRAPHSERVLET", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createBIGraphServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case ADF_SERVLET_FILTER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createADFServletFilterPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case ADF_BINDING_FILTER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createADFBindingsFilterPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case FACES_SERVLET: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createFacesServletPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case FACES_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createServletMappingOneArg());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "Faces Servlet", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createFacesServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case JPS_FILTER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createJpsFilterPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case JPS_FILTER_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createFilterMappingOneArg());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(FILTER_NAME_VARIABLE, "JpsFilter", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createJpsFilterNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case LIFECYCLE_SERVLET_CONTEXT_LISTENER: {
                return variables;
            }
            case LOCALIZATION_CONTEXT: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createJstlLocalizationContextParamPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case MAP_PROXY_SERVLET: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createMapProxyServletPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case STATE_SAVING_METHOD_CONTEXT: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createFacesStateSavingContextParamPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case TRINIDAD_CHECK_FILE_MOD_CONTEXT: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createTrinidadCheckFileModContextParamPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case ADF_LIB_RESOURCES_SERVLET: {
                return variables;
            }
            case ADF_LIB_RESOURCES_SERVLET_MAPPING: {
                return variables;
            }
            case ADF_LIBRARY_FILTER: {
                return variables;
            }
            case ADF_LIBRARY_FILTER_MAPPING: {
                return variables;
            }
            case VERSION_STRING_HIDDEN_CONTEXT: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createAdfVersionStringHiddenContextParamPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case WCFRAMEWORK_CONTEXT_LISTENER: {
                return variables;
            }
            case WEB_CENTER_EXECUTOR_CONTEXT_LISTENER: {
                return variables;
            }
            case OJSP_SERVLET_MAPPING: {
                return variables;
            }
            case TRINIDAD_FILTER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createTrinidadFilterPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case TRINIDAD_FILTER_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createFilterMappingOneArg());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(FILTER_NAME_VARIABLE, "trinidad", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createTrinidadFilterNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                xVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "Faces Servlet", null);
                xVariable.addQualifiedXPathExpression(this.exprFactory.createFacesServletNamePresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case OJSP_SERVLET: {
                return variables;
            }
            case MAP_PROXY_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createMapProxyServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "MapProxyServlet", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createMapProxyServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case RESOURCES_SERVLET: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createResourceServletPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case RESOURCES_ADF_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createResourceAdfServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "resources", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createResourceServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case RESOURCES_AFR_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createResourceAfrServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "resources", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createResourceServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case RESOURCES_BI_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createResourceBiServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "resources", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createResourceServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case GATEWAY_SERVLET: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createGatewayServletPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case GATEWAY_SERVLET_MAPPING: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createGatewayServletMappingPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(SERVLET_NAME_VARIABLE, "GatewayServlet", null);
                dependentVariable.addQualifiedXPathExpression(this.exprFactory.createGatewayServletNamePresent());
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                return variables;
            }
            case JSP_JSFF_CONFIG: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createJspJsffConfigPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case EJB_LOCAL_REF: {
                ExpressionBuilder exprBuilder = this.exprFactory.createWebAppRoot();
                ExpressionBuilder emptyExpr = new ExpressionBuilder(String.valueOf(exprBuilder.getExpression()) + "[not(node())]", exprBuilder.getNamespaceContext());
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createEJBLocalRefPresent());
                variables.add((TemplateVariable)xVariable);
                XPathExpressionVariable dependentVariable = new XPathExpressionVariable(EJB_NAME_VARIABLE, EJB_NAME_VARIABLE, type.getEvaluationVariableValue(EJB_NAME_VARIABLE), null);
                dependentVariable.addQualifiedXPathExpression(emptyExpr);
                variables.add((TemplateVariable)dependentVariable);
                xVariable.setDependentVariable(dependentVariable);
                xVariable = new XPathExpressionVariable(EJB_TYPE_VARIABLE, EJB_TYPE_VARIABLE, type.getEvaluationVariableValue(EJB_TYPE_VARIABLE), null);
                xVariable.addQualifiedXPathExpression(emptyExpr);
                variables.add((TemplateVariable)xVariable);
                xVariable = new XPathExpressionVariable(EJB_BUSINESS_INTERFACE_VARIABLE, EJB_BUSINESS_INTERFACE_VARIABLE, type.getEvaluationVariableValue(EJB_BUSINESS_INTERFACE_VARIABLE), null);
                xVariable.addQualifiedXPathExpression(emptyExpr);
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case FACELET_CONTEXT_PARAM_ADF_FACELET_RESOURCE_RESOLVER: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createADFFaceletResourceResolverPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case FACELET_CONTEXT_PARAM_ADF_FACELET_TAG_DECORATOR: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createADFFaceletTagDecoratorPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case FACELET_CONTEXT_PARAM_JSF_FACELET_VIEW_MAPPINGS: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createJSFFaceletViewMappingsPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
            case FACELET_CONTEXT_PARAM_SKIP_COMMENTS: {
                xVariable = this.createDefaultValidationVariable(this.exprFactory.createJSFFaceletsSkipCommentsPresent());
                variables.add((TemplateVariable)xVariable);
                return variables;
            }
        }
        return variables;
    }

    public MergePositionLocator createMergePositionLocator(WebXMLConfigType type) {
        MergePositionLocator locator = new MergePositionLocator();
        switch (type) {
            case TRINIDAD_CHECK_FILE_MOD_CONTEXT: 
            case VERSION_STRING_HIDDEN_CONTEXT: 
            case LOCALIZATION_CONTEXT: 
            case STATE_SAVING_METHOD_CONTEXT: 
            case FACELET_CONTEXT_PARAM_SKIP_COMMENTS: 
            case FACELET_CONTEXT_PARAM_ADF_FACELET_TAG_DECORATOR: 
            case FACELET_CONTEXT_PARAM_ADF_FACELET_RESOURCE_RESOLVER: 
            case FACELET_CONTEXT_PARAM_JSF_FACELET_VIEW_MAPPINGS: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createContextParamRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case ADF_SERVLET_FILTER: 
            case TRINIDAD_FILTER: 
            case ADF_LIBRARY_FILTER: 
            case JPS_FILTER: 
            case ADF_BINDING_FILTER: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createFilterRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case ADF_SERVLET_FILTER_MAPPING: 
            case TRINIDAD_FILTER_MAPPING: 
            case ADF_LIBRARY_FILTER_MAPPING: 
            case JPS_FILTER_MAPPING: 
            case ADF_BINDING_FILTER_MAPPING: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createFilterMappingRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case RESOURCES_SERVLET: 
            case FACES_SERVLET: 
            case BIGRAPH_SERVLET: 
            case BIGAUGE_SERVLET: 
            case MAP_PROXY_SERVLET: 
            case GATEWAY_SERVLET: 
            case OJSP_SERVLET: 
            case ADF_LIB_RESOURCES_SERVLET: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createServletRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case RESOURCES_ADF_SERVLET_MAPPING: 
            case RESOURCES_AFR_SERVLET_MAPPING: 
            case RESOURCES_BI_SERVLET_MAPPING: 
            case FACES_SERVLET_MAPPING: 
            case BIGRAPH_SERVLET_MAPPING: 
            case BIGAUGE_SERVLET_MAPPING: 
            case MAP_PROXY_SERVLET_MAPPING: 
            case GATEWAY_SERVLET_MAPPING: 
            case OJSP_SERVLET_MAPPING: 
            case ADF_LIB_RESOURCES_SERVLET_MAPPING: 
            case OJSP_JSFF_SERVLET_MAPPING: 
            case OJSP_JSPX_SERVLET_MAPPING: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createServletMappingRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER: 
            case ADF_GLASSFISH_APPCONFIG_LIFECYCLECALLBACK_LISTENER: 
            case LIFECYCLE_SERVLET_CONTEXT_LISTENER: 
            case WCFRAMEWORK_CONTEXT_LISTENER: 
            case WEB_CENTER_EXECUTOR_CONTEXT_LISTENER: 
            case ADF_CONNECTION_LIFECYCLE_CALLBACK_LISTENER: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createListenerRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case JSP_JSFF_CONFIG: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createJspConfigRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
            case EJB_LOCAL_REF: {
                locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot(), XPathRegionResolver.RegionType.START);
                locator.setOrderSiblingExpression(this.exprFactory.createEJBLocalRefRoot(), XPathRegionResolver.RegionType.END);
                return locator;
            }
        }
        locator.setDefaultParentExpression(this.exprFactory.createWebAppRoot());
        return locator;
    }

    @Override
    public ITemplateBean createTemplateBean(VelocityTemplateContext context) {
        return new WebXmlTemplateBean(context);
    }

    public static enum WebXMLConfigType {
        ADF_SERVLET_FILTER("adfServletFilter"),
        ADF_SERVLET_FILTER_MAPPING("adfServletFilterMapping"),
        RESOURCES_SERVLET("resourcesServlet"),
        RESOURCES_ADF_SERVLET_MAPPING("resourcesAdfServletMapping"),
        RESOURCES_AFR_SERVLET_MAPPING("resourcesAfrServletMapping"),
        RESOURCES_BI_SERVLET_MAPPING("resourcesBiServletMapping"),
        FACES_SERVLET("facesServlet"),
        FACES_SERVLET_MAPPING("facesServletMapping"),
        TRINIDAD_FILTER("trinidadFilter"),
        TRINIDAD_FILTER_MAPPING("trinidadFilterMapping"),
        BIGRAPH_SERVLET("bigraphServlet"),
        BIGRAPH_SERVLET_MAPPING("bigraphServletMapping"),
        BIGAUGE_SERVLET("bigaugeServlet"),
        BIGAUGE_SERVLET_MAPPING("bigaugeServletMapping"),
        MAP_PROXY_SERVLET("mapProxyServlet"),
        MAP_PROXY_SERVLET_MAPPING("mapProxyServletMapping"),
        GATEWAY_SERVLET("gatewayServlet"),
        GATEWAY_SERVLET_MAPPING("gatewayServletMapping"),
        TRINIDAD_CHECK_FILE_MOD_CONTEXT("trinidadCheckFileModContext"),
        VERSION_STRING_HIDDEN_CONTEXT("versionStringHiddenContext"),
        ADF_LIBRARY_FILTER("adfLibraryFilter"),
        ADF_LIBRARY_FILTER_MAPPING("adfLibraryFilterMapping"),
        OJSP_SERVLET("ojspServlet"),
        OJSP_SERVLET_MAPPING("ojspServletMapping"),
        ADF_LIB_RESOURCES_SERVLET("adfLibResourcesServlet"),
        ADF_LIB_RESOURCES_SERVLET_MAPPING("adfLibResourcesServletMapping"),
        ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER("adfConfigLifecycleCallbackListener"),
        ADF_GLASSFISH_APPCONFIG_LIFECYCLECALLBACK_LISTENER("adfGlassfishAppConfigLifeCycleCallBackListener"),
        GLASSFISH_ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER("glassfishAdfConfigLifecycleCallbackListener"),
        LIFECYCLE_SERVLET_CONTEXT_LISTENER("lifecyleServletContextListener"),
        WCFRAMEWORK_CONTEXT_LISTENER("wcframeworkContextListener"),
        WEB_CENTER_EXECUTOR_CONTEXT_LISTENER("webCenterExecutorContextListener"),
        ADF_CONNECTION_LIFECYCLE_CALLBACK_LISTENER("adfConnectionLifecycleCallbackListener"),
        JPS_FILTER_MAPPING("jpsFilterMapping"),
        JPS_FILTER("jpsFilter"),
        LOCALIZATION_CONTEXT("localizationContext"),
        STATE_SAVING_METHOD_CONTEXT("stateSavingMethodContext"),
        OJSP_JSFF_SERVLET_MAPPING("ojspJsffServletMapping"),
        OJSP_JSPX_SERVLET_MAPPING("ojspJspxServletMapping"),
        ADF_BINDING_FILTER("adfBindingFilter"),
        ADF_BINDING_FILTER_MAPPING("adfBindingFilterMapping"),
        JSP_JSFF_CONFIG("jspJsffConfig"),
        EJB_LOCAL_REF("ejbLocalRef"),
        FACELET_CONTEXT_PARAM_SKIP_COMMENTS("faceletSkipComments"),
        FACELET_CONTEXT_PARAM_ADF_FACELET_TAG_DECORATOR("faceletAdfFaceletTagDecorator"),
        FACELET_CONTEXT_PARAM_ADF_FACELET_RESOURCE_RESOLVER("faceletAdfFaceletResourceResolver"),
        FACELET_CONTEXT_PARAM_JSF_FACELET_VIEW_MAPPINGS("faceletJsfFaceletViewMappings");

        private final String _id;
        private Map<String, String> evalVars;

        private WebXMLConfigType(String id) {
            this._id = id;
        }

        public static WebXMLConfigType getVariableType(String id) {
            WebXMLConfigType[] webXMLConfigTypeArray = WebXMLConfigType.values();
            int n = webXMLConfigTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                WebXMLConfigType type = webXMLConfigTypeArray[n2];
                if (type.getId().equals(id)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getId() {
            return this._id;
        }

        public void setEvaluationVariables(Map<String, String> evalVars) {
            this.evalVars = evalVars;
        }

        public String getEvaluationVariableValue(String key) {
            String value = null;
            if (this.evalVars != null) {
                value = this.evalVars.get(key);
            }
            return value;
        }
    }
}

